/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbcx.IfxConnectionPoolDataSource;
import com.informix.jdbcx.IfxReUsableConnection;
import com.informix.jdbcx.IfxSqliConnReUsableConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class IfxPooledConnection
implements PooledConnection {
    private static final Object logger = Trace.getLoggerForClass(IfxPooledConnection.class);
    private Vector listeners = null;
    private Properties DSProp = null;
    private IfxReUsableConnection conn = null;
    private IfxConnectionPoolDataSource cpds = null;
    protected long timeInPool = 0L;
    Trace trace = null;

    public IfxPooledConnection() throws SQLException {
        this.listeners = new Vector();
        this.DSProp = null;
        this.conn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IfxPooledConnection(String luser, String lpasswd, IfxConnectionPoolDataSource tcpds) throws SQLException {
        int limit;
        this.cpds = tcpds;
        this.conn = null;
        this.listeners = new Vector();
        this.DSProp = this.cpds.getDsProperties();
        String value = this.DSProp.getProperty("IFMX_CPM_MAX_CONNECTIONS");
        if (value == null || value.length() == 0) {
            value = "-1";
        }
        if ((limit = Integer.parseInt(value)) != -1 && this.cpds.getConnectionCount() >= limit) {
            throw IfxErrMsg.getLocSQLException(-79831, this.cpds.getIfxCLIENT_LOCALE());
        }
        this.establishConnection(luser, lpasswd);
        Properties properties = this.DSProp;
        synchronized (properties) {
            this.cpds.addToReferenceList(this);
        }
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "IfxPooledConnection.java:IfxPooledConnection() got pooled conn.");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPooledConnection.java:getConnection() callled");
        }
        if (this.conn != null) {
            ((IfxSqliConnect)((Object)this.conn)).isOpen = true;
        }
        return (Connection)((Object)this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.conn == null) {
            return;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPooledConnection.java:close() callled");
        }
        IfxConnectionPoolDataSource ifxConnectionPoolDataSource = this.cpds;
        synchronized (ifxConnectionPoolDataSource) {
            try {
                this.conn.hardClose();
            }
            finally {
                this.cpds.removeFromReferenceList(this);
            }
        }
        this.conn = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPooledConnection.java:close() exited");
        }
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.addElement(listener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "IfxPooledConnection.java:removeConnectionEventListener() called");
        }
        this.listeners.removeElement(listener);
    }

    void notifyListeners() throws SQLException {
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "IfxPooledConnection.java:notifyListeners() callled");
        }
        this.notifyListenersOfErrors(null);
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "IfxPooledConnection.java:notifyListeners() exited.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListenersOfErrors(SQLException e) throws SQLException {
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "IfxPooledConnection.java:notifyListenersOfErrors() callled");
        }
        int numListeners = 0;
        int i = 0;
        ConnectionEventListener eventListener = null;
        Vector clonedListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            clonedListener = (Vector)this.listeners.clone();
        }
        numListeners = clonedListener.size();
        for (i = 0; i < numListeners; ++i) {
            eventListener = (ConnectionEventListener)clonedListener.elementAt(i);
            if (e != null) {
                eventListener.connectionErrorOccurred(new ConnectionEvent(this, e));
                throw e;
            }
            eventListener.connectionClosed(new ConnectionEvent(this));
        }
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "IfxPooledConnection.java:notifyListenersOfErrors() exited.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishConnection(String luser, String lpasswd) throws SQLException {
        String urlString = null;
        String dbName = null;
        String host = null;
        String port = null;
        host = this.DSProp.getProperty("IFXHOST");
        port = this.DSProp.getProperty("PORTNO");
        if (host != null && port != null) {
            urlString = host + ":" + port;
        }
        if ((dbName = this.DSProp.getProperty("DATABASE")) != null) {
            try {
                this.conn = this.getClientServerReUsable(luser, lpasswd, urlString, dbName);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getLocSQLException(-79716, e.toString(), this.cpds.getIfxCLIENT_LOCALE());
            }
            finally {
                Properties properties = this.DSProp;
                synchronized (properties) {
                    this.DSProp.setProperty("DATABASE", dbName);
                }
            }
        }
        throw IfxErrMsg.getLocSQLException(-79716, "Missing DATABASE Property", this.cpds.getIfxCLIENT_LOCALE());
        if (TraceFlag.isTraceEnabled() && this.conn != null) {
            this.trace = ((IfxSqliConnect)((Object)this.conn)).getTrace();
            this.trace.writeTrace(logger, 1, "IfxPooledConnection:establishConnection() go a conn.");
        }
    }

    public void setTimeInPool() {
        this.timeInPool = System.currentTimeMillis();
    }

    private IfxReUsableConnection getClientServerReUsable(String luser, String lpasswd, String urlString, String dbName) throws SQLException {
        if (!this.cpds.checkIsDirect()) {
            IfxSqliConnReUsableConnection scrc = null;
            scrc = new IfxSqliConnReUsableConnection(luser, lpasswd, this, urlString, this.DSProp, dbName);
            return scrc;
        }
        Constructor directReUsableCons = this.cpds.getReUsableCons();
        Object[] objs = new Object[]{this, urlString, this.DSProp, dbName};
        if (directReUsableCons != null) {
            try {
                this.conn = (IfxReUsableConnection)directReUsableCons.newInstance(objs);
                return this.conn;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw IfxErrMsg.getLocSQLException(-79716, e.toString());
            }
        }
        try {
            String className = "com.informix.jdbcx.IfxDirConnReUsableConnection";
            Class<?> clsRef = Class.forName(className);
            if (urlString == null) {
                urlString = "";
            }
            if (dbName == null) {
                dbName = "";
            }
            Class[] classArgs = new Class[]{this.getClass(), urlString.getClass(), this.DSProp.getClass(), dbName.getClass()};
            Constructor<?> cons = clsRef.getConstructor(classArgs);
            this.cpds.setReUsableCons(cons);
            this.conn = (IfxReUsableConnection)cons.newInstance(objs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw IfxErrMsg.getLocSQLException(-79716, e.toString());
        }
        return this.conn;
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPooledConnection:addStatementEventListener(StatementEventListener)not supported");
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPooledConnection:addStatementEventListener(StatementEventListener)not supported");
        }
    }
}

