/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.msg.sqlBundle;
import com.informix.util.IfxErrMsg;
import java.util.ArrayList;
import java.util.Locale;

public class IfxMessage {
    private static final short MsgBufInitSize = 256;
    private static String FILE_CALS_IEM = "cals";
    private static String FILE_CSM_IEM = "csm";
    private static String FILE_CSS_IEM = "css";
    private static String FILE_EAMI_IEM = "eami";
    private static String FILE_ISAM_IEM = "isam";
    private static String FILE_MIAPI_IEM = "miapi";
    private static String FILE_MLS2_IEM = "mls2";
    private static String FILE_MLS_IEM = "mls";
    private static String FILE_NALS_IEM = "nals";
    private static String FILE_NERM_IEM = "nerm";
    private static String FILE_NET_IEM = "net";
    private static String FILE_NETSRV_IEM = "netsrv";
    private static String FILE_OPTICAL_IEM = "optical";
    private static String FILE_RDS_IEM = "rds";
    private static String FILE_SECURITY_IEM = "security";
    private static String FILE_SHELL_IEM = "shell";
    private static String FILE_SQL_IEM = "sql";
    private static String FILE_SQLI_IEM = "sqli";
    private static String FILE_UTIL_IEM = "util";
    private static String FILE_XOPEN_IEM = "xopen";
    private static String FILE_XPS_IEM = "xps";
    private static String FILE_JDBC_IEM = "jdbc";
    private static String FILE_JDBCMINOR_IEM = "jdbcminor";
    private static String FILE_OS_IEM = "os";
    private static String FILE_SBLOB_IEM = "sblob";
    private static String FILE_DEFAULT_IEM = "os";
    static ArrayList<bundleMap> bundleMapElements = new ArrayList(50);

    private static String getBundleName(int sqlcode) {
        String bundle = FILE_DEFAULT_IEM;
        try {
            int poscode = Math.abs(sqlcode);
            int n = bundleMapElements.size();
            for (int i = 0; i < n; ++i) {
                bundleMap bundleElement = bundleMapElements.get(i);
                if (bundleElement.first > poscode) break;
                if (bundleElement.last < poscode) continue;
                bundle = bundleElement.filename;
                break;
            }
            if (bundle.equals(FILE_SQL_IEM)) {
                String sqlBundleName = sqlBundle.getBundleName(sqlcode);
                if (sqlBundleName != null) {
                    return sqlBundleName;
                }
                bundle = FILE_DEFAULT_IEM;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "com.informix.msg." + bundle;
    }

    public static String getMessage(int sqlcode) {
        String sqlcodeStr = Integer.toString(sqlcode);
        String bundle = IfxMessage.getBundleName(sqlcode);
        String msg = IfxErrMsg.getErrMsg(sqlcodeStr, bundle, (Locale)null);
        return msg;
    }

    public static String getMessage(int sqlcode, String locale) {
        String sqlcodeStr = Integer.toString(sqlcode);
        String bundle = IfxMessage.getBundleName(sqlcode);
        String msg = IfxErrMsg.getErrMsg(sqlcodeStr, bundle, locale);
        return msg;
    }

    public static String getMessage(int sqlcode, Locale loc) {
        String sqlcodeStr = Integer.toString(sqlcode);
        String bundle = IfxMessage.getBundleName(sqlcode);
        String msg = IfxErrMsg.getErrMsg(sqlcodeStr, bundle, loc);
        return msg;
    }

    public static String getMessage(String msgtext, String arg1, String locale) {
        int index2;
        if (msgtext == null) {
            return arg1;
        }
        int index1 = msgtext.indexOf("%s");
        if (index1 >= 0 || (index1 = msgtext.indexOf("%d")) >= 0) {
            index2 = index1 + 2;
        } else {
            index1 = msgtext.indexOf("%ld");
            if (index1 >= 0) {
                index2 = index1 + 3;
            } else {
                return msgtext;
            }
        }
        StringBuffer msg = new StringBuffer(256).append(msgtext.substring(0, index1)).append(arg1).append(msgtext.substring(index2));
        return msg.toString();
    }

    public static String getMessage(int sqlcode, String arg1, String locale) {
        String bundle = IfxMessage.getBundleName(sqlcode);
        String sqlcodeStr = Integer.toString(sqlcode);
        String msg = IfxErrMsg.getErrMsg(sqlcodeStr, bundle, locale);
        return IfxMessage.getMessage(msg, arg1, null);
    }

    public static String getMessage(String msgtext, String arg1, String arg2, String locale) {
        return IfxMessage.getMessage(IfxMessage.getMessage(msgtext, arg1, locale), arg2, locale);
    }

    public static String getMessage(int sqlcode, String arg1, String arg2, String locale) {
        String bundle = IfxMessage.getBundleName(sqlcode);
        String sqlcodeStr = Integer.toString(sqlcode);
        String msg = IfxErrMsg.getErrMsg(sqlcodeStr, bundle, locale);
        return IfxMessage.getMessage(msg, arg1, arg2, locale);
    }

    public static String getSQLSTATE(int sqlcode) {
        String bundle = "com.informix.msg.itoxmsg";
        String sqlcodeStr = Integer.toString(sqlcode);
        String msg = IfxErrMsg.getErrMsg(sqlcodeStr, bundle);
        if (msg == null) {
            return "IX000";
        }
        return msg;
    }

    static {
        new bundleMap(2, 79, FILE_OS_IEM);
        new bundleMap(100, 199, FILE_ISAM_IEM);
        new bundleMap(200, 999, FILE_SQL_IEM);
        new bundleMap(1200, 1299, FILE_RDS_IEM);
        new bundleMap(1800, 1999, FILE_SQLI_IEM);
        new bundleMap(5000, 5800, FILE_CSM_IEM);
        new bundleMap(5801, 5824, FILE_SQL_IEM);
        new bundleMap(5850, 5999, FILE_SQL_IEM);
        new bundleMap(7000, 7199, FILE_OPTICAL_IEM);
        new bundleMap(7400, 7999, FILE_MIAPI_IEM);
        new bundleMap(8200, 8299, FILE_SQL_IEM);
        new bundleMap(8300, 8330, FILE_SQL_IEM);
        new bundleMap(9200, 9299, FILE_SQL_IEM);
        new bundleMap(9400, 9499, FILE_SQL_IEM);
        new bundleMap(9600, 9999, FILE_SQL_IEM);
        new bundleMap(12000, 12214, FILE_SBLOB_IEM);
        new bundleMap(12215, 12249, FILE_ISAM_IEM);
        new bundleMap(12250, 12499, FILE_SBLOB_IEM);
        new bundleMap(12800, 12999, FILE_EAMI_IEM);
        new bundleMap(14500, 14700, FILE_CSS_IEM);
        new bundleMap(19800, 19999, FILE_SQL_IEM);
        new bundleMap(21400, 21449, FILE_SECURITY_IEM);
        new bundleMap(21500, 21599, FILE_ISAM_IEM);
        new bundleMap(21500, 21599, FILE_ISAM_IEM);
        new bundleMap(23100, 23199, FILE_CALS_IEM);
        new bundleMap(23501, 24500, FILE_XPS_IEM);
        new bundleMap(25500, 25599, FILE_NETSRV_IEM);
        new bundleMap(25600, 25699, FILE_NERM_IEM);
        new bundleMap(25700, 26999, FILE_SQL_IEM);
        new bundleMap(27000, 29999, FILE_NET_IEM);
        new bundleMap(32000, 32099, FILE_ISAM_IEM);
        new bundleMap(32100, 32199, FILE_MLS_IEM);
        new bundleMap(32500, 32699, FILE_MLS2_IEM);
        new bundleMap(32765, 32766, FILE_OS_IEM);
        new bundleMap(33400, 33499, FILE_SHELL_IEM);
        new bundleMap(33500, 33599, FILE_UTIL_IEM);
        new bundleMap(34000, 34999, FILE_NALS_IEM);
        new bundleMap(36000, 36999, FILE_XOPEN_IEM);
        new bundleMap(73000, 76000, FILE_MIAPI_IEM);
        new bundleMap(79700, 79999, FILE_JDBC_IEM);
        new bundleMap(80000, 89999, FILE_JDBCMINOR_IEM);
    }

    public static class bundleMap {
        int first;
        int last;
        String filename;

        bundleMap(int first, int last, String filename) {
            this.first = first;
            this.last = last;
            this.filename = filename;
            bundleMapElements.add(this);
        }
    }
}

