/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.jdbc.IfxConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import com.informix.util.stringUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;

public class dateUtil {
    private static final Object logger = Trace.getLoggerForClass(dateUtil.class);
    private static final ThreadLocal<Calendar> localCalendar = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };
    public static final int NUMSECSINHR = 3600;
    public static final int NUMSECSINDY = 86400;
    public static final int NUMSECSINWK = 604800;
    public static final int NUMSECSINMN = 18144000;
    public static final int NUMSECSINYR = 217728000;
    private static final char ERA_ID = 'E';
    private static final char DAY_ID = 'D';
    private static final char MONTH_ID = 'M';
    private static final char YEAR_ID = 'Y';
    private static final char PERCENT = '%';
    private static final char CQUOTE = '\'';
    private static final char SPACE = ' ';
    private static final char FOUR_DIGIT_YEAR = '4';
    private static final char TWO_DIGIT_YEAR = '2';
    private static final String SLASH = "/";
    private static final String COLON = ":";
    private static final String HYPHEN = "-";
    private static final String PERIOD = ".";
    private static final String NOSEP = "0";
    private static final String UNDERSCORE = "_";
    private static final String SQUOTE = "'";
    private static final String CDIRTAG = ";;;;";
    private static final String WDIRTAG = ";;;;;";
    private static final String ZEROS = "000000000";
    private static final String AM = "AM";
    private static final String PM = "PM";
    private static final String NONALPHANUMTOKS = "/-.: ~`!@#$%^&*()_+=\t\n\r\b{}[]|\\:;'\"<>,?";
    static int[] numDaysArr = new int[12];

    public static int calcNumDays(String date) {
        if (!dateUtil.isValidDate(date)) {
            return -1;
        }
        dateUtil.numDaysArr[0] = 0;
        dateUtil.numDaysArr[1] = 31;
        dateUtil.numDaysArr[2] = 59;
        dateUtil.numDaysArr[3] = 90;
        dateUtil.numDaysArr[4] = 120;
        dateUtil.numDaysArr[5] = 151;
        dateUtil.numDaysArr[6] = 181;
        dateUtil.numDaysArr[7] = 212;
        dateUtil.numDaysArr[8] = 243;
        dateUtil.numDaysArr[9] = 273;
        dateUtil.numDaysArr[10] = 304;
        dateUtil.numDaysArr[11] = 334;
        StringTokenizer dateT = new StringTokenizer(date, HYPHEN);
        int nd = 0;
        if (dateUtil.isValidDate(date)) {
            int y = stringUtil.stringToInt(dateT.nextToken());
            int m = stringUtil.stringToInt(dateT.nextToken());
            int d = stringUtil.stringToInt(dateT.nextToken());
            nd = numDaysArr[m - 1] + d;
            if (m > 2 && dateUtil.isLeapYear(y)) {
                ++nd;
            }
        }
        return nd;
    }

    public static boolean isValidTimeStamp(String timeStamp) {
        StringTokenizer tsT = new StringTokenizer(timeStamp, " ");
        if (tsT.countTokens() != 2) {
            return false;
        }
        if (!dateUtil.isValidDate(tsT.nextToken())) {
            return false;
        }
        String time = tsT.nextToken();
        if (time.indexOf(46) == -1) {
            return dateUtil.isValidTime(time);
        }
        StringTokenizer tT = new StringTokenizer(time, PERIOD);
        if (tT.countTokens() != 2) {
            return false;
        }
        if (!dateUtil.isValidTime(tT.nextToken())) {
            return false;
        }
        String f = tT.nextToken();
        return stringUtil.isANum(f) && f.length() <= 8;
    }

    public static String IfxTimeStamp(String s) {
        if (s.length() > 25) {
            return s.substring(0, 25);
        }
        return s;
    }

    public static boolean isValidTime(String time) {
        StringTokenizer tT = new StringTokenizer(time, COLON);
        if (tT.countTokens() != 3) {
            return false;
        }
        int h = stringUtil.stringToInt(tT.nextToken());
        if (h < 0 || h > 23) {
            return false;
        }
        int m = stringUtil.stringToInt(tT.nextToken());
        if (m < 0 || m > 59) {
            return false;
        }
        int s = stringUtil.stringToInt(tT.nextToken());
        return s >= 0 && s <= 59;
    }

    public static boolean isValidDate(String date) {
        StringTokenizer dT = new StringTokenizer(date, HYPHEN);
        if (dT.countTokens() != 3) {
            return false;
        }
        String tmp = dT.nextToken();
        if (tmp.length() != 4) {
            return false;
        }
        int y = stringUtil.stringToInt(tmp);
        int m = stringUtil.stringToInt(dT.nextToken());
        if (m < 1 || m > 12) {
            return false;
        }
        int d = stringUtil.stringToInt(dT.nextToken());
        switch (m) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (d >= 1 && d <= 31) break;
                return false;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (d >= 1 && d <= 30) break;
                return false;
            }
            case 2: {
                int max = 28;
                if (y % 4 == 0 && y % 100 != 0 || y % 400 == 0) {
                    max = 29;
                }
                if (d >= 1 && d <= max) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static long gregToJulian(String date) {
        int y = stringUtil.stringToInt(date.substring(0, 4));
        int m = stringUtil.stringToInt(date.substring(5, 7));
        int d = stringUtil.stringToInt(date.substring(8, 10));
        long jdate = 1461 * (y + 4800 + (m - 14) / 12) / 4 + 367 * (m - 2 - 12 * ((m - 14) / 12)) / 12 - 3 * ((y + 4900 + (m - 14) / 12) / 100) / 4 + d - 32075;
        return jdate;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    private static String getdbDateStr(Date date, String dateLocale, String dbDateFormat) throws SQLException {
        String pattern = "";
        String retStr = "";
        String dbDatetok = null;
        boolean sepfound = false;
        int datefmtlen = 0;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        if (dbDateFormat.length() < 4 || dbDateFormat.length() > 6) {
            throw IfxErrMsg.getSQLException(-79797, "\"" + dbDateFormat + "\"", clLocale);
        }
        String temptok = dbDateFormat.substring(dbDateFormat.length() - 1);
        if (temptok.equals(SLASH) || temptok.equals(HYPHEN) || temptok.equals(PERIOD)) {
            dbDatetok = temptok;
            sepfound = true;
        } else if (temptok.equals(NOSEP)) {
            dbDatetok = "";
            sepfound = true;
        } else {
            if (!(temptok.equals("E") || temptok.equals("2") || temptok.equals("4") || temptok.equals("M") || temptok.equals("D"))) {
                sepfound = true;
            }
            dbDatetok = SLASH;
        }
        datefmtlen = sepfound ? dbDateFormat.length() - 1 : dbDateFormat.length();
        block7: for (int i = 0; i < datefmtlen; ++i) {
            switch (dbDateFormat.charAt(i)) {
                case 'E': {
                    if (i == 0) {
                        pattern = pattern + "GGG ";
                        continue block7;
                    }
                    pattern = pattern + " GGG ";
                    continue block7;
                }
                case 'D': {
                    pattern = pattern + "dd" + dbDatetok;
                    continue block7;
                }
                case 'M': {
                    pattern = pattern + "MM" + dbDatetok;
                    continue block7;
                }
                case 'Y': {
                    if (i + 1 == datefmtlen) {
                        throw IfxErrMsg.getSQLException(-79798, "\"" + dbDateFormat + "\"", clLocale);
                    }
                    if (dbDateFormat.charAt(i + 1) == '2' || dbDateFormat.charAt(i + 1) == '4') continue block7;
                    throw IfxErrMsg.getSQLException(-79799, "\"" + dbDateFormat + "\"", clLocale);
                }
                case '2': 
                case '4': {
                    if (i == 0 || dbDateFormat.charAt(i - 1) != 'Y') {
                        throw IfxErrMsg.getSQLException(-79800, "\"" + dbDateFormat + "\"", clLocale);
                    }
                    if (dbDateFormat.charAt(i) == '2') {
                        pattern = pattern + "yy" + dbDatetok;
                        continue block7;
                    }
                    pattern = pattern + "yyyy" + dbDatetok;
                    continue block7;
                }
                default: {
                    throw IfxErrMsg.getSQLException(-79801, "\"" + dbDateFormat + "\"", clLocale);
                }
            }
        }
        if (dbDatetok.equals("")) {
            retStr = dateUtil.formatDate(date, clLocale, pattern);
            return retStr;
        }
        retStr = dateUtil.formatDate(date, clLocale, pattern.substring(0, pattern.length() - 1));
        return retStr;
    }

    private static String getglDateStr(Object date, String dateLocale, String dbDateTimeFormat, boolean nativeSQL) throws SQLException {
        String pattern = "";
        String retStr = "";
        boolean quote_letters = false;
        String[] dateField = new String[5];
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        block35: for (int i = 0; i < dbDateTimeFormat.length(); ++i) {
            switch (dbDateTimeFormat.charAt(i)) {
                case '%': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        pattern = pattern + "%";
                        continue block35;
                    }
                    if (!quote_letters) continue block35;
                    pattern = pattern + SQUOTE;
                    quote_letters = false;
                    continue block35;
                }
                case '\'': {
                    if (quote_letters) {
                        pattern = pattern + SQUOTE + SQUOTE + SQUOTE;
                        quote_letters = false;
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + SQUOTE;
                    continue block35;
                }
                case 'a': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        Locale swiss_fr_loc = new Locale("fr", "CH", "");
                        Locale turkey_loc = new Locale("tr", "TR", "");
                        if (nativeSQL && (clLocale.toString().equals(turkey_loc.toString()) || clLocale.toString().equals(Locale.CANADA_FRENCH.toString()) || clLocale.toString().equals(swiss_fr_loc.toString()))) {
                            if (quote_letters) {
                                pattern = pattern + dateUtil.getInfmxglPattern(date, 'a', clLocale);
                                continue block35;
                            }
                            pattern = pattern + SQUOTE + dateUtil.getInfmxglPattern(date, 'a', clLocale);
                            quote_letters = true;
                            continue block35;
                        }
                        pattern = pattern + "E";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "a";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "a";
                    quote_letters = true;
                    continue block35;
                }
                case 'A': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        pattern = pattern + "EEEEE";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "A";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "A";
                    quote_letters = true;
                    continue block35;
                }
                case 'b': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        Locale swiss_fr_loc = new Locale("fr", "CH", "");
                        if (nativeSQL && (clLocale.toString().equals(Locale.JAPAN.toString()) || clLocale.toString().equals(Locale.CANADA_FRENCH.toString()) || clLocale.toString().equals(swiss_fr_loc.toString()))) {
                            if (quote_letters) {
                                pattern = pattern + dateUtil.getInfmxglPattern(date, 'b', clLocale);
                                continue block35;
                            }
                            pattern = pattern + SQUOTE + dateUtil.getInfmxglPattern(date, 'b', clLocale);
                            quote_letters = true;
                            continue block35;
                        }
                        pattern = pattern + "MMM";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "b";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "b";
                    quote_letters = true;
                    continue block35;
                }
                case 'B': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        if (nativeSQL && clLocale.toString().equals(Locale.JAPAN.toString())) {
                            if (quote_letters) {
                                pattern = pattern + dateUtil.getInfmxglPattern(date, 'B', clLocale);
                                continue block35;
                            }
                            pattern = pattern + SQUOTE + dateUtil.getInfmxglPattern(date, 'B', clLocale);
                            quote_letters = true;
                            continue block35;
                        }
                        pattern = pattern + "MMMMM";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "B";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "B";
                    quote_letters = true;
                    continue block35;
                }
                case 'c': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        if (date instanceof Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + dbDateTimeFormat + "\"", clLocale);
                        }
                        pattern = pattern + "yyyy-MM-dd HH:mm:ss";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "c";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "c";
                    quote_letters = true;
                    continue block35;
                }
                case 'C': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        pattern = pattern + CDIRTAG + "yyyy";
                        continue block35;
                    }
                    if (i >= 2 && dbDateTimeFormat.charAt(i - 1) == 'E' && dbDateTimeFormat.charAt(i - 2) == '%') {
                        pattern = pattern + CDIRTAG + "yyyy" + " GGGGG ";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "C";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "C";
                    quote_letters = true;
                    continue block35;
                }
                case 'd': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        pattern = pattern + "dd";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "d";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "d";
                    quote_letters = true;
                    continue block35;
                }
                case 'D': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        pattern = pattern + "MM/dd/yy";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "D";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "D";
                    quote_letters = true;
                    continue block35;
                }
                case 'e': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        pattern = pattern + "d";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "e";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "e";
                    quote_letters = true;
                    continue block35;
                }
                case 'E': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') continue block35;
                    if (quote_letters) {
                        pattern = pattern + "E";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "E";
                    quote_letters = true;
                    continue block35;
                }
                case 'F': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        if (date instanceof Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + dbDateTimeFormat + "\"", clLocale);
                        }
                        if (i + 1 > dbDateTimeFormat.length() || Character.isDigit(dbDateTimeFormat.charAt(i + 1))) continue block35;
                        String fracpart = Integer.toString(((Timestamp)date).getNanos());
                        if (fracpart.length() < 2) {
                            fracpart = fracpart.substring(0, fracpart.length()) + ZEROS.substring(0, 2 - fracpart.length());
                        } else if (fracpart.length() > 2) {
                            fracpart = fracpart.substring(0, 2);
                        }
                        pattern = pattern + PERIOD + fracpart;
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "F";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "F";
                    quote_letters = true;
                    continue block35;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': {
                    if (i >= 2 && dbDateTimeFormat.charAt(i - 1) == 'F' && dbDateTimeFormat.charAt(i - 2) == '%') {
                        int idx = stringUtil.stringToInt(dbDateTimeFormat.substring(i, i + 1));
                        String fracpart = Integer.toString(((Timestamp)date).getNanos());
                        if (fracpart.length() < idx) {
                            fracpart = fracpart.substring(0, fracpart.length()) + ZEROS.substring(0, idx - fracpart.length());
                        } else if (fracpart.length() > idx) {
                            fracpart = fracpart.substring(0, idx);
                        }
                        pattern = pattern + PERIOD + fracpart;
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + dbDateTimeFormat.substring(i, i + 1);
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + dbDateTimeFormat.substring(i, i + 1);
                    quote_letters = true;
                    continue block35;
                }
                case 'h': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        Locale swiss_fr_loc = new Locale("fr", "CH", "");
                        if (nativeSQL && (clLocale.toString().equals(Locale.JAPAN.toString()) || clLocale.toString().equals(Locale.CANADA_FRENCH.toString()) || clLocale.toString().equals(swiss_fr_loc.toString()))) {
                            if (quote_letters) {
                                pattern = pattern + dateUtil.getInfmxglPattern(date, 'h', clLocale);
                                continue block35;
                            }
                            pattern = pattern + SQUOTE + dateUtil.getInfmxglPattern(date, 'h', clLocale);
                            quote_letters = true;
                            continue block35;
                        }
                        pattern = pattern + "MMM";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "h";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "h";
                    quote_letters = true;
                    continue block35;
                }
                case 'H': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        if (date instanceof Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + dbDateTimeFormat + "\"", clLocale);
                        }
                        pattern = pattern + "HH";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "H";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "H";
                    quote_letters = true;
                    continue block35;
                }
                case 'i': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') continue block35;
                    if (quote_letters) {
                        pattern = pattern + "i";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "i";
                    quote_letters = true;
                    continue block35;
                }
                case 'I': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        if (date instanceof Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + dbDateTimeFormat + "\"", clLocale);
                        }
                        pattern = pattern + "hh";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "I";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "I";
                    quote_letters = true;
                    continue block35;
                }
                case 'M': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        if (date instanceof Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + dbDateTimeFormat + "\"", clLocale);
                        }
                        pattern = pattern + "mm";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "M";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "M";
                    quote_letters = true;
                    continue block35;
                }
                case 'p': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        if (date instanceof Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + dbDateTimeFormat + "\"", clLocale);
                        }
                        pattern = pattern + "aa";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "p";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "p";
                    quote_letters = true;
                    continue block35;
                }
                case 'r': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        if (date instanceof Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + dbDateTimeFormat + "\"", clLocale);
                        }
                        pattern = pattern + "hh:mm:ss aaaa";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "r";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "r";
                    quote_letters = true;
                    continue block35;
                }
                case 'R': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        if (date instanceof Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + dbDateTimeFormat + "\"", clLocale);
                        }
                        pattern = pattern + "HH:mm";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "R";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "R";
                    quote_letters = true;
                    continue block35;
                }
                case 'S': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        if (date instanceof Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + dbDateTimeFormat + "\"", clLocale);
                        }
                        pattern = pattern + "ss";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "S";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "S";
                    quote_letters = true;
                    continue block35;
                }
                case 'T': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        if (date instanceof Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + dbDateTimeFormat + "\"", clLocale);
                        }
                        pattern = pattern + "HH:mm:ss";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "T";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "T";
                    quote_letters = true;
                    continue block35;
                }
                case 'X': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        if (date instanceof Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + dbDateTimeFormat + "\"", clLocale);
                        }
                        pattern = pattern + "HH:mm:ss";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "X";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "X";
                    quote_letters = true;
                    continue block35;
                }
                case 'y': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%' || i >= 2 && dbDateTimeFormat.charAt(i - 1) == 'i' && dbDateTimeFormat.charAt(i - 2) == '%') {
                        pattern = pattern + "yy";
                        continue block35;
                    }
                    if (i >= 2 && dbDateTimeFormat.charAt(i - 1) == 'E' && dbDateTimeFormat.charAt(i - 2) == '%') {
                        pattern = pattern + "yy" + " GGGGG ";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "y";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "y";
                    quote_letters = true;
                    continue block35;
                }
                case 'Y': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%' || i >= 2 && dbDateTimeFormat.charAt(i - 1) == 'i' && dbDateTimeFormat.charAt(i - 2) == '%') {
                        pattern = pattern + "yyyy";
                        continue block35;
                    }
                    if (i >= 2 && dbDateTimeFormat.charAt(i - 1) == 'E' && dbDateTimeFormat.charAt(i - 2) == '%') {
                        pattern = pattern + "yyyy" + " GGGGG ";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "Y";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "Y";
                    quote_letters = true;
                    continue block35;
                }
                case 'm': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        pattern = pattern + "MM";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "m";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "m";
                    quote_letters = true;
                    continue block35;
                }
                case 'n': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        pattern = pattern + "\f";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "n";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "n";
                    quote_letters = true;
                    continue block35;
                }
                case 't': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        pattern = pattern + "\t";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "t";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "t";
                    quote_letters = true;
                    continue block35;
                }
                case 'w': {
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        pattern = pattern + WDIRTAG + "E";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "w";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "w";
                    quote_letters = true;
                    continue block35;
                }
                case 'x': {
                    dateField = dateUtil.getLocaleDateOrder(clLocale, true);
                    if (i != 0 && dbDateTimeFormat.charAt(i - 1) == '%') {
                        pattern = pattern + dateUtil.getglDateXPattern(dateField);
                        continue block35;
                    }
                    if (i >= 2 && dbDateTimeFormat.charAt(i - 1) == 'E' && dbDateTimeFormat.charAt(i - 2) == '%') {
                        pattern = pattern + dateUtil.getglDateXPattern(dateField) + " GGGGG ";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "x";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "x";
                    quote_letters = true;
                    continue block35;
                }
                case 'g': {
                    if (i >= 2 && dbDateTimeFormat.charAt(i - 1) == 'E' && dbDateTimeFormat.charAt(i - 2) == '%') {
                        pattern = pattern + CDIRTAG + "yyyy" + " G ";
                        continue block35;
                    }
                    if (quote_letters) {
                        pattern = pattern + "g";
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + "g";
                    quote_letters = true;
                    continue block35;
                }
                default: {
                    if (Character.isLetter(dbDateTimeFormat.charAt(i)) && !quote_letters) {
                        pattern = pattern + SQUOTE + dbDateTimeFormat.substring(i, i + 1);
                        quote_letters = true;
                        continue block35;
                    }
                    if (Character.isLetter(dbDateTimeFormat.charAt(i)) && quote_letters || !Character.isLetter(dbDateTimeFormat.charAt(i)) && !quote_letters) {
                        pattern = pattern + dbDateTimeFormat.substring(i, i + 1);
                        continue block35;
                    }
                    pattern = pattern + SQUOTE + dbDateTimeFormat.substring(i, i + 1);
                    quote_letters = false;
                }
            }
        }
        if (quote_letters) {
            pattern = pattern + SQUOTE;
        }
        retStr = dateUtil.formatDate(date, clLocale, pattern);
        return retStr;
    }

    private static String getLocaleDateStr(Date date, String dateLocale) {
        DateFormat formatter = null;
        String dateStr = null;
        int dateStyle = 3;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        formatter = DateFormat.getDateInstance(dateStyle, clLocale);
        dateStr = formatter.format(date);
        return dateStr;
    }

    private static String getLocaleDateTimeStr(Object date, String dateLocale) {
        DateFormat formatter = null;
        String dateStr = null;
        int timeStyle = 2;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        if (date instanceof Timestamp) {
            int dateStyle = 2;
            formatter = DateFormat.getDateTimeInstance(dateStyle, timeStyle, clLocale);
            dateStr = formatter.format((Timestamp)date);
        } else {
            formatter = DateFormat.getTimeInstance(timeStyle, clLocale);
            dateStr = formatter.format((Time)date);
        }
        return dateStr;
    }

    private static String formatDate(Object date, Locale clLocale, String pattern) {
        SimpleDateFormat formatter;
        int index = 0;
        int cindex = 0;
        String dateStr = null;
        if (pattern.indexOf(WDIRTAG) == -1) {
            formatter = clLocale == null || !clLocale.getLanguage().equals("th") ? new SimpleDateFormat(pattern, clLocale) : new SimpleDateFormat(pattern, new Locale("th"));
            dateStr = date instanceof Date ? formatter.format((Date)date) : formatter.format((Timestamp)date);
        } else {
            DateFormatSymbols symbols = null;
            symbols = clLocale == null || !clLocale.getLanguage().equals("th") ? new DateFormatSymbols(clLocale) : new DateFormatSymbols(new Locale("th"));
            String[] defaultDays = symbols.getShortWeekdays();
            formatter = new SimpleDateFormat(pattern, symbols);
            dateStr = date instanceof Date ? formatter.format((Date)date) : formatter.format((Timestamp)date);
            int windex = 0;
            int weekdaynum = 0;
            while (windex < dateStr.length() && (index = dateStr.indexOf(WDIRTAG, windex)) != -1) {
                for (int i = 0; i < defaultDays.length - 1; ++i) {
                    if (dateStr.indexOf(WDIRTAG + defaultDays[i + 1], windex) == -1) continue;
                    weekdaynum = i;
                    break;
                }
                dateStr = dateStr.substring(0, index) + weekdaynum + dateStr.substring(index + WDIRTAG.length() + defaultDays[weekdaynum + 1].length());
                windex = index + 1;
            }
        }
        while (cindex < dateStr.length() && (index = dateStr.indexOf(CDIRTAG, cindex)) != -1) {
            dateStr = dateStr.substring(0, index) + dateStr.substring(index + CDIRTAG.length(), index + CDIRTAG.length() + 2) + dateStr.substring(index + CDIRTAG.length() + 4);
            cindex = index + 2;
        }
        return dateStr;
    }

    private static String convertdbDate(String date, String dateLocale, String dbDateFormat) throws SQLException {
        String localDateStr = null;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        if (!dateUtil.isValidDate(date)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + date + "\"", clLocale);
        }
        StringTokenizer dT = new StringTokenizer(date, HYPHEN);
        int y = stringUtil.stringToInt(dT.nextToken());
        int m = stringUtil.stringToInt(dT.nextToken()) - 1;
        int d = stringUtil.stringToInt(dT.nextToken());
        GregorianCalendar gc = (GregorianCalendar)localCalendar.get();
        gc.set(y, m, d);
        Date dateObj = new Date(gc.getTimeInMillis());
        localDateStr = dateUtil.getdbDateStr(dateObj, dateLocale, dbDateFormat);
        return localDateStr;
    }

    private static String convertdbDateTime(String datetime, IfxConnection conn, String dbDateTimeFormat, boolean isTime) throws SQLException {
        String localDateTimeStr = null;
        int y = 0;
        int m = 0;
        int d = 0;
        int h = 0;
        int min = 0;
        int s = 0;
        int f = -1;
        StringTokenizer dT = null;
        String dateLocale = conn.getclLocale();
        GregorianCalendar gc = null;
        Timestamp datetimeObj = null;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        boolean nativeSQL = true;
        if (!isTime) {
            if (!dateUtil.isValidTimeStamp(datetime)) {
                throw IfxErrMsg.getSQLException(-79712, "\"" + datetime + "\"", clLocale);
            }
            dT = new StringTokenizer(datetime, "-:. ");
            y = stringUtil.stringToInt(dT.nextToken());
            m = stringUtil.stringToInt(dT.nextToken()) - 1;
            d = stringUtil.stringToInt(dT.nextToken());
            h = stringUtil.stringToInt(dT.nextToken());
            min = stringUtil.stringToInt(dT.nextToken());
            s = stringUtil.stringToInt(dT.nextToken());
            if (dT.hasMoreTokens()) {
                String frac = dT.nextToken();
                if (stringUtil.isANum(frac) && frac.length() <= 9) {
                    if (frac.length() < 9) {
                        frac = frac + ZEROS.substring(0, 9 - frac.length());
                    }
                    f = stringUtil.stringToInt(frac);
                } else {
                    throw IfxErrMsg.getSQLException(-79786, datetime, clLocale);
                }
            }
            gc = (GregorianCalendar)localCalendar.get();
            gc.set(y, m, d, h, min, s);
            datetimeObj = new Timestamp(gc.getTimeInMillis());
            datetimeObj.setNanos(0);
            if (f != -1) {
                datetimeObj.setNanos(f);
            }
            localDateTimeStr = dateUtil.getglDateStr(datetimeObj, dateLocale, dbDateTimeFormat, nativeSQL);
        } else {
            if (!dateUtil.isValidTime(datetime)) {
                throw IfxErrMsg.getSQLException(-79711, "\"" + datetime + "\"", clLocale);
            }
            dT = new StringTokenizer(datetime, COLON);
            h = stringUtil.stringToInt(dT.nextToken());
            min = stringUtil.stringToInt(dT.nextToken());
            s = stringUtil.stringToInt(dT.nextToken());
            GregorianCalendar gcToday = null;
            gcToday = dateUtil.getCurrentDateGC(conn);
            y = gcToday.get(1);
            m = gcToday.get(2);
            d = gcToday.get(5);
            gc = (GregorianCalendar)localCalendar.get();
            gc.set(y, m, d, h, min, s);
            datetimeObj = new Timestamp(gc.getTimeInMillis());
            datetimeObj.setNanos(0);
            localDateTimeStr = dateUtil.getglDateStr(datetimeObj, dateLocale, dbDateTimeFormat, nativeSQL);
        }
        return localDateTimeStr;
    }

    private static String convertglDate(String date, String dateLocale, String glDateFormat) throws SQLException {
        String localDateStr = null;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        if (!dateUtil.isValidDate(date)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + date + "\"", clLocale);
        }
        StringTokenizer dT = new StringTokenizer(date, HYPHEN);
        int y = stringUtil.stringToInt(dT.nextToken());
        int m = stringUtil.stringToInt(dT.nextToken()) - 1;
        int d = stringUtil.stringToInt(dT.nextToken());
        GregorianCalendar gc = (GregorianCalendar)localCalendar.get();
        gc.set(y, m, d);
        Date dateObj = new Date(gc.getTimeInMillis());
        boolean nativeSQL = true;
        localDateStr = dateUtil.getglDateStr(dateObj, dateLocale, glDateFormat, nativeSQL);
        return localDateStr;
    }

    private static String convertcllDate(String date, String dateLocale) throws SQLException {
        String localDateStr = null;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        if (!dateUtil.isValidDate(date)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + date + "\"", clLocale);
        }
        StringTokenizer dT = new StringTokenizer(date, HYPHEN);
        int y = stringUtil.stringToInt(dT.nextToken());
        int m = stringUtil.stringToInt(dT.nextToken()) - 1;
        int d = stringUtil.stringToInt(dT.nextToken());
        GregorianCalendar gc = (GregorianCalendar)localCalendar.get();
        gc.set(y, m, d);
        Date dateObj = new Date(gc.getTimeInMillis());
        localDateStr = dateUtil.getLocaleDateStr(dateObj, dateLocale);
        return localDateStr;
    }

    private static String convertcllDateTime(String datetime, String dateLocale, boolean isTime) throws SQLException {
        String localDateTimeStr = null;
        int y = 0;
        int m = 0;
        int d = 0;
        int h = 0;
        int min = 0;
        int s = 0;
        int f = -1;
        StringTokenizer dT = null;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        if (!isTime) {
            if (!dateUtil.isValidTimeStamp(datetime)) {
                throw IfxErrMsg.getSQLException(-79712, "\"" + datetime + "\"", clLocale);
            }
            dT = new StringTokenizer(datetime, "-:. ");
            y = stringUtil.stringToInt(dT.nextToken());
            m = stringUtil.stringToInt(dT.nextToken()) - 1;
            d = stringUtil.stringToInt(dT.nextToken());
            h = stringUtil.stringToInt(dT.nextToken());
            min = stringUtil.stringToInt(dT.nextToken());
            s = stringUtil.stringToInt(dT.nextToken());
            if (dT.hasMoreTokens()) {
                String frac = dT.nextToken();
                if (stringUtil.isANum(frac) && frac.length() <= 9) {
                    if (frac.length() < 9) {
                        frac = frac + ZEROS.substring(0, 9 - frac.length());
                    }
                    f = stringUtil.stringToInt(frac);
                } else {
                    throw IfxErrMsg.getSQLException(-79786, datetime, clLocale);
                }
            }
            GregorianCalendar gc = (GregorianCalendar)localCalendar.get();
            gc.set(y, m, d, h, min, s);
            Timestamp datetimeObj = new Timestamp(gc.getTimeInMillis());
            datetimeObj.setNanos(0);
            if (f != -1) {
                datetimeObj.setNanos(f);
            }
            localDateTimeStr = dateUtil.getLocaleDateTimeStr(datetimeObj, dateLocale);
        } else {
            if (!dateUtil.isValidTime(datetime)) {
                throw IfxErrMsg.getSQLException(-79711, "\"" + datetime + "\"", clLocale);
            }
            dT = new StringTokenizer(datetime, COLON);
            h = stringUtil.stringToInt(dT.nextToken());
            min = stringUtil.stringToInt(dT.nextToken());
            s = stringUtil.stringToInt(dT.nextToken());
            Time timeObj = new Time(h, min, s);
            localDateTimeStr = dateUtil.getLocaleDateTimeStr(timeObj, dateLocale);
        }
        return localDateTimeStr;
    }

    private static Date getdbDateObj(String dateStr, IfxConnection conn) throws SQLException {
        String dbDateFormat = conn.getdbDate();
        String dbDatetok = null;
        String datepart = null;
        boolean sepfound = false;
        int dateidx = 0;
        int datefmtlen = 0;
        int tmpidx = 0;
        GregorianCalendar gcToday = null;
        gcToday = dateUtil.getCurrentDateGC(conn);
        int currentCentury = gcToday.get(1) / 100;
        int y = currentCentury * 100;
        int m = 0;
        int d = 1;
        StringTokenizer dT = null;
        Date dateObj = null;
        boolean needCentury = false;
        if (dbDateFormat.length() < 4 || dbDateFormat.length() > 6) {
            throw IfxErrMsg.getSQLException(-79797, "\"" + dbDateFormat + "\"", conn);
        }
        String temptok = dbDateFormat.substring(dbDateFormat.length() - 1);
        if (temptok.equals(SLASH) || temptok.equals(HYPHEN) || temptok.equals(PERIOD)) {
            dbDatetok = temptok;
            sepfound = true;
        } else if (temptok.equals(NOSEP)) {
            dbDatetok = "";
            sepfound = true;
        } else {
            if (!(temptok.equals("E") || temptok.equals("2") || temptok.equals("4") || temptok.equals("M") || temptok.equals("D"))) {
                sepfound = true;
            }
            dbDatetok = SLASH;
        }
        datefmtlen = sepfound ? dbDateFormat.length() - 1 : dbDateFormat.length();
        if (!dbDatetok.equals("") && (dT = new StringTokenizer(dateStr, dbDatetok + " ")).countTokens() < 3) {
            throw IfxErrMsg.getSQLException(-79802, "\"" + dateStr + "\"", conn);
        }
        block10: for (int i = 0; i < datefmtlen; ++i) {
            if (dbDatetok.equals("") && dateidx >= dateStr.length()) {
                throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
            }
            if (!dbDatetok.equals("") && !dT.hasMoreTokens()) {
                throw IfxErrMsg.getSQLException(-79804, "\"" + dateStr + "\"", conn);
            }
            if (!dbDatetok.equals("") && dbDateFormat.charAt(i) != 'Y') {
                datepart = dT.nextToken();
            }
            switch (dbDateFormat.charAt(i)) {
                case 'E': {
                    if (!dbDatetok.equals("")) continue block10;
                    if (dateidx <= dateStr.length()) {
                        tmpidx = dateStr.indexOf(32, dateidx);
                        if (tmpidx != -1) {
                            dateidx = tmpidx + 1;
                            continue block10;
                        }
                        throw IfxErrMsg.getSQLException(-79805, "\"" + dateStr + "\"", conn);
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                }
                case 'D': {
                    if (!dbDatetok.equals("")) {
                        d = stringUtil.stringToInt(datepart);
                        if (d != 0) continue block10;
                        throw IfxErrMsg.getSQLException(-79806, "\"" + dateStr + "\"", conn);
                    }
                    if (dateidx + 2 <= dateStr.length()) {
                        d = stringUtil.stringToInt(dateStr.substring(dateidx, dateidx + 2));
                        if (d == 0) {
                            throw IfxErrMsg.getSQLException(-79806, "\"" + dateStr + "\"", conn);
                        }
                        dateidx += 2;
                        continue block10;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                }
                case 'M': {
                    if (!dbDatetok.equals("")) {
                        m = stringUtil.stringToInt(datepart) - 1;
                        if (m != -1) continue block10;
                        throw IfxErrMsg.getSQLException(-79807, "\"" + dateStr + "\"", conn);
                    }
                    if (dateidx + 2 <= dateStr.length()) {
                        m = stringUtil.stringToInt(dateStr.substring(dateidx, dateidx + 2)) - 1;
                        if (m == -1) {
                            throw IfxErrMsg.getSQLException(-79807, "\"" + dateStr + "\"", conn);
                        }
                        dateidx += 2;
                        continue block10;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                }
                case 'Y': {
                    if (i + 1 == datefmtlen) {
                        throw IfxErrMsg.getSQLException(-79798, "\"" + dbDateFormat + "\"", conn);
                    }
                    if (dbDateFormat.charAt(i + 1) == '2' || dbDateFormat.charAt(i + 1) == '4') continue block10;
                    throw IfxErrMsg.getSQLException(-79799, "\"" + dbDateFormat + "\"", conn);
                }
                case '2': {
                    if (i == 0 || dbDateFormat.charAt(i - 1) != 'Y') {
                        throw IfxErrMsg.getSQLException(-79800, "\"" + dbDateFormat + "\"", conn);
                    }
                    if (!dbDatetok.equals("")) {
                        y = stringUtil.stringToInt(datepart);
                        if (datepart.length() >= 3) continue block10;
                        needCentury = true;
                        continue block10;
                    }
                    if (dateidx + 2 <= dateStr.length()) {
                        y = stringUtil.stringToInt(dateStr.substring(dateidx, dateidx + 2));
                        needCentury = true;
                        dateidx += 2;
                        continue block10;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + dbDateFormat + "\"", conn);
                }
                case '4': {
                    if (i == 0 || dbDateFormat.charAt(i - 1) != 'Y') {
                        throw IfxErrMsg.getSQLException(-79800, "\"" + dbDateFormat + "\"", conn);
                    }
                    if (!dbDatetok.equals("")) {
                        y = stringUtil.stringToInt(datepart);
                        if (datepart.length() >= 3) continue block10;
                        needCentury = true;
                        continue block10;
                    }
                    if (dateidx + 4 <= dateStr.length()) {
                        y = stringUtil.stringToInt(dateStr.substring(dateidx, dateidx + 4));
                        dateidx += 4;
                        continue block10;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                }
                default: {
                    throw IfxErrMsg.getSQLException(-79801, "\"" + dbDateFormat + "\"", conn);
                }
            }
        }
        if (!dateUtil.isValidDate(y, m + 1, d)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + dateStr + "\"", conn);
        }
        try {
            if (needCentury) {
                y += dateUtil.getCentury(conn, y, m + 1, d);
            }
            GregorianCalendar gc = (GregorianCalendar)localCalendar.get();
            gc.set(y, m, d);
            dateObj = new Date(gc.getTimeInMillis());
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79786, e.toString(), conn);
        }
        return dateObj;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object getglDateObj(String datetimeStr, IfxConnection conn, boolean isDate, boolean isTime) throws SQLException {
        String glDateFormat = null;
        glDateFormat = isDate ? (conn.getdbDate() != null ? conn.getdbDate() : conn.getglDate()) : (conn.getdbTime() != null ? conn.getdbTime() : conn.getglDateTime());
        String glLocale = conn.getclLocale();
        int dateidx = 0;
        int tmpidx = 0;
        int y = 0;
        int m = 0;
        int d = 0;
        int h = -1;
        int min = -1;
        int s = -1;
        int f = -1;
        int currentCentury = 0;
        GregorianCalendar gcToday = null;
        gcToday = dateUtil.getCurrentDateGC(conn);
        if (isDate) {
            currentCentury = gcToday.get(1) / 100;
            y = currentCentury * 100;
            m = 0;
            d = 1;
        } else if (!isTime) {
            y = -1;
            m = -1;
            d = -1;
        } else {
            y = gcToday.get(1);
            m = gcToday.get(2);
            d = gcToday.get(5);
        }
        String yearpart = null;
        String monthpart = null;
        String daypart = null;
        String fracpart = null;
        String secpart = null;
        String minpart = null;
        String hourpart = null;
        DateFormatSymbols symbols = null;
        String[] defaultDays = new String[8];
        String[] defaultMonths = new String[13];
        String[] modifiedMonths = new String[13];
        Object var28_28 = null;
        String[] dateField = new String[3];
        String datepart = null;
        int datepartlen = 0;
        StringTokenizer xdirT = null;
        StringTokenizer DdirT = null;
        String tmpdateStr = null;
        String tmpdefDays = null;
        String tmpdefMnths = null;
        boolean needCentury = false;
        String ampm = null;
        Locale clLocale = dateUtil.getLocaleValue(glLocale);
        symbols = new DateFormatSymbols(clLocale);
        block32: for (int i = 0; i < glDateFormat.length(); ++i) {
            if (dateidx >= datetimeStr.length()) {
                throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
            }
            switch (glDateFormat.charAt(i)) {
                case '%': {
                    if (i == 0 || glDateFormat.charAt(i - 1) != '%') continue block32;
                    ++dateidx;
                    continue block32;
                }
                case 'a': {
                    Locale swiss_fr_loc;
                    int j;
                    int defDaylen;
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        defaultDays = symbols.getShortWeekdays();
                        defDaylen = 0;
                        for (j = 0; j < defaultDays.length - 1; ++j) {
                            tmpdefDays = defaultDays[j + 1].toLowerCase(clLocale);
                            defDaylen = defaultDays[j + 1].length();
                            if (dateidx + defDaylen <= datetimeStr.length()) {
                                Locale turkey_loc = new Locale("tr", "TR", "");
                                tmpdateStr = datetimeStr.substring(dateidx, dateidx + defDaylen).toLowerCase(clLocale);
                                if (tmpdateStr.indexOf(tmpdefDays) != -1) {
                                    swiss_fr_loc = new Locale("fr", "CH", "");
                                    if (clLocale.toString().equals(swiss_fr_loc.toString())) {
                                        dateidx += 3;
                                        continue block32;
                                    }
                                    dateidx += defDaylen;
                                    continue block32;
                                }
                                if (!clLocale.toString().equals(Locale.CANADA_FRENCH.toString()) && !clLocale.toString().equals(turkey_loc.toString()) || tmpdateStr.indexOf(tmpdefDays.substring(0, 3)) == -1) continue;
                                dateidx += 3;
                                continue block32;
                            }
                            if (dateidx + 3 > datetimeStr.length()) continue;
                            tmpdateStr = datetimeStr.substring(dateidx, dateidx + 3).toLowerCase(clLocale);
                            if (defDaylen < 3 || !tmpdateStr.equals(tmpdefDays.substring(0, 3))) continue;
                            dateidx += 3;
                            continue block32;
                        }
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'A': {
                    int j;
                    int defDaylen;
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        defaultDays = symbols.getWeekdays();
                        defDaylen = 0;
                        for (j = 0; j < defaultDays.length - 1; ++j) {
                            defDaylen = defaultDays[j + 1].length();
                            if (dateidx + defDaylen > datetimeStr.length() || (tmpdateStr = datetimeStr.substring(dateidx, dateidx + defDaylen).toLowerCase(clLocale)).indexOf(tmpdefDays = defaultDays[j + 1].toLowerCase(clLocale)) == -1) continue;
                            dateidx += defDaylen;
                            continue block32;
                        }
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'b': 
                case 'h': {
                    int defMthlen;
                    boolean month_found;
                    Locale swiss_fr_loc;
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        month_found = false;
                        defMthlen = 0;
                        defaultMonths = symbols.getShortMonths();
                        for (int j = 0; j < defaultMonths.length - 1; ++j) {
                            tmpdefMnths = defaultMonths[j].toLowerCase(clLocale);
                            defMthlen = defaultMonths[j].length();
                            if (dateidx + defMthlen <= datetimeStr.length()) {
                                swiss_fr_loc = new Locale("fr", "CH", "");
                                tmpdateStr = datetimeStr.substring(dateidx, dateidx + defMthlen).toLowerCase(clLocale);
                                if (tmpdateStr.indexOf(tmpdefMnths) != -1) {
                                    m = j;
                                    month_found = true;
                                    dateidx += defMthlen;
                                    break;
                                }
                                if (!clLocale.toString().equals(Locale.CANADA_FRENCH.toString()) && !clLocale.toString().equals(swiss_fr_loc.toString()) || tmpdateStr.indexOf(tmpdefMnths.substring(0, 3)) == -1 && (!tmpdefMnths.equals("juin") || !tmpdateStr.substring(0, 3).equals("jun")) && (!tmpdefMnths.equals("juil.") || !tmpdateStr.substring(0, 3).equals("jul"))) continue;
                                m = j;
                                month_found = true;
                                dateidx += 3;
                                break;
                            }
                            if (dateidx + 3 > datetimeStr.length()) continue;
                            swiss_fr_loc = new Locale("fr", "CH", "");
                            tmpdateStr = datetimeStr.substring(dateidx, dateidx + 3).toLowerCase(clLocale);
                            if (defMthlen >= 3 && tmpdateStr.equals(tmpdefMnths.substring(0, 3))) {
                                m = j;
                                month_found = true;
                                dateidx += 3;
                                break;
                            }
                            if (!clLocale.toString().equals(Locale.CANADA_FRENCH.toString()) && !clLocale.toString().equals(swiss_fr_loc.toString()) || (!tmpdefMnths.equals("juin") || !tmpdateStr.equals("jun")) && (!tmpdefMnths.equals("juil.") || !tmpdateStr.equals("jul"))) continue;
                            m = j;
                            month_found = true;
                            dateidx += 3;
                            break;
                        }
                        if (month_found) continue block32;
                        String[] defMonths = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", ""};
                        symbols.setShortMonths(defMonths);
                        modifiedMonths = symbols.getShortMonths();
                        for (int j = 0; j < modifiedMonths.length - 1; ++j) {
                            defMthlen = modifiedMonths[j].length();
                            if (dateidx + defMthlen > datetimeStr.length() || (tmpdateStr = datetimeStr.substring(dateidx, dateidx + defMthlen).toLowerCase(clLocale)).indexOf(modifiedMonths[j]) == -1) continue;
                            m = j;
                            dateidx += defMthlen;
                            continue block32;
                        }
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'c': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (isDate) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + glDateFormat + "\"", clLocale);
                        }
                        if (dateidx + 19 <= datetimeStr.length()) {
                            tmpidx = dateidx + 19;
                        } else if (dateidx + 18 <= datetimeStr.length()) {
                            tmpidx = dateidx + 18;
                        } else if (dateidx + 17 <= datetimeStr.length()) {
                            tmpidx = dateidx + 17;
                        } else if (dateidx + 16 <= datetimeStr.length()) {
                            tmpidx = dateidx + 16;
                        } else if (dateidx + 15 <= datetimeStr.length()) {
                            tmpidx = dateidx + 15;
                        } else if (dateidx + 14 <= datetimeStr.length()) {
                            tmpidx = dateidx + 14;
                        } else if (dateidx + 13 <= datetimeStr.length()) {
                            tmpidx = dateidx + 13;
                        } else {
                            if (dateidx + 12 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                            tmpidx = dateidx + 12;
                        }
                        DdirT = new StringTokenizer(datetimeStr.substring(dateidx, tmpidx), NONALPHANUMTOKS);
                        if (DdirT.countTokens() < 6) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + datetimeStr + "\"", conn);
                        }
                        datepartlen = 0;
                        datepart = DdirT.nextToken();
                        y = stringUtil.stringToInt(datepart);
                        if (datepart.length() < 3) {
                            needCentury = true;
                        }
                        datepartlen += datepart.length();
                        datepart = DdirT.nextToken();
                        m = stringUtil.stringToInt(datepart) - 1;
                        datepartlen += datepart.length();
                        datepart = DdirT.nextToken();
                        d = stringUtil.stringToInt(datepart);
                        datepartlen += datepart.length();
                        hourpart = DdirT.nextToken();
                        h = stringUtil.stringToInt(hourpart);
                        datepartlen += hourpart.length();
                        minpart = DdirT.nextToken();
                        min = stringUtil.stringToInt(minpart);
                        datepartlen += minpart.length();
                        secpart = DdirT.nextToken();
                        s = stringUtil.stringToInt(secpart);
                        dateidx = dateidx + (datepartlen += secpart.length()) + 5;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'F': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (isDate) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + glDateFormat + "\"", clLocale);
                        }
                        if (i + 1 > glDateFormat.length() || Character.isDigit(glDateFormat.charAt(i + 1))) continue block32;
                        if (dateidx + 3 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        if (!datetimeStr.substring(dateidx, dateidx + 1).equals(PERIOD)) {
                            throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        }
                        if (++dateidx + 2 <= datetimeStr.length()) {
                            tmpidx = dateidx + 2;
                        } else {
                            if (dateidx + 1 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                            tmpidx = dateidx + 1;
                        }
                        DdirT = new StringTokenizer(datetimeStr.substring(dateidx, tmpidx), NONALPHANUMTOKS);
                        if (DdirT.countTokens() < 1) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + datetimeStr + "\"", conn);
                        }
                        fracpart = DdirT.nextToken();
                        int fraclen = fracpart.length();
                        if (!stringUtil.isANum(fracpart) || fraclen > 2) {
                            throw IfxErrMsg.getSQLException(-79786, datetimeStr, conn);
                        }
                        fracpart = fracpart + ZEROS.substring(0, 9 - fraclen);
                        f = stringUtil.stringToInt(fracpart);
                        dateidx += fraclen;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': {
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'F' && glDateFormat.charAt(i - 2) == '%') {
                        int prec = Character.getNumericValue(glDateFormat.charAt(i));
                        if (dateidx + prec > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        if (!datetimeStr.substring(dateidx, dateidx + 1).equals(PERIOD)) {
                            throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        }
                        ++dateidx;
                        boolean spaceok = false;
                        for (int pt = prec; pt >= 1; --pt) {
                            if (dateidx + pt > datetimeStr.length()) continue;
                            tmpidx = dateidx + pt;
                            spaceok = true;
                            break;
                        }
                        if (!spaceok) {
                            throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        }
                        DdirT = new StringTokenizer(datetimeStr.substring(dateidx, tmpidx), NONALPHANUMTOKS);
                        if (DdirT.countTokens() < 1) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + datetimeStr + "\"", conn);
                        }
                        fracpart = DdirT.nextToken();
                        int fraclen = fracpart.length();
                        if (!stringUtil.isANum(fracpart) || fraclen > prec) {
                            throw IfxErrMsg.getSQLException(-79786, datetimeStr, conn);
                        }
                        fracpart = fracpart + ZEROS.substring(0, 9 - fraclen);
                        f = stringUtil.stringToInt(fracpart);
                        dateidx += fraclen;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case '0': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'F' && glDateFormat.charAt(i - 2) == '%') {
                        throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'H': 
                case 'I': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (isDate) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + glDateFormat + "\"", clLocale);
                        }
                        if (dateidx + 2 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        hourpart = datetimeStr.substring(dateidx, dateidx + 2);
                        h = stringUtil.stringToInt(hourpart);
                        dateidx += 2;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'B': {
                    int defMthlen;
                    boolean month_found;
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        month_found = false;
                        defMthlen = 0;
                        defaultMonths = symbols.getMonths();
                        for (int j = 0; j < defaultMonths.length - 1; ++j) {
                            defMthlen = defaultMonths[j].length();
                            if (dateidx + defMthlen > datetimeStr.length() || (tmpdateStr = datetimeStr.substring(dateidx, dateidx + defMthlen).toLowerCase(clLocale)).indexOf(tmpdefMnths = defaultMonths[j].toLowerCase(clLocale)) == -1) continue;
                            m = j;
                            month_found = true;
                            dateidx += defMthlen;
                            break;
                        }
                        if (month_found) continue block32;
                        String[] defMonths = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", ""};
                        symbols.setMonths(defMonths);
                        modifiedMonths = symbols.getMonths();
                        for (int j = 0; j < modifiedMonths.length - 1; ++j) {
                            defMthlen = modifiedMonths[j].length();
                            if (dateidx + defMthlen > datetimeStr.length() || (tmpdateStr = datetimeStr.substring(dateidx, dateidx + defMthlen).toLowerCase(clLocale)).indexOf(modifiedMonths[j]) == -1) continue;
                            m = j;
                            dateidx += defMthlen;
                            continue block32;
                        }
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'C': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        dateidx += 2;
                        continue block32;
                    }
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        if (dateidx + 3 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        tmpidx = datetimeStr.indexOf(32, dateidx + 3);
                        if (tmpidx == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + datetimeStr + "\"", conn);
                        dateidx = tmpidx + 1;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'd': {
                    int incrDateidx;
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (dateidx + 2 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        incrDateidx = Character.isDigit(datetimeStr.charAt(dateidx + 1)) ? 2 : 1;
                        daypart = datetimeStr.substring(dateidx, dateidx + incrDateidx);
                        d = stringUtil.stringToInt(daypart);
                        dateidx += incrDateidx;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'D': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (dateidx + 8 <= datetimeStr.length()) {
                            tmpidx = dateidx + 8;
                        } else if (dateidx + 7 <= datetimeStr.length()) {
                            tmpidx = dateidx + 7;
                        } else {
                            if (dateidx + 6 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                            tmpidx = dateidx + 6;
                        }
                        DdirT = new StringTokenizer(datetimeStr.substring(dateidx, tmpidx), NONALPHANUMTOKS);
                        if (DdirT.countTokens() < 3) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + datetimeStr + "\"", conn);
                        }
                        datepartlen = 0;
                        datepart = DdirT.nextToken();
                        m = stringUtil.stringToInt(datepart) - 1;
                        datepartlen += datepart.length();
                        datepart = DdirT.nextToken();
                        d = stringUtil.stringToInt(datepart);
                        datepartlen += datepart.length();
                        datepart = DdirT.nextToken();
                        y = stringUtil.stringToInt(datepart);
                        if (datepart.length() < 3) {
                            needCentury = true;
                        }
                        dateidx = dateidx + (datepartlen += datepart.length()) + 2;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'e': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (dateidx != 0 && datetimeStr.charAt(dateidx - 1) == ' ') {
                            if (dateidx + 1 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                            daypart = datetimeStr.substring(dateidx, dateidx + 1);
                            ++dateidx;
                        } else {
                            if (dateidx + 2 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                            daypart = datetimeStr.substring(dateidx, dateidx + 2);
                            dateidx += 2;
                        }
                        d = stringUtil.stringToInt(daypart);
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'i': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') continue block32;
                    ++dateidx;
                    continue block32;
                }
                case 'E': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') continue block32;
                    ++dateidx;
                    continue block32;
                }
                case 'y': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%' || i >= 2 && glDateFormat.charAt(i - 1) == 'i' && glDateFormat.charAt(i - 2) == '%') {
                        if (dateidx + 2 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        yearpart = datetimeStr.substring(dateidx, dateidx + 2);
                        y = stringUtil.stringToInt(yearpart);
                        needCentury = true;
                        dateidx += 2;
                        continue block32;
                    }
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        if (dateidx + 3 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        yearpart = datetimeStr.substring(dateidx, dateidx + 2);
                        y = stringUtil.stringToInt(yearpart);
                        needCentury = true;
                        tmpidx = datetimeStr.indexOf(32, dateidx + 3);
                        if (tmpidx == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + datetimeStr + "\"", conn);
                        dateidx = tmpidx + 1;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'Y': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%' || i >= 2 && glDateFormat.charAt(i - 1) == 'i' && glDateFormat.charAt(i - 2) == '%') {
                        if (dateidx + 4 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        yearpart = datetimeStr.substring(dateidx, dateidx + 4);
                        y = stringUtil.stringToInt(yearpart);
                        dateidx += 4;
                        continue block32;
                    }
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        if (dateidx + 5 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        yearpart = datetimeStr.substring(dateidx, dateidx + 4);
                        y = stringUtil.stringToInt(yearpart);
                        tmpidx = datetimeStr.indexOf(32, dateidx + 5);
                        if (tmpidx == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + datetimeStr + "\"", conn);
                        dateidx = tmpidx + 1;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'm': {
                    int incrDateidx;
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (dateidx + 2 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        incrDateidx = Character.isDigit(datetimeStr.charAt(dateidx + 1)) ? 2 : 1;
                        monthpart = datetimeStr.substring(dateidx, dateidx + incrDateidx);
                        m = stringUtil.stringToInt(monthpart) - 1;
                        dateidx += incrDateidx;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'M': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (isDate) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + glDateFormat + "\"", clLocale);
                        }
                        if (dateidx + 2 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        minpart = datetimeStr.substring(dateidx, dateidx + 2);
                        min = stringUtil.stringToInt(minpart);
                        dateidx += 2;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'p': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (isDate) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + glDateFormat + "\"", clLocale);
                        }
                        if (dateidx + 2 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        ampm = datetimeStr.substring(dateidx, dateidx + 2);
                        dateidx += 2;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'r': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (isDate) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + glDateFormat + "\"", clLocale);
                        }
                        if (dateidx + 11 <= datetimeStr.length()) {
                            tmpidx = dateidx + 11;
                        } else if (dateidx + 10 <= datetimeStr.length()) {
                            tmpidx = dateidx + 10;
                        } else if (dateidx + 9 <= datetimeStr.length()) {
                            tmpidx = dateidx + 9;
                        } else {
                            if (dateidx + 8 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                            tmpidx = dateidx + 8;
                        }
                        DdirT = new StringTokenizer(datetimeStr.substring(dateidx, tmpidx), NONALPHANUMTOKS);
                        if (DdirT.countTokens() < 4) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + datetimeStr + "\"", conn);
                        }
                        datepartlen = 0;
                        hourpart = DdirT.nextToken();
                        h = stringUtil.stringToInt(hourpart);
                        datepartlen += hourpart.length();
                        minpart = DdirT.nextToken();
                        min = stringUtil.stringToInt(minpart);
                        datepartlen += minpart.length();
                        secpart = DdirT.nextToken();
                        s = stringUtil.stringToInt(secpart);
                        datepartlen += secpart.length();
                        ampm = DdirT.nextToken();
                        dateidx = dateidx + (datepartlen += ampm.length()) + 3;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'R': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (isDate) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + glDateFormat + "\"", clLocale);
                        }
                        if (dateidx + 5 <= datetimeStr.length()) {
                            tmpidx = dateidx + 5;
                        } else if (dateidx + 4 <= datetimeStr.length()) {
                            tmpidx = dateidx + 4;
                        } else {
                            if (dateidx + 3 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                            tmpidx = dateidx + 3;
                        }
                        DdirT = new StringTokenizer(datetimeStr.substring(dateidx, tmpidx), NONALPHANUMTOKS);
                        if (DdirT.countTokens() < 2) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + datetimeStr + "\"", conn);
                        }
                        datepartlen = 0;
                        hourpart = DdirT.nextToken();
                        h = stringUtil.stringToInt(hourpart);
                        datepartlen += hourpart.length();
                        minpart = DdirT.nextToken();
                        min = stringUtil.stringToInt(minpart);
                        dateidx = dateidx + (datepartlen += minpart.length()) + 1;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'S': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (isDate) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + glDateFormat + "\"", clLocale);
                        }
                        if (dateidx + 2 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        secpart = datetimeStr.substring(dateidx, dateidx + 2);
                        s = stringUtil.stringToInt(secpart);
                        dateidx += 2;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'T': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (isDate) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + glDateFormat + "\"", clLocale);
                        }
                        if (dateidx + 8 <= datetimeStr.length()) {
                            tmpidx = dateidx + 8;
                        } else if (dateidx + 7 <= datetimeStr.length()) {
                            tmpidx = dateidx + 7;
                        } else if (dateidx + 6 <= datetimeStr.length()) {
                            tmpidx = dateidx + 6;
                        } else {
                            if (dateidx + 5 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                            tmpidx = dateidx + 5;
                        }
                        DdirT = new StringTokenizer(datetimeStr.substring(dateidx, tmpidx), NONALPHANUMTOKS);
                        if (DdirT.countTokens() < 3) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + datetimeStr + "\"", conn);
                        }
                        datepartlen = 0;
                        hourpart = DdirT.nextToken();
                        h = stringUtil.stringToInt(hourpart);
                        datepartlen += hourpart.length();
                        minpart = DdirT.nextToken();
                        min = stringUtil.stringToInt(minpart);
                        datepartlen += minpart.length();
                        secpart = DdirT.nextToken();
                        s = stringUtil.stringToInt(secpart);
                        dateidx = dateidx + (datepartlen += secpart.length()) + 2;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'x': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%' || i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        dateField = dateUtil.getLocaleDateOrder(clLocale, false);
                        if (dateidx + 10 <= datetimeStr.length()) {
                            tmpidx = dateidx + 10;
                        } else if (dateidx + 9 <= datetimeStr.length()) {
                            tmpidx = dateidx + 9;
                        } else if (dateidx + 8 <= datetimeStr.length()) {
                            tmpidx = dateidx + 8;
                        } else if (dateidx + 7 <= datetimeStr.length()) {
                            tmpidx = dateidx + 7;
                        } else {
                            if (dateidx + 6 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                            tmpidx = dateidx + 6;
                        }
                        xdirT = new StringTokenizer(datetimeStr.substring(dateidx, tmpidx), NONALPHANUMTOKS);
                        if (xdirT.countTokens() < 3) {
                            throw IfxErrMsg.getSQLException(-79809, "\"" + datetimeStr + "\"", conn);
                        }
                        datepartlen = 0;
                        for (int z = 0; z < dateField.length; ++z) {
                            datepart = xdirT.nextToken();
                            datepartlen += datepart.length();
                            if (dateField[z].indexOf("YEAR") != -1) {
                                y = stringUtil.stringToInt(datepart);
                                if (datepart.length() >= 3) continue;
                                needCentury = true;
                                continue;
                            }
                            if (dateField[z].indexOf("MONTH") != -1) {
                                m = stringUtil.stringToInt(datepart) - 1;
                                continue;
                            }
                            d = stringUtil.stringToInt(datepart);
                        }
                        datepartlen += 2;
                        if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                            if (dateidx + datepartlen + 1 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                            tmpidx = datetimeStr.indexOf(32, dateidx + datepartlen + 1);
                            if (tmpidx == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + datetimeStr + "\"", conn);
                            dateidx = tmpidx + 1;
                            continue block32;
                        }
                        dateidx += datepartlen;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'X': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (isDate) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + glDateFormat + "\"", clLocale);
                        }
                        if (dateidx + 8 <= datetimeStr.length()) {
                            tmpidx = dateidx + 8;
                        } else if (dateidx + 7 <= datetimeStr.length()) {
                            tmpidx = dateidx + 7;
                        } else if (dateidx + 6 <= datetimeStr.length()) {
                            tmpidx = dateidx + 6;
                        } else {
                            if (dateidx + 5 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                            tmpidx = dateidx + 5;
                        }
                        DdirT = new StringTokenizer(datetimeStr.substring(dateidx, tmpidx), NONALPHANUMTOKS);
                        if (DdirT.countTokens() < 3) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + datetimeStr + "\"", conn);
                        }
                        datepartlen = 0;
                        hourpart = DdirT.nextToken();
                        h = stringUtil.stringToInt(hourpart);
                        datepartlen += hourpart.length();
                        minpart = DdirT.nextToken();
                        min = stringUtil.stringToInt(minpart);
                        datepartlen += minpart.length();
                        secpart = DdirT.nextToken();
                        s = stringUtil.stringToInt(secpart);
                        dateidx = dateidx + (datepartlen += secpart.length()) + 2;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                case 'g': {
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        if (dateidx + 3 > datetimeStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + datetimeStr + "\"", conn);
                        tmpidx = datetimeStr.indexOf(32, dateidx + 3);
                        if (tmpidx == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + datetimeStr + "\"", conn);
                        dateidx = tmpidx + 1;
                        continue block32;
                    }
                    ++dateidx;
                    continue block32;
                }
                default: {
                    ++dateidx;
                }
            }
        }
        if (dateidx < datetimeStr.length()) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + datetimeStr + "\"", conn);
        }
        if (!dateUtil.isValidDate(y, m + 1, d)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + datetimeStr + "\"", conn);
        }
        try {
            void var28_31;
            if (!(isDate || isTime || y != -1 && m != -1 && d != -1 && h != -1 && min != -1 && s != -1)) {
                throw IfxErrMsg.getSQLException(-79830, "\"" + datetimeStr + "\"", conn);
            }
            if (!isDate && isTime && (h == -1 || min == -1 || s == -1)) {
                throw IfxErrMsg.getSQLException(-79830, "\"" + datetimeStr + "\"", conn);
            }
            if (needCentury) {
                y += dateUtil.getCentury(conn, y, m + 1, d);
            }
            if (isDate) {
                Date dObj;
                GregorianCalendar gc = (GregorianCalendar)localCalendar.get();
                gc.set(y, m, d);
                Date date = dObj = new Date(gc.getTimeInMillis());
                return var28_31;
            } else {
                if (ampm != null) {
                    if (ampm.toUpperCase().equals(AM)) {
                        if (h > 11) {
                            h -= 12;
                        }
                    } else if (ampm.toUpperCase().equals(PM) && h > 0 && h < 12) {
                        h += 12;
                    }
                }
                GregorianCalendar gc = (GregorianCalendar)localCalendar.get();
                gc.set(y, m, d, h, min, s);
                Timestamp dtObj = new Timestamp(gc.getTimeInMillis());
                dtObj.setNanos(0);
                if (f != -1) {
                    dtObj.setNanos(f);
                }
                Timestamp timestamp = dtObj;
            }
            return var28_31;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79786, e.toString(), conn);
        }
    }

    private static Date getLocaleDateObj(String dateStr, IfxConnection conn) throws SQLException {
        String dateLocale = conn.getclLocale();
        GregorianCalendar gcToday = null;
        gcToday = dateUtil.getCurrentDateGC(conn);
        int currentCentury = gcToday.get(1) / 100;
        int y = currentCentury * 100;
        int m = 0;
        int d = 1;
        Date dateObj = null;
        String datepart = null;
        boolean needCentury = false;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        StringTokenizer dT = new StringTokenizer(dateStr, "/-.");
        if (dT.countTokens() != 3) {
            throw IfxErrMsg.getSQLException(-79802, "\"" + dateStr + "\"", conn);
        }
        String[] dateField = dateUtil.getLocaleDateOrder(clLocale, false);
        for (int i = 0; i < dateField.length; ++i) {
            datepart = dT.nextToken();
            if (dateField[i].indexOf("YEAR") != -1) {
                y = stringUtil.stringToInt(datepart);
                if (datepart.length() >= 3) continue;
                needCentury = true;
                continue;
            }
            if (dateField[i].indexOf("MONTH") != -1) {
                m = stringUtil.stringToInt(datepart) - 1;
                continue;
            }
            d = stringUtil.stringToInt(datepart);
        }
        if (!dateUtil.isValidDate(y, m + 1, d)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + dateStr + "\"", conn);
        }
        try {
            if (needCentury) {
                y += dateUtil.getCentury(conn, y, m + 1, d);
            }
            GregorianCalendar gc = (GregorianCalendar)localCalendar.get();
            gc.set(y, m, d);
            dateObj = new Date(gc.getTimeInMillis());
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79786, e.toString(), conn);
        }
        return dateObj;
    }

    private static Object getLocaleDateTimeObj(String datetimeStr, IfxConnection conn, boolean isTime) throws SQLException {
        java.util.Date datetimeObj = null;
        boolean needCentury = false;
        StringTokenizer dT = null;
        int y = 0;
        int m = 0;
        int d = 0;
        int h = 0;
        int min = 0;
        int s = 0;
        int f = -1;
        try {
            if (!isTime) {
                dT = new StringTokenizer(datetimeStr, "-:. ");
                String yearpart = dT.nextToken();
                y = stringUtil.stringToInt(yearpart);
                if (yearpart.length() < 3) {
                    needCentury = true;
                }
                m = stringUtil.stringToInt(dT.nextToken()) - 1;
                d = stringUtil.stringToInt(dT.nextToken());
                h = stringUtil.stringToInt(dT.nextToken());
                min = stringUtil.stringToInt(dT.nextToken());
                s = stringUtil.stringToInt(dT.nextToken());
                if (dT.hasMoreTokens()) {
                    String frac = dT.nextToken();
                    if (stringUtil.isANum(frac) && frac.length() <= 9) {
                        if (frac.length() < 9) {
                            frac = frac + ZEROS.substring(0, 9 - frac.length());
                        }
                        f = stringUtil.stringToInt(frac);
                    } else {
                        throw IfxErrMsg.getSQLException(-79786, datetimeStr, conn);
                    }
                }
                if (needCentury) {
                    y += dateUtil.getCentury(conn, y, m + 1, d);
                }
                GregorianCalendar gc = (GregorianCalendar)localCalendar.get();
                gc.set(y, m, d, h, min, s);
                Timestamp dtObj = new Timestamp(gc.getTimeInMillis());
                dtObj.setNanos(0);
                if (f != -1) {
                    dtObj.setNanos(f);
                }
                datetimeObj = dtObj;
            } else {
                Time timeObj;
                dT = new StringTokenizer(datetimeStr, COLON);
                h = stringUtil.stringToInt(dT.nextToken());
                min = stringUtil.stringToInt(dT.nextToken());
                s = stringUtil.stringToInt(dT.nextToken());
                datetimeObj = timeObj = new Time(h, min, s);
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79786, e.toString(), conn);
        }
        return datetimeObj;
    }

    private static String[] getLocaleDateOrder(Locale clLocale, boolean retToken) {
        String datepart = null;
        String[] dateField = !retToken ? new String[3] : new String[5];
        GregorianCalendar gc = (GregorianCalendar)localCalendar.get();
        gc.set(1964, 1, 7);
        Date dateObj = new Date(gc.getTimeInMillis());
        int dateStyle = 3;
        DateFormat formatter = DateFormat.getDateInstance(dateStyle, clLocale);
        String locdateStr = formatter.format(dateObj);
        StringTokenizer locdT = new StringTokenizer(locdateStr, "/-.", retToken);
        for (int i = 0; i < dateField.length; ++i) {
            datepart = locdT.nextToken();
            if (datepart.indexOf("64") != -1) {
                if (datepart.length() > 2) {
                    dateField[i] = "YEAR4";
                    continue;
                }
                dateField[i] = "YEAR2";
                continue;
            }
            dateField[i] = datepart.equals("02") ? "MONTH2" : (datepart.equals("2") ? "MONTH1" : (datepart.equals("07") ? "DAY2" : (datepart.equals("7") ? "DAY1" : (datepart.equals(SLASH) ? SLASH : (datepart.equals(HYPHEN) ? HYPHEN : PERIOD)))));
        }
        return dateField;
    }

    public static Locale getLocaleValue(String dateLocale) {
        Locale clLocale = null;
        if (dateLocale != null) {
            StringTokenizer dT = new StringTokenizer(dateLocale, UNDERSCORE);
            String lang = dT.nextToken();
            String ccode = dT.nextToken();
            clLocale = new Locale(lang, ccode);
        } else {
            clLocale = new Locale(Locale.getDefault().getLanguage(), Locale.getDefault().getCountry());
        }
        return clLocale;
    }

    public static String convertNativeSQLDate(String dateStr, IfxConnection conn) throws SQLException {
        String locdateStr = null;
        String locdateFmt = "";
        if (conn.getdbDate() != null) {
            locdateFmt = conn.getdbDate();
            locdateStr = dateUtil.convertdbDate(dateStr, conn.getclLocale(), locdateFmt);
        } else if (conn.getglDate() != null) {
            locdateFmt = conn.getglDate();
            locdateStr = dateUtil.convertglDate(dateStr, conn.getclLocale(), locdateFmt);
        } else {
            locdateStr = dateUtil.convertcllDate(dateStr, conn.getclLocale());
        }
        if (locdateStr == null) {
            throw IfxErrMsg.getSQLException(-79785, "\"" + locdateFmt + "\"", conn);
        }
        return locdateStr;
    }

    public static String convertNativeSQLDateTime(String datetimeStr, IfxConnection conn, boolean isTime) throws SQLException {
        String locdatetimeStr = null;
        String locdatetimeFmt = "";
        if (!conn.getuseDtenv() || conn.getuseDtenv() && conn.getdbTime() == null && conn.getglDateTime() == null && !conn.getclLocaleProp() && !conn.getdbLocaleProp()) {
            if (!isTime) {
                if (!dateUtil.isValidTimeStamp(datetimeStr)) {
                    throw IfxErrMsg.getSQLException(-79712, "\"" + datetimeStr + "\"", conn);
                }
                locdatetimeStr = dateUtil.IfxTimeStamp(datetimeStr);
            } else {
                if (!dateUtil.isValidTime(datetimeStr)) {
                    throw IfxErrMsg.getSQLException(-79711, "\"" + datetimeStr + "\"", conn);
                }
                locdatetimeStr = datetimeStr;
            }
        } else if (conn.getdbTime() != null) {
            locdatetimeFmt = conn.getdbTime();
            locdatetimeStr = dateUtil.convertdbDateTime(datetimeStr, conn, locdatetimeFmt, isTime);
        } else if (conn.getglDateTime() != null) {
            locdatetimeFmt = conn.getglDateTime();
            locdatetimeStr = dateUtil.convertdbDateTime(datetimeStr, conn, locdatetimeFmt, isTime);
        } else {
            locdatetimeStr = dateUtil.convertcllDateTime(datetimeStr, conn.getclLocale(), isTime);
        }
        if (locdatetimeStr == null) {
            throw IfxErrMsg.getSQLException(-79785, "\"" + locdatetimeFmt + "\"", conn);
        }
        return locdatetimeStr;
    }

    public static String convertDateStr(Date date, IfxConnection conn) throws SQLException {
        String locdateStr = null;
        if (conn.getdbDate() != null) {
            locdateStr = dateUtil.getdbDateStr(date, conn.getclLocale(), conn.getdbDate());
        } else if (conn.getglDate() != null) {
            boolean nativeSQL = false;
            locdateStr = dateUtil.getglDateStr(date, conn.getclLocale(), conn.getglDate(), nativeSQL);
        } else {
            locdateStr = dateUtil.getLocaleDateStr(date, conn.getclLocale());
        }
        return locdateStr;
    }

    public static String convertDateTimeStr(Object datetime, IfxConnection conn, long value) throws SQLException {
        String locdatetimeStr = null;
        boolean nativeSQL = false;
        if (datetime == null || !conn.getuseDtenv() || conn.getuseDtenv() && conn.getdbTime() == null && conn.getglDateTime() == null && !conn.getclLocaleProp() && !conn.getdbLocaleProp()) {
            locdatetimeStr = datetime instanceof Timestamp ? dateUtil.IfxTimeStamp(datetime.toString()) : datetime.toString();
        } else if (conn.getdbTime() != null) {
            if (datetime instanceof Time) {
                Timestamp ts = new Timestamp(value);
                locdatetimeStr = dateUtil.getglDateStr(ts, conn.getclLocale(), conn.getdbTime(), nativeSQL);
            } else {
                locdatetimeStr = dateUtil.getglDateStr(datetime, conn.getclLocale(), conn.getdbTime(), nativeSQL);
            }
        } else if (conn.getglDateTime() != null) {
            if (datetime instanceof Time) {
                Timestamp ts = new Timestamp(value);
                locdatetimeStr = dateUtil.getglDateStr(ts, conn.getclLocale(), conn.getglDateTime(), nativeSQL);
            } else {
                locdatetimeStr = dateUtil.getglDateStr(datetime, conn.getclLocale(), conn.getglDateTime(), nativeSQL);
            }
        } else {
            locdatetimeStr = dateUtil.getLocaleDateTimeStr(datetime, conn.getclLocale());
        }
        return locdatetimeStr;
    }

    public static Date convertDateObj(String dateStr, IfxConnection conn) throws SQLException {
        Object locdateObj = null;
        boolean isDate = true;
        boolean isTime = false;
        locdateObj = conn.getdbDate() != null ? dateUtil.getdbDateObj(dateStr, conn) : (conn.getglDate() != null ? dateUtil.getglDateObj(dateStr, conn, isDate, isTime) : dateUtil.getLocaleDateObj(dateStr, conn));
        return locdateObj;
    }

    public static Object convertDateTimeObj(String datetimeStr, IfxConnection conn, boolean isTime) throws SQLException {
        Object locdatetimeObj = null;
        boolean isDate = false;
        boolean needCentury = false;
        int y = 0;
        int m = 0;
        int d = 0;
        int h = 0;
        int min = 0;
        int s = 0;
        int f = -1;
        StringTokenizer dT = null;
        try {
            if (datetimeStr != null) {
                if (!conn.getuseDtenv() || conn.getuseDtenv() && conn.getdbTime() == null && conn.getglDateTime() == null && !conn.getclLocaleProp() && !conn.getdbLocaleProp()) {
                    if (!isTime) {
                        dT = new StringTokenizer(datetimeStr, "-:. ");
                        if (dT.hasMoreTokens()) {
                            String yearpart = dT.nextToken();
                            y = stringUtil.stringToInt(yearpart);
                            if (yearpart.length() < 3) {
                                needCentury = true;
                            }
                        }
                        if (dT.hasMoreTokens()) {
                            m = stringUtil.stringToInt(dT.nextToken()) - 1;
                            if (dT.hasMoreTokens()) {
                                d = stringUtil.stringToInt(dT.nextToken());
                                if (dT.hasMoreTokens()) {
                                    h = stringUtil.stringToInt(dT.nextToken());
                                    if (dT.hasMoreTokens()) {
                                        min = stringUtil.stringToInt(dT.nextToken());
                                        if (dT.hasMoreTokens()) {
                                            s = stringUtil.stringToInt(dT.nextToken());
                                        }
                                    }
                                }
                            }
                        }
                        if (dT.hasMoreTokens()) {
                            String frac = dT.nextToken();
                            if (stringUtil.isANum(frac) && frac.length() <= 9) {
                                if (frac.length() < 9) {
                                    frac = frac + ZEROS.substring(0, 9 - frac.length());
                                }
                                f = stringUtil.stringToInt(frac);
                            } else {
                                throw IfxErrMsg.getSQLException(-79786, datetimeStr, conn);
                            }
                        }
                        if (needCentury) {
                            y += dateUtil.getCentury(conn, y, m + 1, d);
                        }
                        GregorianCalendar gc = (GregorianCalendar)localCalendar.get();
                        gc.set(y, m, d, h, min, s);
                        Timestamp dtObj = new Timestamp(gc.getTimeInMillis());
                        dtObj.setNanos(0);
                        if (f != -1) {
                            dtObj.setNanos(f);
                        }
                        locdatetimeObj = dtObj;
                    } else {
                        dT = new StringTokenizer(datetimeStr, COLON);
                        h = stringUtil.stringToInt(dT.nextToken());
                        min = stringUtil.stringToInt(dT.nextToken());
                        s = stringUtil.stringToInt(dT.nextToken());
                        Time timeObj = new Time(h, min, s);
                        locdatetimeObj = timeObj;
                    }
                } else {
                    locdatetimeObj = conn.getdbTime() != null || conn.getglDateTime() != null ? dateUtil.getglDateObj(datetimeStr, conn, isDate, isTime) : dateUtil.getLocaleDateTimeObj(datetimeStr, conn, isTime);
                }
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79786, e.toString(), conn);
        }
        return locdatetimeObj;
    }

    private static String getglDateXPattern(String[] dateField) {
        String xpattern = "";
        for (int z = 0; z < dateField.length; ++z) {
            xpattern = dateField[z].equals("YEAR4") ? xpattern + "yyyy" : (dateField[z].equals("YEAR2") ? xpattern + "yy" : (dateField[z].equals("MONTH1") ? xpattern + "M" : (dateField[z].equals("MONTH2") ? xpattern + "MM" : (dateField[z].equals("DAY1") ? xpattern + "d" : (dateField[z].equals("DAY2") ? xpattern + "dd" : (dateField[z].equals(SLASH) ? xpattern + SLASH : (dateField[z].equals(HYPHEN) ? xpattern + HYPHEN : xpattern + PERIOD)))))));
        }
        return xpattern;
    }

    private static String getInfmxglPattern(Object date, char glDirective, Locale clLocale) {
        String infmxPattern = "";
        DateFormatSymbols symbols = new DateFormatSymbols(clLocale);
        String[] jdkdefDays = new String[8];
        String[] infmxdefDays = new String[8];
        String[] jdkdefMonths = new String[13];
        String[] infmxdefMonths = new String[13];
        String dateStr = null;
        block0 : switch (glDirective) {
            case 'b': 
            case 'h': {
                String[] tmpdefMonths;
                dateStr = dateUtil.formatDate(date, clLocale, "MMM");
                jdkdefMonths = symbols.getShortMonths();
                if (clLocale.toString().equals(Locale.JAPAN.toString())) {
                    tmpdefMonths = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""};
                    System.arraycopy(tmpdefMonths, 0, infmxdefMonths, 0, 13);
                } else {
                    tmpdefMonths = new String[]{"Jan", "F\u00e9v", "Mar", "Avr", "Mai", "Jun", "Jul", "Ao\u00fb", "Sep", "Oct", "Nov", "D\u00e9c", ""};
                    System.arraycopy(tmpdefMonths, 0, infmxdefMonths, 0, 13);
                }
                for (int j = 0; j < jdkdefMonths.length - 1; ++j) {
                    if (!dateStr.equals(jdkdefMonths[j])) continue;
                    infmxPattern = infmxdefMonths[j];
                    break block0;
                }
                break;
            }
            case 'B': {
                dateStr = dateUtil.formatDate(date, clLocale, "MMMMM");
                jdkdefMonths = symbols.getMonths();
                String[] tmpdefMonths = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", ""};
                System.arraycopy(tmpdefMonths, 0, infmxdefMonths, 0, 13);
                for (int j = 0; j < jdkdefMonths.length - 1; ++j) {
                    if (!dateStr.equals(jdkdefMonths[j])) continue;
                    infmxPattern = infmxdefMonths[j];
                    break block0;
                }
                break;
            }
            case 'a': {
                String[] tmpdefDays;
                dateStr = dateUtil.formatDate(date, clLocale, "E");
                jdkdefDays = symbols.getShortWeekdays();
                Locale turkey_loc = new Locale("tr", "TR", "");
                if (clLocale.toString().equals(turkey_loc.toString())) {
                    tmpdefDays = new String[]{"", "Pzr", "Pzt", "Sal", "\u00e7ar", "Per", "Cum", "Cts"};
                    System.arraycopy(tmpdefDays, 0, infmxdefDays, 0, 8);
                } else {
                    tmpdefDays = new String[]{"", "Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam"};
                    System.arraycopy(tmpdefDays, 0, infmxdefDays, 0, 8);
                }
                for (int j = 0; j < jdkdefDays.length - 1; ++j) {
                    if (!dateStr.equals(jdkdefDays[j + 1])) continue;
                    infmxPattern = infmxdefDays[j + 1];
                    break block0;
                }
                break;
            }
        }
        return infmxPattern;
    }

    private static int getCentury(IfxConnection conn, int year, int month, int day) throws SQLException {
        if (conn == null) {
            throw IfxErrMsg.getSQLException(-79716, "getCentury: conn is null.", (Locale)null);
        }
        Trace trace = conn.getTrace();
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "dateUtil: getCentury() entered");
            trace.writeTrace(logger, 3, "    getCentury() year: " + year);
            trace.writeTrace(logger, 3, "    getCentury() month: " + month);
            trace.writeTrace(logger, 3, "    getCentury() day: " + day);
            trace.writeTrace(logger, 3, "    getCentury() dbcentury: " + conn.getdbCentury());
            trace.writeTrace(logger, 1, "");
        }
        if (year > 99) {
            return 0;
        }
        GregorianCalendar gcToday = null;
        int currentCentury = 0;
        int centuryReturned = 0;
        gcToday = dateUtil.getCurrentDateGC(conn);
        currentCentury = gcToday.get(1) / 100;
        if (conn.getdbCentury() == null || conn.getdbCentury().equalsIgnoreCase("R")) {
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "    getCentury() just return the current");
            }
            centuryReturned = currentCentury;
        } else {
            long msToday = 0L;
            long msPresent = 0L;
            long msFuture = 0L;
            long msPast = 0L;
            GregorianCalendar gc = null;
            msToday = gcToday.getTimeInMillis();
            int currentMonth = gcToday.get(2);
            int currentDay = gcToday.get(5);
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "    getCentury() currentMonth: " + currentMonth);
                trace.writeTrace(logger, 2, "    getCentury() currentDay: " + currentDay);
                trace.writeTrace(logger, 2, "    getCentury() currentCentury: " + currentCentury);
                trace.writeTrace(logger, 2, "");
            }
            int tmpMonth = month;
            int tmpDay = day;
            int tmpYear = currentCentury * 100 + year;
            if (tmpMonth == 29 && tmpDay == 2 && dateUtil.isLeapYear(tmpYear)) {
                tmpMonth = 3;
                tmpDay = 1;
            }
            gc = (GregorianCalendar)localCalendar.get();
            gc.set(tmpYear, tmpMonth - 1, tmpDay);
            msPresent = gc.getTimeInMillis();
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "    getCentury() msPresent: " + msPresent);
                trace.writeTrace(logger, 2, "    getCentury() Present: " + gc.getTime());
                trace.writeTrace(logger, 2, "");
            }
            tmpMonth = month;
            tmpDay = day;
            tmpYear = (currentCentury - 1) * 100 + year;
            if (tmpMonth == 29 && tmpDay == 2 && dateUtil.isLeapYear(tmpYear)) {
                tmpMonth = 3;
                tmpDay = 1;
            }
            gc = (GregorianCalendar)localCalendar.get();
            gc.set(tmpYear, tmpMonth - 1, tmpDay);
            msPast = gc.getTimeInMillis();
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "    getCentury() msPast: " + msPast);
                trace.writeTrace(logger, 2, "    getCentury() Past: " + gc.getTime());
                trace.writeTrace(logger, 2, "");
            }
            tmpMonth = month;
            tmpDay = day;
            tmpYear = (currentCentury + 1) * 100 + year;
            if (tmpMonth == 29 && tmpDay == 2 && dateUtil.isLeapYear(tmpYear)) {
                tmpMonth = 3;
                tmpDay = 1;
            }
            gc = (GregorianCalendar)localCalendar.get();
            gc.set(tmpYear, tmpMonth - 1, tmpDay);
            msFuture = gc.getTimeInMillis();
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "    getCentury() msFuture: " + msFuture);
                trace.writeTrace(logger, 2, "    getCentury() Future: " + gc.getTime());
                trace.writeTrace(logger, 2, "");
            }
            long present_diff = 0L;
            long past_diff = 0L;
            long future_diff = 0L;
            char dbCentury = conn.getdbCentury().toUpperCase().charAt(0);
            switch (dbCentury) {
                case 'C': {
                    present_diff = Math.abs(msPresent - msToday);
                    past_diff = Math.abs(msPast - msToday);
                    future_diff = Math.abs(msFuture - msToday);
                    if (TraceFlag.isTraceEnabled()) {
                        String s = "    getCentury() 'C': \n";
                        s = s + "\tpresent_diff: " + present_diff + "\n";
                        s = s + "\tpast_diff: " + past_diff + "\n ";
                        s = s + "\tfuture_diff: " + future_diff + "\n";
                        trace.writeTrace(logger, 2, "    getCentury() 'C': " + s);
                        trace.writeTrace(logger, 2, "");
                    }
                    if (present_diff < past_diff) {
                        if (present_diff < future_diff) {
                            centuryReturned = currentCentury;
                            break;
                        }
                        centuryReturned = currentCentury + 1;
                        break;
                    }
                    if (past_diff < future_diff) {
                        centuryReturned = currentCentury - 1;
                        break;
                    }
                    centuryReturned = currentCentury + 1;
                    break;
                }
                case 'P': {
                    present_diff = msPresent - msToday;
                    past_diff = msPast - msToday;
                    if (TraceFlag.isTraceEnabled()) {
                        String s = "    getCentury() 'P': \n";
                        s = s + "\tpresent_diff: " + present_diff + "\n";
                        s = s + "\tpast_diff: " + past_diff + "\n ";
                        trace.writeTrace(logger, 2, "    getCentury() 'P': " + s);
                        trace.writeTrace(logger, 2, "");
                    }
                    if (present_diff < 0L) {
                        centuryReturned = currentCentury;
                        break;
                    }
                    centuryReturned = currentCentury - 1;
                    break;
                }
                case 'F': {
                    present_diff = msPresent - msToday;
                    future_diff = msFuture - msToday;
                    if (TraceFlag.isTraceEnabled()) {
                        String s = "    getCentury() 'F': \n";
                        s = s + "\tpresent_diff: " + present_diff + "\n";
                        s = s + "\tfuture_diff: " + future_diff + "\n";
                        trace.writeTrace(logger, 2, "    getCentury() 'C': " + s);
                        trace.writeTrace(logger, 2, "");
                    }
                    if (present_diff > 0L) {
                        centuryReturned = currentCentury;
                        break;
                    }
                    centuryReturned = currentCentury + 1;
                    break;
                }
                default: {
                    centuryReturned = currentCentury;
                }
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 2, "dateUtil: getCentury() centuryReturned = " + centuryReturned);
            trace.writeTrace(logger, 1, "dateUtil: getCentury() exited");
        }
        return centuryReturned * 100;
    }

    public static GregorianCalendar getCurrentDateGC(IfxConnection conn) throws SQLException {
        if (conn == null) {
            throw IfxErrMsg.getSQLException(-79716, "getCurrentDateGC: conn is null.", (Locale)null);
        }
        Trace trace = conn.getTrace();
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "dateUtil: getCurrentDateGC() entered");
            trace.writeTrace(logger, 3, "    getCurrentDateGC() locString: " + conn.getclLocale());
            trace.writeTrace(logger, 3, "    getCurrentDateGC() dbTodayStart: " + conn.getdbTodayStart());
            trace.writeTrace(logger, 3, "    getCurrentDateGC() getdbTodayDate: " + conn.getdbTodayDate());
        }
        Locale loc = dateUtil.getLocaleValue(conn.getclLocale());
        GregorianCalendar gcToday = new GregorianCalendar(loc);
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "    gcToday(): " + gcToday.getTime());
        }
        long dbTodayStart = conn.getdbTodayStart();
        long dbTodayDate = conn.getdbTodayDate();
        if (dbTodayDate != -1L && dbTodayStart != -1L) {
            long currentMillis = gcToday.getTimeInMillis();
            long diff = currentMillis - dbTodayStart;
            long current = dbTodayDate + diff;
            java.util.Date d = new java.util.Date(current);
            gcToday = new GregorianCalendar();
            gcToday.setTime(d);
        }
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "    getCurrentDateGC() value returned: " + gcToday.getTime());
            trace.writeTrace(logger, 1, "dateUtil: getCurrentDateGC() exited");
        }
        return gcToday;
    }

    public static boolean isValidDate(int year, int month, int day) {
        if (month < 1 || month > 12) {
            return false;
        }
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (day >= 1 && day <= 31) break;
                return false;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (day >= 1 && day <= 30) break;
                return false;
            }
            case 2: {
                int max = 28;
                if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                    max = 29;
                }
                if (day >= 1 && day <= max) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

