/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.servicesmanager;

import com.ibm.jbatch.container.callback.IJobEndCallbackService;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.impl.BatchConfigImpl;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.services.IJobStatusManagerService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServiceTypes;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.util.BatchContainerConstants;
import com.ibm.jbatch.spi.BatchSPIManager;
import com.ibm.jbatch.spi.DatabaseConfigurationBean;
import com.ibm.jbatch.spi.ServiceRegistry;
import com.ibm.jbatch.spi.services.IBatchArtifactFactory;
import com.ibm.jbatch.spi.services.IBatchServiceBase;
import com.ibm.jbatch.spi.services.IBatchThreadPoolService;
import com.ibm.jbatch.spi.services.IJobXMLLoaderService;
import com.ibm.jbatch.spi.services.ITransactionManagementService;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServicesManagerImpl
implements BatchContainerConstants,
ServicesManager {
    private static final String sourceClass = ServicesManagerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private final byte[] isInitedLock = new byte[0];
    private volatile Boolean isInited = Boolean.FALSE;
    private DatabaseConfigurationBean databaseConfigBean = null;
    private BatchConfigImpl batchConfigImpl;
    private Properties batchContainerProps = null;
    private Map<ServiceTypes.Name, String> serviceImplClassNames = ServiceTypes.getServiceImplClassNames();
    private Map<String, ServiceTypes.Name> propertyNameTable = ServiceTypes.getServicePropertyNames();
    private final ConcurrentHashMap<ServiceTypes.Name, IBatchServiceBase> serviceRegistry = new ConcurrentHashMap();
    private BatchSPIManager.PlatformMode platformMode = null;

    private ServicesManagerImpl() {
    }

    public static ServicesManager getInstance() {
        return ServicesManagerImplHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void initIfNecessary() {
        if (logger.isLoggable(Level.FINER)) {
            logger.config("In initIfNecessary().");
        }
        if (!this.isInited.booleanValue()) {
            byte[] byArray = this.isInitedLock;
            // MONITORENTER : this.isInitedLock
            if (!this.isInited.booleanValue()) {
                logger.config("--- Initializing ServicesManagerImpl ---");
                this.batchConfigImpl = new BatchConfigImpl();
                this.readConfigFromPropertiesFiles();
                this.readConfigFromSPI();
                this.readConfigFromSystemProperties();
                this.initBatchConfigImpl();
                this.initServiceImplOverrides();
                this.initDatabaseConfig();
                this.initPlatformSEorEE();
                this.isInited = Boolean.TRUE;
                logger.config("--- Completed initialization of ServicesManagerImpl ---");
            }
            // MONITOREXIT : byArray
        }
        logger.config("Exiting initIfNecessary()");
    }

    private void readConfigFromPropertiesFiles() {
        Properties serviceIntegratorProps = new Properties();
        InputStream batchServicesListInputStream = this.getClass().getResourceAsStream("/META-INF/services/batch-services.properties");
        if (batchServicesListInputStream != null) {
            try {
                logger.config("Batch Integrator Config File exists! loading it..");
                serviceIntegratorProps.load(batchServicesListInputStream);
                batchServicesListInputStream.close();
            }
            catch (IOException e) {
                logger.config("Error loading /META-INF/services/batch-services.properties IOException=" + e.toString());
            }
            catch (Exception e) {
                logger.config("Error loading /META-INF/services/batch-services.properties Exception=" + e.toString());
            }
        } else {
            logger.config("Could not find batch integrator config file: /META-INF/services/batch-services.properties");
        }
        HashSet<String> removeThese = new HashSet<String>();
        for (Object key : serviceIntegratorProps.keySet()) {
            String keyStr = (String)key;
            if (this.propertyNameTable.containsKey(keyStr)) continue;
            logger.warning("Found property named: " + keyStr + " with value: " + serviceIntegratorProps.get(keyStr) + " in " + "batch-services.properties" + " , but did not find a corresponding service type " + "in the internal table of service types.\n Ignoring this property then.   Maybe this should have been set in batch-config.properties instead.");
            removeThese.add(keyStr);
        }
        for (String s : removeThese) {
            serviceIntegratorProps.remove(s);
        }
        Properties adminProps = new Properties();
        InputStream batchAdminConfigListInputStream = this.getClass().getResourceAsStream("/META-INF/services/batch-config.properties");
        if (batchServicesListInputStream != null) {
            try {
                logger.config("Batch Admin Config File exists! loading it..");
                adminProps.load(batchAdminConfigListInputStream);
                batchAdminConfigListInputStream.close();
            }
            catch (IOException e) {
                logger.config("Error loading /META-INF/services/batch-config.properties IOException=" + e.toString());
            }
            catch (Exception e) {
                logger.config("Error loading /META-INF/services/batch-config.properties Exception=" + e.toString());
            }
        } else {
            logger.config("Could not find batch admin config file: /META-INF/services/batch-config.properties");
        }
        HashSet removeTheseToo = new HashSet();
        for (Object key : adminProps.keySet()) {
            String keyStr = (String)key;
            if (!this.propertyNameTable.containsKey(keyStr)) continue;
            logger.warning("Found property named: " + keyStr + " with value: " + adminProps.get(keyStr) + " in " + "batch-config.properties" + " , but this is a batch runtime service configuration.\n" + "Ignoring this property then, since this should have been set in batch-services.properties instead.");
            removeThese.add(keyStr);
        }
        for (String s : removeTheseToo) {
            adminProps.remove(s);
        }
        this.batchContainerProps = new Properties();
        this.batchContainerProps.putAll((Map<?, ?>)adminProps);
        this.batchContainerProps.putAll((Map<?, ?>)serviceIntegratorProps);
    }

    private void readConfigFromSPI() {
        this.batchContainerProps.putAll((Map<?, ?>)BatchSPIManager.getInstance().getBatchContainerOverrideProperties());
        BatchSPIManager.PlatformMode mode = BatchSPIManager.getInstance().getPlatformMode();
        if (mode != null) {
            if (mode.equals((Object)BatchSPIManager.PlatformMode.EE)) {
                logger.config("SPI configured platform selection of EE");
                this.batchContainerProps.setProperty("J2SE_MODE", "false");
            } else if (mode.equals((Object)BatchSPIManager.PlatformMode.SE)) {
                logger.config("SPI configured platform selection of SE");
                this.batchContainerProps.setProperty("J2SE_MODE", "true");
            }
        }
    }

    private void readConfigFromSystemProperties() {
        this.batchContainerProps.putAll((Map<?, ?>)ServiceRegistry.getSystemPropertyOverrides());
    }

    private void initBatchConfigImpl() {
        logger.fine("Dumping contents of batchContainerProps after reading properties files and calling SPI.");
        for (Object key : this.batchContainerProps.keySet()) {
            logger.config("key = " + key);
            logger.config("value = " + this.batchContainerProps.get(key));
        }
        this.batchConfigImpl.setConfigProperties(this.batchContainerProps);
    }

    private void initServiceImplOverrides() {
        for (String propKey : this.propertyNameTable.keySet()) {
            String value = this.batchContainerProps.getProperty(propKey);
            if (value == null) continue;
            ServiceTypes.Name serviceType = this.propertyNameTable.get(propKey);
            String defaultServiceImplClassName = this.serviceImplClassNames.get((Object)serviceType);
            this.serviceImplClassNames.put(serviceType, value.trim());
            logger.config("Overriding serviceType: " + (Object)((Object)serviceType) + ", replacing default impl classname: " + defaultServiceImplClassName + " with override impl class name: " + value.trim());
        }
    }

    private void initDatabaseConfig() {
        if (this.databaseConfigBean == null) {
            logger.config("First try to load 'suggested config' from BatchSPIManager");
            this.databaseConfigBean = BatchSPIManager.getInstance().getFinalDatabaseConfiguration();
            if (this.databaseConfigBean == null) {
                logger.config("Loading database config from configuration properties file.");
                this.databaseConfigBean = new DatabaseConfigurationBean();
                this.databaseConfigBean.setJndiName(this.batchContainerProps.getProperty("JNDI_NAME", "jdbc/batch"));
                this.databaseConfigBean.setJdbcDriver(this.batchContainerProps.getProperty("JDBC_DRIVER", "org.apache.derby.jdbc.EmbeddedDriver"));
                this.databaseConfigBean.setJdbcUrl(this.batchContainerProps.getProperty("JDBC_URL", "jdbc:derby:RUNTIMEDB;create=true"));
                this.databaseConfigBean.setDbUser(this.batchContainerProps.getProperty("DB_USER"));
                this.databaseConfigBean.setDbPassword(this.batchContainerProps.getProperty("DB_PWD"));
                this.databaseConfigBean.setSchema(this.batchContainerProps.getProperty("DB_SCHEMA", "JBATCH"));
            }
        } else {
            logger.config("Database config has been set directly from SPI, do NOT load from properties file.");
        }
        this.batchConfigImpl.setDatabaseConfigurationBean(this.databaseConfigBean);
    }

    private void initPlatformSEorEE() {
        String seMode = this.serviceImplClassNames.get((Object)ServiceTypes.Name.JAVA_EDITION_IS_SE_DUMMY_SERVICE);
        if (seMode.equalsIgnoreCase("true")) {
            this.platformMode = BatchSPIManager.PlatformMode.SE;
            this.batchConfigImpl.setJ2seMode(true);
        } else {
            this.platformMode = BatchSPIManager.PlatformMode.EE;
            this.batchConfigImpl.setJ2seMode(false);
        }
    }

    private IBatchServiceBase getService(ServiceTypes.Name serviceType) throws BatchContainerServiceException {
        String sourceMethod = "getService";
        logger.entering(sourceClass, sourceMethod + ", serviceType=" + (Object)((Object)serviceType));
        this.initIfNecessary();
        IBatchServiceBase service = new ServiceLoader(serviceType).getService();
        logger.exiting(sourceClass, sourceMethod);
        return service;
    }

    @Override
    public ITransactionManagementService getTransactionManagementService() {
        return (ITransactionManagementService)this.getService(ServiceTypes.Name.TRANSACTION_SERVICE);
    }

    @Override
    public IPersistenceManagerService getPersistenceManagerService() {
        return (IPersistenceManagerService)this.getService(ServiceTypes.Name.PERSISTENCE_MANAGEMENT_SERVICE);
    }

    @Override
    public IJobStatusManagerService getJobStatusManagerService() {
        return (IJobStatusManagerService)this.getService(ServiceTypes.Name.JOB_STATUS_MANAGEMENT_SERVICE);
    }

    @Override
    public IBatchThreadPoolService getThreadPoolService() {
        return (IBatchThreadPoolService)this.getService(ServiceTypes.Name.BATCH_THREADPOOL_SERVICE);
    }

    @Override
    public IBatchKernelService getBatchKernelService() {
        return (IBatchKernelService)this.getService(ServiceTypes.Name.BATCH_KERNEL_SERVICE);
    }

    @Override
    public IJobEndCallbackService getJobCallbackService() {
        return (IJobEndCallbackService)this.getService(ServiceTypes.Name.CALLBACK_SERVICE);
    }

    @Override
    public IJobXMLLoaderService getPreferredJobXMLLoaderService() {
        return (IJobXMLLoaderService)this.getService(ServiceTypes.Name.JOBXML_LOADER_SERVICE);
    }

    @Override
    public IJobXMLLoaderService getDelegatingJobXMLLoaderService() {
        return (IJobXMLLoaderService)this.getService(ServiceTypes.Name.DELEGATING_JOBXML_LOADER_SERVICE);
    }

    @Override
    public IBatchArtifactFactory getPreferredArtifactFactory() {
        return (IBatchArtifactFactory)this.getService(ServiceTypes.Name.CONTAINER_ARTIFACT_FACTORY_SERVICE);
    }

    @Override
    public IBatchArtifactFactory getDelegatingArtifactFactory() {
        return (IBatchArtifactFactory)this.getService(ServiceTypes.Name.DELEGATING_ARTIFACT_FACTORY_SERVICE);
    }

    @Override
    public BatchSPIManager.PlatformMode getPlatformMode() {
        this.initIfNecessary();
        return this.platformMode;
    }

    private class ServiceLoader {
        volatile IBatchServiceBase service = null;
        private ServiceTypes.Name serviceType = null;

        private ServiceLoader(ServiceTypes.Name name) {
            this.serviceType = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IBatchServiceBase getService() {
            this.service = (IBatchServiceBase)ServicesManagerImpl.this.serviceRegistry.get((Object)this.serviceType);
            if (this.service == null) {
                ConcurrentHashMap concurrentHashMap = ServicesManagerImpl.this.serviceRegistry;
                synchronized (concurrentHashMap) {
                    if (this.service == null) {
                        this.service = this._loadServiceHelper(this.serviceType);
                        this.service.init(ServicesManagerImpl.this.batchConfigImpl);
                        ServicesManagerImpl.this.serviceRegistry.putIfAbsent(this.serviceType, this.service);
                    }
                }
            }
            return this.service;
        }

        private IBatchServiceBase _loadServiceHelper(ServiceTypes.Name serviceType) {
            IBatchServiceBase service = null;
            String className = (String)ServicesManagerImpl.this.serviceImplClassNames.get((Object)serviceType);
            try {
                if (className != null) {
                    service = this._loadService(className);
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Could not instantiate service: " + className + " due to exception:" + t);
                throw new RuntimeException("Could not instantiate service " + className, t);
            }
            if (service == null) {
                throw new RuntimeException("Instantiate of service=: " + className + " for serviceType: " + (Object)((Object)serviceType) + " returned null. Aborting...");
            }
            return service;
        }

        private IBatchServiceBase _loadService(String className) throws Exception {
            Constructor<?> ctor;
            Class<?> cls;
            IBatchServiceBase service = null;
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                cls = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            if (cls != null) {
                ctor = cls.getConstructor(new Class[0]);
                if (ctor == null) {
                    throw new Exception("Service class " + className + " should  have a default constructor defined");
                }
            } else {
                throw new Exception("Exception loading Service class " + className + " make sure it exists");
            }
            service = (IBatchServiceBase)ctor.newInstance(new Object[0]);
            return service;
        }
    }

    private static class ServicesManagerImplHolder {
        private static final ServicesManagerImpl INSTANCE = new ServicesManagerImpl();

        private ServicesManagerImplHolder() {
        }
    }
}

