/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.maven.plugin.mojos;

import com.hcl.appscan.maven.plugin.Messages;
import com.hcl.appscan.maven.plugin.mojos.AppScanMojo;
import com.hcl.appscan.maven.plugin.targets.TargetFactory;
import com.hcl.appscan.sdk.scanners.sast.targets.ISASTTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="listTargets", requiresProject=true, threadSafe=false)
public final class ListTargetsMojo
extends AppScanMojo {
    private static List<String> m_targets = null;

    public ListTargetsMojo() {
        if (m_targets == null) {
            m_targets = new ArrayList<String>();
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File output;
        ISASTTarget target = TargetFactory.create(this.m_project);
        if (target != null && (output = target.getTargetFile()) != null) {
            m_targets.add(output.getAbsolutePath());
        }
        if (this.isLastProject(this.m_project)) {
            this.printTargets();
        }
    }

    private void printTargets() {
        this.getLog().info((CharSequence)Messages.getMessage("targets.found", new Object[0]));
        for (String target : m_targets) {
            this.getLog().info((CharSequence)target);
        }
    }
}

