/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.expectations;

import com.insightfullogic.lambdabehave.expectations.BoundExpectation;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class CollectionExpectation<T>
extends BoundExpectation<Collection<T>> {
    CollectionExpectation(Collection<T> objectUnderTest, boolean positive) {
        super(objectUnderTest, positive);
    }

    public CollectionExpectation<T> isEmpty() {
        return this.matches(Matchers.empty());
    }

    public CollectionExpectation<T> hasItem(T item) {
        return this.matches(Matchers.hasItem(item));
    }

    public CollectionExpectation<T> hasItem(Matcher<? super T> item) {
        return this.matches(Matchers.hasItem(item));
    }

    public CollectionExpectation<T> hasItems(T ... items) {
        return this.matches(Matchers.hasItems((Object[])items));
    }

    public CollectionExpectation<T> contains(T ... items) {
        return this.matches(Matchers.contains((Object[])items));
    }

    public CollectionExpectation<T> contains(Matcher<? super T> ... items) {
        return this.matches(Matchers.contains(items));
    }

    public CollectionExpectation<T> contains(List<Matcher<? super T>> items) {
        return this.matches(Matchers.contains(items));
    }

    public CollectionExpectation<T> containsInAnyOrder(T ... items) {
        return this.matches(Matchers.containsInAnyOrder((Object[])items));
    }

    public CollectionExpectation<T> containsInAnyOrder(Matcher<? super T> ... items) {
        return this.matches(Matchers.containsInAnyOrder(items));
    }

    public CollectionExpectation<T> containsInAnyOrder(Collection<Matcher<? super T>> items) {
        return this.matches(Matchers.containsInAnyOrder(items));
    }

    public CollectionExpectation<T> emptyCollectionOf(Class<T> type) {
        return this.matches(Matchers.emptyCollectionOf(type));
    }

    public CollectionExpectation<T> hasSize(int size) {
        return this.matches(Matchers.hasSize((int)size));
    }

    public CollectionExpectation<T> hasSize(Matcher<? super Integer> size) {
        return this.matches(Matchers.hasSize(size));
    }

    public CollectionExpectation<T> hasItems(Matcher<? super T> ... items) {
        return this.matches(Matchers.hasItems(items));
    }

    private CollectionExpectation<T> matches(Matcher<? super Collection<T>> matcher) {
        Assert.assertThat((Object)this.objectUnderTest, this.negatedIfNeeded(matcher));
        return this;
    }
}

