/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.expectations;

import com.insightfullogic.lambdabehave.expectations.BoundExpectation;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class ComparableExpectation<T extends Comparable<T>>
extends BoundExpectation<T> {
    ComparableExpectation(T value, boolean positive) {
        super(value, positive);
    }

    public ComparableExpectation<T> isGreaterThan(T value) {
        return this.matches(Matchers.greaterThan(value));
    }

    public ComparableExpectation<T> isGreaterThanOrEqualTo(T value) {
        return this.matches(Matchers.greaterThanOrEqualTo(value));
    }

    public ComparableExpectation<T> isLessThan(T value) {
        return this.matches(Matchers.lessThan(value));
    }

    public ComparableExpectation<T> isLessThanOrEqualTo(T value) {
        return this.matches(Matchers.lessThanOrEqualTo(value));
    }

    public ComparableExpectation<T> comparesEqualTo(T expected) {
        return this.matches(Matchers.comparesEqualTo(expected));
    }

    private ComparableExpectation<T> matches(Matcher<T> matcher) {
        Assert.assertThat((Object)this.objectUnderTest, this.negatedIfNeeded(matcher));
        return this;
    }
}

