/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl;

import com.insightfullogic.lambdabehave.SpecificationError;
import com.insightfullogic.lambdabehave.TestFailure;
import com.insightfullogic.lambdabehave.impl.CompleteBehaviour;
import com.insightfullogic.lambdabehave.impl.reports.SpecificationReport;
import java.lang.annotation.Annotation;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSuiteRunner
extends ParentRunner<CompleteBehaviour> {
    protected static final Logger log = LoggerFactory.getLogger(AbstractSuiteRunner.class);
    protected final List<CompleteBehaviour> children;
    protected final String name;

    public AbstractSuiteRunner(Class<?> testClass, String name, List<CompleteBehaviour> children) throws InitializationError {
        super(testClass);
        this.name = name;
        this.children = children;
    }

    protected String getName() {
        return this.name;
    }

    protected List<CompleteBehaviour> getChildren() {
        return this.children;
    }

    protected Description describeChild(CompleteBehaviour child) {
        return Description.createTestDescription((String)child.getSuiteName(), (String)child.getDescription(), (Annotation[])new Annotation[0]);
    }

    protected void runChild(CompleteBehaviour child, RunNotifier notifier) {
        try {
            Description childDescription = this.describeChild(child);
            notifier.fireTestStarted(childDescription);
            SpecificationReport report = child.playbackBehaviour();
            this.reportResults(notifier, report, childDescription);
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void reportResults(RunNotifier notifier, SpecificationReport spec, Description test) {
        switch (spec.getResult()) {
            case SUCCESS: {
                notifier.fireTestFinished(test);
                return;
            }
            case FAILURE: {
                notifier.fireTestFailure(new Failure(test, (Throwable)new TestFailure(spec.getMessage())));
                return;
            }
        }
        throw new SpecificationError(spec.getMessage(), spec.getCause());
    }
}

