/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl;

import com.insightfullogic.lambdabehave.Block;
import com.insightfullogic.lambdabehave.impl.CompleteBehaviour;
import com.insightfullogic.lambdabehave.impl.CompleteFixture;
import com.insightfullogic.lambdabehave.impl.reports.SpecificationReport;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class Blocks {
    private final String suiteName;
    private final List<Block> blocks;

    public Blocks(String suiteName) {
        this.suiteName = suiteName;
        this.blocks = new ArrayList<Block>();
    }

    public void add(Block block) {
        this.blocks.add(block);
    }

    public Optional<SpecificationReport> runAll(String description) {
        try {
            for (Block block : this.blocks) {
                block.run();
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(SpecificationReport.error(description, e));
        }
    }

    public Stream<CompleteBehaviour> completeFixtures(String description) {
        return this.blocks.stream().map(block -> new CompleteFixture(this.suiteName, description, (Block)block));
    }

    public int size() {
        return this.blocks.size();
    }
}

