/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl.reports;

import com.insightfullogic.lambdabehave.impl.reports.Result;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpecificationReport {
    private static final Logger log = LoggerFactory.getLogger(SpecificationReport.class);
    private final String description;
    private final Result result;
    private final String message;
    private final Throwable cause;

    public static SpecificationReport success(String description) {
        log.info(description + " has succeeded");
        return new SpecificationReport(description, Result.SUCCESS, null, null);
    }

    public static SpecificationReport failure(String description, AssertionError cause) {
        log.warn(description + " has failed");
        return new SpecificationReport(description, Result.FAILURE, ((Throwable)((Object)cause)).getMessage(), (Throwable)((Object)cause));
    }

    public static SpecificationReport error(String specification, Throwable cause) {
        log.warn(specification + " has finished in error");
        return new SpecificationReport(specification, Result.ERROR, cause.getMessage(), cause);
    }

    public SpecificationReport(String description, Result result, String message, Throwable cause) {
        Objects.requireNonNull(description);
        Objects.requireNonNull(result);
        this.description = description;
        this.result = result;
        this.message = message;
        this.cause = cause;
    }

    public String getDescription() {
        return this.description;
    }

    public Result getResult() {
        return this.result;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public boolean isSuccess() {
        return this.result == Result.SUCCESS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecificationReport that = (SpecificationReport)o;
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return this.result == that.result;
    }

    public int hashCode() {
        int result1 = this.description.hashCode();
        result1 = 31 * result1 + this.result.hashCode();
        result1 = 31 * result1 + (this.message != null ? this.message.hashCode() : 0);
        return result1;
    }

    public String toString() {
        return "SpecificationReport{description='" + this.description + '\'' + ", result=" + (Object)((Object)this.result) + ", message='" + this.message + '\'' + '}';
    }
}

