/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl.reports;

import com.insightfullogic.lambdabehave.impl.reports.SpecificationReport;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class SuiteReport {
    private final String name;
    private final List<SpecificationReport> specifications;

    public SuiteReport(String name) {
        Objects.requireNonNull(name);
        this.name = name;
        this.specifications = new ArrayList<SpecificationReport>();
    }

    public SuiteReport with(SpecificationReport specification) {
        this.specifications.add(specification);
        return this;
    }

    public Stream<SpecificationReport> specifications() {
        return this.specifications.stream();
    }

    public List<SpecificationReport> getSpecifications() {
        return this.specifications;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuiteReport that = (SuiteReport)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.specifications.equals(that.specifications);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.specifications.hashCode();
        return result;
    }

    public String toString() {
        return "SuiteReport{name='" + this.name + '\'' + ", specifications=" + this.specifications + '}';
    }
}

