/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl.specifications;

import com.insightfullogic.lambdabehave.impl.Specifier;
import com.insightfullogic.lambdabehave.impl.specifications.PairRow;
import com.insightfullogic.lambdabehave.specifications.TwoColumnDataSpecification;
import com.insightfullogic.lambdabehave.specifications.TwoColumns;
import java.util.ArrayList;
import java.util.List;

public final class PairRecorder<F, S>
implements TwoColumns<F, S> {
    private final List<PairRow<F, S>> values;
    private final Specifier specifier;

    public PairRecorder(F first, S second, Specifier specifier) {
        this.specifier = specifier;
        this.values = new ArrayList<PairRow<F, S>>();
        this.and((Object)first, (Object)second);
    }

    public PairRecorder(List<F> first, List<S> second, Specifier specifier) {
        this.specifier = specifier;
        int size = first.size();
        if (size != second.size()) {
            throw new IllegalArgumentException("Lengths not identical: " + size + ", " + second.size());
        }
        this.values = new ArrayList<PairRow<F, S>>(size);
        for (int i = 0; i < size; ++i) {
            this.and((Object)first.get(i), (Object)second.get(i));
        }
    }

    @Override
    public PairRecorder<F, S> and(F first, S second) {
        this.values.add(new PairRow<F, S>(first, second));
        return this;
    }

    @Override
    public TwoColumns<F, S> toShow(String descriptionFormat, TwoColumnDataSpecification<F, S> specification) {
        this.specifier.recordDataDrivenSpecification2(descriptionFormat, this.values);
        return this;
    }
}

