/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.utils;

import java.util.Locale;

public class DataUtils {
    public static int fromAscii(char h, char l) {
        try {
            return Integer.parseInt("" + h + l, 16);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String toAscii(byte b) {
        return DataUtils.toHexString(b);
    }

    public static String toAscii(byte[] bytes) {
        return DataUtils.toAscii(bytes, 0, bytes.length);
    }

    public static String toAscii(byte[] bytes, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        int tail = offset + length;
        for (int i = offset; i < tail; ++i) {
            sb.append(DataUtils.toHexString(bytes[i]));
        }
        return sb.toString().toUpperCase(Locale.ENGLISH);
    }

    public static String toHexString(byte b) {
        return ((b & 0xFF) < 16 ? "0" : "") + Integer.toString(b & 0xFF, 16).toUpperCase(Locale.ENGLISH);
    }

    public static byte[] toByteArray(boolean[] bits) {
        byte[] dst = new byte[(int)Math.ceil((double)bits.length / 8.0)];
        for (int i = 0; i < bits.length; ++i) {
            int n = i / 8;
            dst[n] = (byte)(dst[n] | (byte)((bits[i] ? 1 : 0) << i % 8));
        }
        return dst;
    }

    public static boolean[] toBitsArray(byte[] bytes, int bitCount) {
        boolean[] dst = new boolean[bitCount];
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = (bytes[i / 8] & 1 << i % 8) != 0;
        }
        return dst;
    }

    public static int[] BeToIntArray(byte[] bytes) {
        int[] dst = new int[bytes.length / 2];
        int i = 0;
        int j = 0;
        while (i < dst.length) {
            dst[i] = (bytes[j] & 0xFF) << 8 | bytes[j + 1] & 0xFF;
            ++i;
            j += 2;
        }
        return dst;
    }

    public static int[] LeToIntArray(byte[] bytes) {
        int[] dst = new int[bytes.length / 2];
        int i = 0;
        int j = 0;
        while (i < dst.length) {
            dst[i] = (bytes[j + 1] & 0xFF) << 8 | bytes[j] & 0xFF;
            ++i;
            j += 2;
        }
        return dst;
    }

    public static byte[] toByteArray(int[] i16) {
        byte[] dst = new byte[i16.length * 2];
        int i = 0;
        int j = 0;
        while (i < i16.length) {
            dst[j] = (byte)(i16[i] >> 8 & 0xFF);
            dst[j + 1] = (byte)(i16[i] & 0xFF);
            ++i;
            j += 2;
        }
        return dst;
    }

    public static byte[] toByteArray(short[] src) {
        byte[] dst = new byte[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = (byte)src[i];
        }
        return dst;
    }

    public static byte[] toByteArray(short i16) {
        return new byte[]{DataUtils.byteHigh(i16), DataUtils.byteLow(i16)};
    }

    public static int toShort(int h, int l) {
        return (h & 0xFF) << 8 | l & 0xFF;
    }

    public static byte[] toByteArray(int i32) {
        byte[] regs = new byte[]{(byte)(0xFF & i32 >> 8), (byte)(0xFF & i32), (byte)(0xFF & i32 >> 24), (byte)(0xFF & i32 >> 16)};
        return regs;
    }

    public static float toFloat(byte[] bytes) {
        return Float.intBitsToFloat((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF | (bytes[2] & 0xFF) << 24 | (bytes[3] & 0xFF) << 16);
    }

    public static byte[] toByteArray(float f32) {
        return DataUtils.toByteArray(Float.floatToIntBits(f32));
    }

    public static byte byteLow(int b) {
        return (byte)((short)b & 0xFF);
    }

    public static byte byteHigh(int b) {
        return (byte)((short)b >> 8 & 0xFF);
    }

    public static int wordLow(int b) {
        return b & 0xFFFF;
    }

    public static int wordHigh(int b) {
        return b >> 16 & 0xFFFF;
    }

    public static int dwordLow(long l) {
        return (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public static int dwordHigh(long l) {
        return (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    public static int wordFromBytes(int l, int h) {
        return l & 0xFF & (h & 0xFF) << 8;
    }

    public static int dwordFromWords(int l, int h) {
        return l & 0xFFFF & (h & 0xFFFF) << 16;
    }

    public static long Int64FromDwords(int l, int h) {
        return (long)l & 0xFFFFFFFFFFFFFFFFL & ((long)h & 0xFFFFFFFFFFFFFFFFL) << 32;
    }
}

