/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.pdfcleanup;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.awt.geom.Point;
import com.itextpdf.awt.geom.Point2D;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.LineSegment;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.RenderFilter;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.pdf.parser.Vector;

public class PdfCleanUpRegionFilter
extends RenderFilter {
    private Rectangle rectangle;

    public PdfCleanUpRegionFilter(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public boolean allowText(TextRenderInfo renderInfo) {
        LineSegment ascent = renderInfo.getAscentLine();
        LineSegment descent = renderInfo.getDescentLine();
        Vector startPoint = new Vector((ascent.getStartPoint().get(0) + descent.getStartPoint().get(0)) / 2.0f, (ascent.getStartPoint().get(1) + descent.getStartPoint().get(1)) / 2.0f, 0.0f);
        Vector endPoint = new Vector((ascent.getEndPoint().get(0) + descent.getEndPoint().get(0)) / 2.0f, (ascent.getEndPoint().get(1) + descent.getEndPoint().get(1)) / 2.0f, 0.0f);
        float x1 = startPoint.get(0);
        float y1 = startPoint.get(1);
        float x2 = endPoint.get(0);
        float y2 = endPoint.get(1);
        Rectangle r1 = new Rectangle(Math.min(x1, x2), Math.min(y1, y2), Math.max(x1, x2), Math.max(y1, y2));
        Rectangle r2 = this.rectangle;
        return this.b(r1, r2);
    }

    public boolean allowImage(ImageRenderInfo renderInfo) {
        Matrix ctm = renderInfo.getImageCTM();
        if (ctm == null) {
            return false;
        }
        AffineTransform t = new AffineTransform(ctm.get(0), ctm.get(1), ctm.get(3), ctm.get(4), ctm.get(6), ctm.get(7));
        Point2D p1 = t.transform((Point2D)new Point(0, 0), null);
        Point2D p2 = t.transform((Point2D)new Point(0, 1), null);
        Point2D p3 = t.transform((Point2D)new Point(1, 0), null);
        Point2D p4 = t.transform((Point2D)new Point(1, 1), null);
        double[] xs = new double[]{p1.getX(), p2.getX(), p3.getX(), p4.getX()};
        double[] ys = new double[]{p1.getY(), p2.getY(), p3.getY(), p4.getY()};
        double left = this.min(xs);
        double bottom = this.min(ys);
        double right = this.max(xs);
        double top = this.max(ys);
        Rectangle r1 = new Rectangle((float)left, (float)bottom, (float)right, (float)top);
        Rectangle r2 = this.rectangle;
        return this.b(r1, r2);
    }

    public boolean allowObject(Object renderInfo) {
        if (renderInfo instanceof TextRenderInfo) {
            return this.allowText((TextRenderInfo)renderInfo);
        }
        if (renderInfo instanceof ImageRenderInfo) {
            return this.allowImage((ImageRenderInfo)renderInfo);
        }
        return false;
    }

    private boolean b(Rectangle r1, Rectangle r2) {
        return r1.getLeft() >= r2.getLeft() && r1.getBottom() >= r2.getBottom() && r1.getRight() <= r2.getRight() && r1.getTop() <= r2.getTop();
    }

    private double min(double[] numbers) {
        double min = 3.4028234663852886E38;
        for (double num : numbers) {
            if (!(num < min)) continue;
            min = num;
        }
        return min;
    }

    private double max(double[] numbers) {
        double max = -3.4028234663852886E38;
        for (double num : numbers) {
            if (!(num > max)) continue;
            max = num;
        }
        return max;
    }
}

