/*
 * Decompiled with CFR 0.152.
 */
package butterknife.compiler;

import butterknife.compiler.ButterKnifeProcessor;
import butterknife.compiler.FieldViewBinding;
import butterknife.compiler.Id;
import butterknife.compiler.MemberViewBinding;
import butterknife.compiler.MethodViewBinding;
import butterknife.internal.ListenerClass;
import butterknife.internal.ListenerMethod;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ViewBinding {
    private final Id id;
    private final Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> methodBindings;
    private final FieldViewBinding fieldBinding;

    ViewBinding(Id id, Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> methodBindings, FieldViewBinding fieldBinding) {
        this.id = id;
        this.methodBindings = methodBindings;
        this.fieldBinding = fieldBinding;
    }

    public Id getId() {
        return this.id;
    }

    public FieldViewBinding getFieldBinding() {
        return this.fieldBinding;
    }

    public Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> getMethodBindings() {
        return this.methodBindings;
    }

    public List<MemberViewBinding> getRequiredBindings() {
        ArrayList<MemberViewBinding> requiredBindings = new ArrayList<MemberViewBinding>();
        if (this.fieldBinding != null && this.fieldBinding.isRequired()) {
            requiredBindings.add(this.fieldBinding);
        }
        for (Map<ListenerMethod, Set<MethodViewBinding>> methodBinding : this.methodBindings.values()) {
            for (Set<MethodViewBinding> set : methodBinding.values()) {
                for (MethodViewBinding binding : set) {
                    if (!binding.isRequired()) continue;
                    requiredBindings.add(binding);
                }
            }
        }
        return requiredBindings;
    }

    public boolean isSingleFieldBinding() {
        return this.methodBindings.isEmpty() && this.fieldBinding != null;
    }

    public boolean requiresLocal() {
        if (this.isBoundToRoot()) {
            return false;
        }
        return !this.isSingleFieldBinding();
    }

    public boolean isBoundToRoot() {
        return ButterKnifeProcessor.NO_ID.equals(this.id);
    }

    public static final class Builder {
        private final Id id;
        private final Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> methodBindings = new LinkedHashMap<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>>();
        FieldViewBinding fieldBinding;

        public Builder(Id id) {
            this.id = id;
        }

        public boolean hasMethodBinding(ListenerClass listener, ListenerMethod method) {
            Map<ListenerMethod, Set<MethodViewBinding>> methods = this.methodBindings.get(listener);
            return methods != null && methods.containsKey(method);
        }

        public void addMethodBinding(ListenerClass listener, ListenerMethod method, MethodViewBinding binding) {
            Map<ListenerMethod, Set<MethodViewBinding>> methods = this.methodBindings.get(listener);
            Set<MethodViewBinding> set = null;
            if (methods == null) {
                methods = new LinkedHashMap<ListenerMethod, Set<MethodViewBinding>>();
                this.methodBindings.put(listener, methods);
            } else {
                set = methods.get(method);
            }
            if (set == null) {
                set = new LinkedHashSet<MethodViewBinding>();
                methods.put(method, set);
            }
            set.add(binding);
        }

        public void setFieldBinding(FieldViewBinding fieldBinding) {
            if (this.fieldBinding != null) {
                throw new AssertionError();
            }
            this.fieldBinding = fieldBinding;
        }

        public ViewBinding build() {
            return new ViewBinding(this.id, this.methodBindings, this.fieldBinding);
        }
    }
}

