/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.eval.util;

import com.johnsnowlabs.nlp.eval.util.LoggingData;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichDouble$;

public final class TagsMetrics$ {
    public static final TagsMetrics$ MODULE$;

    static {
        new TagsMetrics$();
    }

    public void computeAccuracy(MulticlassMetrics metrics, LoggingData loggingData) {
        double accuracy = (double)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(metrics.accuracy() * (double)1000)) / (double)1000;
        double weightedPrecision = (double)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(metrics.weightedPrecision() * (double)1000)) / (double)1000;
        double weightedRecall = (double)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(metrics.weightedRecall() * (double)1000)) / (double)1000;
        double weightedFMeasure = (double)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(metrics.weightedFMeasure() * (double)1000)) / (double)1000;
        double weightedFalsePositiveRate = (double)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(metrics.weightedFalsePositiveRate() * (double)1000)) / (double)1000;
        loggingData.logMetric("Accuracy", accuracy);
        loggingData.logMetric("Weighted Precision", weightedPrecision);
        loggingData.logMetric("Weighted Recall", weightedRecall);
        loggingData.logMetric("Weighted F1 Score", weightedFMeasure);
        loggingData.logMetric("Weighted False Positive Rate", weightedFalsePositiveRate);
    }

    public void computeAccuracyByEntity(MulticlassMetrics metrics, List<String> labels, LoggingData loggingData) {
        double[] predictedLabels = metrics.labels();
        Predef$.MODULE$.doubleArrayOps(predictedLabels).foreach((Function1)new Serializable(metrics, labels, loggingData){
            public static final long serialVersionUID = 0L;
            private final MulticlassMetrics metrics$1;
            private final List labels$1;
            private final LoggingData loggingData$1;

            public final void apply(double predictedLabel) {
                this.apply$mcVD$sp(predictedLabel);
            }

            public void apply$mcVD$sp(double predictedLabel) {
                String entity = (String)this.labels$1.apply((int)predictedLabel);
                double precision = (double)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.metrics$1.precision(predictedLabel) * (double)1000)) / (double)1000;
                double recall = (double)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.metrics$1.recall(predictedLabel) * (double)1000)) / (double)1000;
                double f1Score = (double)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.metrics$1.fMeasure(predictedLabel) * (double)1000)) / (double)1000;
                double falsePositiveRate = (double)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.metrics$1.falsePositiveRate(predictedLabel) * (double)1000)) / (double)1000;
                this.loggingData$1.logMetric(new StringBuilder().append((Object)entity).append((Object)" Precision").toString(), precision);
                this.loggingData$1.logMetric(new StringBuilder().append((Object)entity).append((Object)" Recall").toString(), recall);
                this.loggingData$1.logMetric(new StringBuilder().append((Object)entity).append((Object)" F1-Score").toString(), f1Score);
                this.loggingData$1.logMetric(new StringBuilder().append((Object)entity).append((Object)" FPR").toString(), falsePositiveRate);
            }
            {
                this.metrics$1 = metrics$1;
                this.labels$1 = labels$1;
                this.loggingData$1 = loggingData$1;
            }
        });
    }

    public void computeMicroAverage(MulticlassMetrics metrics, LoggingData loggingData) {
        DoubleRef totalP = DoubleRef.create((double)0.0);
        DoubleRef totalR = DoubleRef.create((double)0.0);
        IntRef totalClassNum = IntRef.create((int)0);
        double[] labels = metrics.labels();
        Predef$.MODULE$.doubleArrayOps(labels).foreach((Function1)new Serializable(metrics, totalP, totalR, totalClassNum){
            public static final long serialVersionUID = 0L;
            private final MulticlassMetrics metrics$2;
            private final DoubleRef totalP$1;
            private final DoubleRef totalR$1;
            private final IntRef totalClassNum$1;

            public final void apply(double label) {
                this.apply$mcVD$sp(label);
            }

            public void apply$mcVD$sp(double label) {
                ++this.totalClassNum$1.elem;
                this.totalP$1.elem += this.metrics$2.precision(label);
                this.totalR$1.elem += this.metrics$2.recall(label);
            }
            {
                this.metrics$2 = metrics$2;
                this.totalP$1 = totalP$1;
                this.totalR$1 = totalR$1;
                this.totalClassNum$1 = totalClassNum$1;
            }
        });
        totalP.elem /= (double)totalClassNum.elem;
        totalR.elem /= (double)totalClassNum.elem;
        double microAverage = (double)2 * (totalP.elem * totalR.elem / (totalP.elem + totalR.elem));
        loggingData.logMetric("Micro-average F1-Score", (double)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(microAverage * (double)1000)) / (double)1000);
    }

    private TagsMetrics$() {
        MODULE$ = this;
    }
}

