/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.google.common.collect.ImmutableSet;
import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.CallableStatementHandle;
import com.jolbox.bonecp.ConnectionPartition;
import com.jolbox.bonecp.IStatementCache;
import com.jolbox.bonecp.MemorizeTransactionProxy;
import com.jolbox.bonecp.PreparedStatementHandle;
import com.jolbox.bonecp.ReplayLog;
import com.jolbox.bonecp.StatementCache;
import com.jolbox.bonecp.StatementHandle;
import com.jolbox.bonecp.Statistics;
import com.jolbox.bonecp.hooks.AcquireFailConfig;
import com.jolbox.bonecp.hooks.ConnectionHook;
import com.jolbox.bonecp.hooks.ConnectionState;
import com.jolbox.bonecp.proxy.TransactionRecoveryResult;
import java.lang.ref.Reference;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHandle
implements Connection {
    private static final String STATEMENT_NOT_CLOSED = "Stack trace of location where statement was opened follows:\n%s";
    private static final String LOG_ERROR_MESSAGE = "Connection closed twice exception detected.\n%s\n%s\n";
    private static final String CLOSED_TWICE_EXCEPTION_MESSAGE = "Connection closed from thread [%s] was closed again.\nStack trace of location where connection was first closed follows:\n";
    private Connection connection = null;
    private long connectionLastUsedInMs = System.currentTimeMillis();
    private long connectionLastResetInMs = System.currentTimeMillis();
    private long connectionCreationTimeInMs = System.currentTimeMillis();
    private BoneCP pool;
    protected boolean possiblyBroken;
    protected boolean logicallyClosed = false;
    private ConnectionPartition originatingPartition = null;
    private IStatementCache preparedStatementCache = null;
    private IStatementCache callableStatementCache = null;
    private static Logger logger = LoggerFactory.getLogger(ConnectionHandle.class);
    private Object debugHandle;
    private ConnectionHook connectionHook;
    private boolean doubleCloseCheck;
    private volatile String doubleCloseException = null;
    private boolean logStatementsEnabled;
    protected boolean statementCachingEnabled;
    private List<ReplayLog> replayLog;
    private boolean inReplayMode;
    protected TransactionRecoveryResult recoveryResult = new TransactionRecoveryResult();
    protected String url;
    protected Thread threadUsingConnection;
    private long maxConnectionAgeInMs;
    private boolean statisticsEnabled;
    private Statistics statistics;
    private volatile Thread threadWatch;
    private Map<Connection, Reference<ConnectionHandle>> finalizableRefs;
    private boolean connectionTrackingDisabled;
    private static final ImmutableSet<String> sqlStateDBFailureCodes = ImmutableSet.of((Object)"08001", (Object)"08007", (Object)"08S01", (Object)"57P01");

    public ConnectionHandle(String url, String username, String password, BoneCP pool) throws SQLException {
        this.pool = pool;
        this.url = url;
        this.connection = this.obtainInternalConnection();
        this.finalizableRefs = this.pool.getFinalizableRefs();
        this.connectionTrackingDisabled = pool.getConfig().isDisableConnectionTracking();
        this.statisticsEnabled = pool.getConfig().isStatisticsEnabled();
        this.statistics = pool.getStatistics();
        if (this.pool.getConfig().isTransactionRecoveryEnabled()) {
            this.replayLog = new ArrayList<ReplayLog>(30);
            this.connection = MemorizeTransactionProxy.memorize(this.connection, this);
        }
        this.maxConnectionAgeInMs = pool.getConfig().getMaxConnectionAge(TimeUnit.MILLISECONDS);
        this.doubleCloseCheck = pool.getConfig().isCloseConnectionWatch();
        this.logStatementsEnabled = pool.getConfig().isLogStatementsEnabled();
        int cacheSize = pool.getConfig().getStatementsCacheSize();
        if (cacheSize > 0) {
            this.preparedStatementCache = new StatementCache(cacheSize, pool.getConfig().isStatisticsEnabled(), pool.getStatistics());
            this.callableStatementCache = new StatementCache(cacheSize, pool.getConfig().isStatisticsEnabled(), pool.getStatistics());
            this.statementCachingEnabled = true;
        }
    }

    protected Connection obtainInternalConnection() throws SQLException {
        boolean tryAgain = false;
        Connection result = null;
        int acquireRetryAttempts = this.pool.getConfig().getAcquireRetryAttempts();
        long acquireRetryDelayInMs = this.pool.getConfig().getAcquireRetryDelayInMs();
        AcquireFailConfig acquireConfig = new AcquireFailConfig();
        acquireConfig.setAcquireRetryAttempts(new AtomicInteger(acquireRetryAttempts));
        acquireConfig.setAcquireRetryDelayInMs(acquireRetryDelayInMs);
        acquireConfig.setLogMessage("Failed to acquire connection");
        this.connectionHook = this.pool.getConfig().getConnectionHook();
        do {
            try {
                this.connection = this.pool.obtainRawInternalConnection();
                tryAgain = false;
                if (acquireRetryAttempts != this.pool.getConfig().getAcquireRetryAttempts()) {
                    logger.info("Successfully re-established connection to DB");
                }
                if (this.connectionHook != null) {
                    this.connectionHook.onAcquire(this);
                }
                this.sendInitSQL();
                result = this.connection;
            }
            catch (SQLException e) {
                if (this.connectionHook != null) {
                    tryAgain = this.connectionHook.onAcquireFail(e, acquireConfig);
                } else {
                    logger.error("Failed to acquire connection. Sleeping for " + acquireRetryDelayInMs + "ms. Attempts left: " + acquireRetryAttempts, (Throwable)e);
                    try {
                        Thread.sleep(acquireRetryDelayInMs);
                        if (acquireRetryAttempts > -1) {
                            tryAgain = acquireRetryAttempts-- != 0;
                        }
                    }
                    catch (InterruptedException e1) {
                        tryAgain = false;
                    }
                }
                if (tryAgain) continue;
                throw this.markPossiblyBroken(e);
            }
        } while (tryAgain);
        return result;
    }

    public ConnectionHandle(Connection connection, IStatementCache preparedStatementCache, IStatementCache callableStatementCache, BoneCP pool) {
        this.connection = connection;
        this.preparedStatementCache = preparedStatementCache;
        this.callableStatementCache = callableStatementCache;
        this.pool = pool;
        this.url = null;
        int cacheSize = pool.getConfig().getStatementsCacheSize();
        if (cacheSize > 0) {
            this.statementCachingEnabled = true;
        }
    }

    public void sendInitSQL() throws SQLException {
        String initSQL = this.pool.getConfig().getInitSQL();
        if (initSQL != null) {
            Statement stmt = this.connection.createStatement();
            stmt.execute(initSQL);
            stmt.close();
        }
    }

    protected SQLException markPossiblyBroken(SQLException e) {
        ConnectionState connectionState;
        String state = e.getSQLState();
        ConnectionState connectionState2 = connectionState = this.getConnectionHook() != null ? this.getConnectionHook().onMarkPossiblyBroken(this, state, e) : ConnectionState.NOP;
        if (state == null) {
            state = "08999";
        }
        if ((sqlStateDBFailureCodes.contains((Object)state) || connectionState.equals((Object)ConnectionState.TERMINATE_ALL_CONNECTIONS)) && this.pool != null) {
            logger.error("Database access problem. Killing off all remaining connections in the connection pool. SQL State = " + state);
            this.pool.terminateAllConnections();
        }
        char firstChar = state.charAt(0);
        if (connectionState.equals((Object)ConnectionState.CONNECTION_POSSIBLY_BROKEN) || state.equals("40001") || state.equals("HY000") || state.startsWith("08") || firstChar >= '5' && firstChar <= '9') {
            this.possiblyBroken = true;
        }
        if (this.possiblyBroken && this.getConnectionHook() != null) {
            this.possiblyBroken = this.getConnectionHook().onConnectionException(this, state, e);
        }
        return e;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        try {
            this.connection.clearWarnings();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.logicallyClosed) {
            throw new SQLException("Connection is closed!");
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            if (!this.logicallyClosed) {
                this.logicallyClosed = true;
                this.threadUsingConnection = null;
                if (this.threadWatch != null) {
                    this.threadWatch.interrupt();
                    this.threadWatch = null;
                }
                this.pool.releaseConnection(this);
                if (this.doubleCloseCheck) {
                    this.doubleCloseException = this.pool.captureStackTrace(CLOSED_TWICE_EXCEPTION_MESSAGE);
                }
            } else if (this.doubleCloseCheck && this.doubleCloseException != null) {
                String currentLocation = this.pool.captureStackTrace("Last closed trace from thread [" + Thread.currentThread().getName() + "]:\n");
                logger.error(String.format(LOG_ERROR_MESSAGE, this.doubleCloseException, currentLocation));
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    protected void internalClose() throws SQLException {
        try {
            this.clearStatementCaches(true);
            if (this.connection != null) {
                this.connection.close();
                if (!this.connectionTrackingDisabled && this.finalizableRefs != null) {
                    this.finalizableRefs.remove(this.connection);
                }
            }
            this.logicallyClosed = true;
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Properties result = null;
        this.checkClosed();
        try {
            result = this.connection.getClientInfo();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        String result = null;
        this.checkClosed();
        try {
            result = this.connection.getClientInfo(name);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean result = false;
        this.checkClosed();
        try {
            result = this.connection.isValid(timeout);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.connection.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.connection.unwrap(iface);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connection.setClientInfo(name, value);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        Struct result = null;
        this.checkClosed();
        try {
            result = this.connection.createStruct(typeName, attributes);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        Array result = null;
        this.checkClosed();
        try {
            result = this.connection.createArrayOf(typeName, elements);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Blob createBlob() throws SQLException {
        Blob result = null;
        this.checkClosed();
        try {
            result = this.connection.createBlob();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Clob createClob() throws SQLException {
        Clob result = null;
        this.checkClosed();
        try {
            result = this.connection.createClob();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public NClob createNClob() throws SQLException {
        NClob result = null;
        this.checkClosed();
        try {
            result = this.connection.createNClob();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        SQLXML result = null;
        this.checkClosed();
        try {
            result = this.connection.createSQLXML();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Statement createStatement() throws SQLException {
        StatementHandle result = null;
        this.checkClosed();
        try {
            result = new StatementHandle(this.connection.createStatement(), this, this.logStatementsEnabled);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        StatementHandle result = null;
        this.checkClosed();
        try {
            result = new StatementHandle(this.connection.createStatement(resultSetType, resultSetConcurrency), this, this.logStatementsEnabled);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        StatementHandle result = null;
        this.checkClosed();
        try {
            result = new StatementHandle(this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this, this.logStatementsEnabled);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        boolean result = false;
        this.checkClosed();
        try {
            result = this.connection.getAutoCommit();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public String getCatalog() throws SQLException {
        String result = null;
        this.checkClosed();
        try {
            result = this.connection.getCatalog();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public int getHoldability() throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            result = this.connection.getHoldability();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData result = null;
        this.checkClosed();
        try {
            result = this.connection.getMetaData();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            result = this.connection.getTransactionIsolation();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        Map<String, Class<?>> result = null;
        this.checkClosed();
        try {
            result = this.connection.getTypeMap();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning result = null;
        this.checkClosed();
        try {
            result = this.connection.getWarnings();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public boolean isClosed() {
        return this.logicallyClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        boolean result = false;
        this.checkClosed();
        try {
            result = this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        String result = null;
        this.checkClosed();
        try {
            result = this.connection.nativeSQL(sql);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = sql;
                result = this.callableStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new CallableStatementHandle(this.connection.prepareCall(sql), sql, this, cacheKey, this.callableStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (CallableStatement)((Object)result);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.callableStatementCache.calculateCacheKey(sql, resultSetType, resultSetConcurrency);
                result = this.callableStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new CallableStatementHandle(this.connection.prepareCall(sql, resultSetType, resultSetConcurrency), sql, this, cacheKey, this.callableStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (CallableStatement)((Object)result);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.callableStatementCache.calculateCacheKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
                result = this.callableStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new CallableStatementHandle(this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, this, cacheKey, this.callableStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (CallableStatement)((Object)result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = sql;
                result = this.preparedStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new PreparedStatementHandle(this.connection.prepareStatement(sql), sql, this, cacheKey, this.preparedStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (PreparedStatement)((Object)result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.preparedStatementCache.calculateCacheKey(sql, autoGeneratedKeys);
                result = this.preparedStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new PreparedStatementHandle(this.connection.prepareStatement(sql, autoGeneratedKeys), sql, this, cacheKey, this.preparedStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (PreparedStatement)((Object)result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.preparedStatementCache.calculateCacheKey(sql, columnIndexes);
                result = this.preparedStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new PreparedStatementHandle(this.connection.prepareStatement(sql, columnIndexes), sql, this, cacheKey, this.preparedStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (PreparedStatement)((Object)result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.preparedStatementCache.calculateCacheKey(sql, columnNames);
                result = this.preparedStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new PreparedStatementHandle(this.connection.prepareStatement(sql, columnNames), sql, this, cacheKey, this.preparedStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (PreparedStatement)((Object)result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.preparedStatementCache.calculateCacheKey(sql, resultSetType, resultSetConcurrency);
                result = this.preparedStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new PreparedStatementHandle(this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency), sql, this, cacheKey, this.preparedStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (PreparedStatement)((Object)result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.preparedStatementCache.calculateCacheKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
                result = this.preparedStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new PreparedStatementHandle(this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, this, cacheKey, this.preparedStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (PreparedStatement)((Object)result);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        try {
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        try {
            this.connection.rollback(savepoint);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        try {
            this.connection.setCatalog(catalog);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        try {
            this.connection.setHoldability(holdability);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        try {
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        Savepoint result = null;
        try {
            result = this.connection.setSavepoint();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        Savepoint result = null;
        try {
            result = this.connection.setSavepoint(name);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        try {
            this.connection.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        try {
            this.connection.setTypeMap(map);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    public long getConnectionLastUsedInMs() {
        return this.connectionLastUsedInMs;
    }

    @Deprecated
    public long getConnectionLastUsed() {
        return this.getConnectionLastUsedInMs();
    }

    protected void setConnectionLastUsedInMs(long connectionLastUsed) {
        this.connectionLastUsedInMs = connectionLastUsed;
    }

    public long getConnectionLastResetInMs() {
        return this.connectionLastResetInMs;
    }

    @Deprecated
    public long getConnectionLastReset() {
        return this.getConnectionLastResetInMs();
    }

    protected void setConnectionLastResetInMs(long connectionLastReset) {
        this.connectionLastResetInMs = connectionLastReset;
    }

    public boolean isPossiblyBroken() {
        return this.possiblyBroken;
    }

    public ConnectionPartition getOriginatingPartition() {
        return this.originatingPartition;
    }

    protected void setOriginatingPartition(ConnectionPartition originatingPartition) {
        this.originatingPartition = originatingPartition;
    }

    protected void renewConnection() {
        this.logicallyClosed = false;
        this.threadUsingConnection = Thread.currentThread();
        if (this.doubleCloseCheck) {
            this.doubleCloseException = null;
        }
    }

    protected void clearStatementCaches(boolean internalClose) {
        if (this.statementCachingEnabled) {
            if (internalClose) {
                this.callableStatementCache.clear();
                this.preparedStatementCache.clear();
            } else if (this.pool.closeConnectionWatch) {
                this.callableStatementCache.checkForProperClosure();
                this.preparedStatementCache.checkForProperClosure();
            }
        }
    }

    public Object getDebugHandle() {
        return this.debugHandle;
    }

    public void setDebugHandle(Object debugHandle) {
        this.debugHandle = debugHandle;
    }

    @Deprecated
    public Connection getRawConnection() {
        return this.getInternalConnection();
    }

    public Connection getInternalConnection() {
        return this.connection;
    }

    public ConnectionHook getConnectionHook() {
        return this.connectionHook;
    }

    public boolean isLogStatementsEnabled() {
        return this.logStatementsEnabled;
    }

    public void setLogStatementsEnabled(boolean logStatementsEnabled) {
        this.logStatementsEnabled = logStatementsEnabled;
    }

    protected boolean isInReplayMode() {
        return this.inReplayMode;
    }

    protected void setInReplayMode(boolean inReplayMode) {
        this.inReplayMode = inReplayMode;
    }

    public boolean isConnectionAlive() {
        return this.pool.isConnectionHandleAlive(this);
    }

    public void setInternalConnection(Connection rawConnection) {
        this.connection = rawConnection;
    }

    public BoneCP getPool() {
        return this.pool;
    }

    public List<ReplayLog> getReplayLog() {
        return this.replayLog;
    }

    protected void setReplayLog(List<ReplayLog> replayLog) {
        this.replayLog = replayLog;
    }

    public Object getProxyTarget() {
        try {
            return Proxy.getInvocationHandler(this.connection).invoke(null, this.getClass().getMethod("getProxyTarget", new Class[0]), null);
        }
        catch (Throwable t) {
            throw new RuntimeException("BoneCP: Internal error - transaction replay log is not turned on?", t);
        }
    }

    public Thread getThreadUsingConnection() {
        return this.threadUsingConnection;
    }

    @Deprecated
    public long getConnectionCreationTime() {
        return this.getConnectionCreationTimeInMs();
    }

    public long getConnectionCreationTimeInMs() {
        return this.connectionCreationTimeInMs;
    }

    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    protected boolean isExpired(long currentTime) {
        return this.maxConnectionAgeInMs > 0L && currentTime - this.connectionCreationTimeInMs > this.maxConnectionAgeInMs;
    }

    protected void setThreadWatch(Thread threadWatch) {
        this.threadWatch = threadWatch;
    }

    public Thread getThreadWatch() {
        return this.threadWatch;
    }
}

