package com.jpattern.orm;

import java.io.File;
import java.math.BigDecimal;

import javax.annotation.Resource;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;

import com.jpattern.orm.test.IJpOrmTestsConstants;
import com.jpattern.orm.test.SpringSkipTestRunner;
import com.jpattern.shared.util.Chronometer;

/**
 * 
 * @author Francesco Cina
 * 
 *         20/mag/2011
 */
@RunWith(SpringSkipTestRunner.class)
@ContextConfiguration(locations = { "classpath:"
		+ IJpOrmTestsConstants.SPRING_XML_FILE })
public abstract class BaseTestShared {

	@Rule
	public final TestName name = new TestName();
	private final Chronometer chronometer = new Chronometer();
	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	@Resource
	private JPOrmTestData jpOrmTestData;

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUpBeforeTest() throws Exception {

		if (!this.jpOrmTestData.isDbAvailable()) {
			Assume.assumeTrue(true);
		}

		this.chronometer.restart();

		this.logger.info("===================================================================");
		this.logger.info("BEGIN TEST " + this.name.getMethodName());
		this.logger.info("===================================================================");

		setUp();

	}

	@After
	public void tearDownAfterTest() throws Exception {
		tearDown();

		this.chronometer.pause();
		final String time = new BigDecimal(this.chronometer.read()).divide(
				new BigDecimal(1000)).toString();

		this.logger.info("===================================================================");
		this.logger.info("END TEST " + this.name.getMethodName());
		this.logger.info("Execution time: " + time + " seconds");
		this.logger.info("===================================================================");

	}

	protected abstract void setUp() throws Exception;

	protected abstract void tearDown() throws Exception;

	protected String getTestInputBasePath() throws Exception {
		return IJpOrmTestsConstants.TEST_FILE_INPUT_BASE_PATH;
	}

	protected String getTestOutputBasePath() throws Exception {
		mkDir(IJpOrmTestsConstants.TEST_FILE_OUTPUT_BASE_PATH);
		return IJpOrmTestsConstants.TEST_FILE_OUTPUT_BASE_PATH;
	}

	protected void mkDir(final String dirPath) throws Exception {
		final File path = new File(dirPath);
		if (!path.exists()) {
			path.mkdirs();
		}
	}

	protected JPOrm getJPOrm() {
		return new JPOrm(this.jpOrmTestData.getSessionProvider());
	}

}
