package com.jpattern.orm.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.util.Random;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Employee;
import com.jpattern.orm.transaction.Transaction;

/**
 * 
 * @author Francesco Cina
 *
 * 20/mag/2011
 */
public class EmployeeTest extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testCrudEmployee() throws Exception {
		final JPO jpOrm =getJPOrm();

		jpOrm.register(Employee.class);

		final int id = new Random().nextInt();
		final Employee employee = new Employee();
		employee.setId( id );
		employee.setAge( 44 );
		employee.setEmployeeNumber( "empNumber" + id );
		employee.setName("Wizard");
		employee.setSurname("Cina");

		// CREATE
		final Session conn = jpOrm.session();
		Transaction tx = conn.transaction();
		conn.save(employee);
		tx.commit();

		// LOAD
		tx = conn.transaction();
		final Employee employeeLoad1 = conn.find(Employee.class, new Object[]{id});
		assertNotNull(employeeLoad1);
		assertEquals( employee.getId(), employeeLoad1.getId() );
		assertEquals( employee.getName(), employeeLoad1.getName() );
		assertEquals( employee.getSurname(), employeeLoad1.getSurname() );
		assertEquals( employee.getEmployeeNumber(), employeeLoad1.getEmployeeNumber() );

		//UPDATE
		employeeLoad1.setName("Wizard");
		conn.update(employeeLoad1);
		tx.commit();

		// LOAD
		tx = conn.transaction();
		final Employee employeeLoad2 = conn.find(Employee.class, new Object[]{id});
		assertNotNull(employeeLoad2);
		assertEquals( employeeLoad1.getId(), employeeLoad2.getId() );
		assertEquals( employeeLoad1.getName(), employeeLoad2.getName() );
		assertEquals( employeeLoad1.getSurname(), employeeLoad2.getSurname() );
		assertEquals( employeeLoad1.getEmployeeNumber(), employeeLoad2.getEmployeeNumber() );

		//DELETE
		conn.delete(employeeLoad2);
		final Employee employeeLoad3 = conn.find(Employee.class, new Object[]{id});
		assertNull(employeeLoad3);
		tx.commit();

	}

}
