package com.jpattern.orm.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.query.find.FindQuery;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.People;
import com.jpattern.orm.transaction.Transaction;

/**
 * 
 * @author Francesco Cina
 *
 * 20/mag/2011
 */
public class PeopleMultipleTest extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testCrudPeopleMultiple() throws Exception {
		final JPO jpOrm =getJPOrm();

		jpOrm.register(People.class);

		List<People> peoples = new ArrayList<People>();
		peoples.add(createPeople("1"));
		peoples.add(createPeople("2"));
		peoples.add(createPeople("3"));
		peoples.add(createPeople("4"));

		// CREATE
		final Session conn = jpOrm.session();
		Transaction tx = conn.transaction();
		peoples = conn.save(peoples);
		tx.commit();

		for (final People people : peoples) {
			System.out.println("People [" + people.getFirstname() + "]saved with id: " + people.getId());
		}

		// LOAD
		final FindQuery<People> peopleQuery1 = conn.findQuery(People.class);
		assertNotNull(peopleQuery1);
		final Collection<Long> values = new ArrayList<Long>();
		for ( final People people : peoples) {
			values.add( people.getId() );
		}
		peopleQuery1.where().in("People.id", values );
		final List<People> peopleLoad1 = peopleQuery1.findList();

		compare(peoples, peopleLoad1);

		//UPDATE
		tx = conn.transaction();
		for ( final People people : peoples) {
			people.setFirstname( people.getFirstname() + "-updated-" + new Date().getTime() ) ;
		}
		peoples = conn.update(peoples);
		tx.commit();

		// LOAD
		final FindQuery<People> peopleQuery2 = conn.findQuery(People.class);
		assertNotNull(peopleQuery2);
		peopleQuery2.where().in("People.id", values );
		final List<People> peopleLoad2 = peopleQuery2.findList();

		compare(peoples, peopleLoad2);


		//DELETE
		tx = conn.transaction();
		conn.delete(peopleLoad2);
		tx.commit();

		//LOAD
		final FindQuery<People> peopleQuery3 = conn.findQuery(People.class);
		assertNotNull(peopleQuery3);
		peopleQuery3.where().in("People.id", values );
		final List<People> peopleLoad3 = peopleQuery3.findList();
		assertTrue( peopleLoad3.isEmpty() );

	}

	private void compare(List<People> peoples, List<People> peoplesLoad) {
		assertEquals(peoples.size(), peoplesLoad.size());
		for ( final People people : peoples) {
			System.out.println("check people: " + people.getId());
			boolean found = false;
			for (final People peopleLoad : peoplesLoad) {
				if (peopleLoad.getId() == people.getId()) {
					found = true;
					assertEquals(people.getFirstname(), peopleLoad.getFirstname());
					assertEquals(people.getLastname(), peopleLoad.getLastname());
				}
			}
			assertTrue(found);
		}
	}

	private People createPeople(String name) {
		final long id = new Date().getTime();
		final People people = new People();
		people.setId( id );
		people.setFirstname( name );
		people.setLastname( "lastname of " + name );
		return people;
	}

}
