package com.jpattern.orm.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.People;
import com.jpattern.orm.transaction.Transaction;

/**
 * 
 * @author Francesco Cina
 *
 * 20/mag/2011
 */
public class PeopleTest extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testCrudPeople() throws Exception {
		final JPO jpOrm =getJPOrm();

		jpOrm.register(People.class);

		long id = new Date().getTime();
		People people = new People();
		people.setId( id );
		people.setFirstname( "people" );
		people.setLastname("Wizard");

		assertFalse( jpOrm.session().exist(people) );

		// CREATE
		final Session conn = jpOrm.session();
		Transaction tx = conn.transaction();
		people = conn.save(people);
		tx.commit();

		System.out.println("People saved with id: " + people.getId());
		assertFalse( id == people.getId() );
		id = people.getId();

		assertTrue( jpOrm.session().exist(people) );

		// LOAD
		tx = conn.transaction();
		People peopleLoad1 = conn.find(People.class, id);
		assertNotNull(peopleLoad1);
		assertEquals( people.getId(), peopleLoad1.getId() );
		assertEquals( people.getFirstname(), peopleLoad1.getFirstname() );
		assertEquals( people.getLastname(), peopleLoad1.getLastname() );

		//UPDATE
		peopleLoad1.setFirstname("Wizard name");
		peopleLoad1 = conn.update(peopleLoad1);
		tx.commit();

		// LOAD
		tx = conn.transaction();
		final People peopleLoad2 = conn.find(People.class, new Object[]{id});
		assertNotNull(peopleLoad2);
		assertEquals( peopleLoad1.getId(), peopleLoad2.getId() );
		assertEquals( peopleLoad1.getFirstname(), peopleLoad2.getFirstname() );
		assertEquals( peopleLoad1.getLastname(), peopleLoad2.getLastname() );

		//DELETE
		conn.delete(peopleLoad2);
		tx.commit();

		tx = conn.transaction();
		final People peopleLoad3 = conn.find(People.class, new Object[]{id});
		assertNull(peopleLoad3);
		tx.commit();

	}

}
