package com.jpattern.orm.test.crud;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.crud.CRUDQuery;
import com.jpattern.orm.crud.OrmCRUDQueryGenerator;
import com.jpattern.orm.dialect.DefaultDialect;
import com.jpattern.orm.mapper.clazz.ClassMapBuilder;
import com.jpattern.orm.mapper.clazz.IClassMap;
import com.jpattern.orm.session.SessionProvider;
import com.jpattern.orm.test.domain.Employee;
import com.jpattern.orm.test.domain.People;
import com.jpattern.orm.test.domain.Zoo_People;

/**
 * 
 * @author Francesco Cina
 *
 * 01/giu/2011
 */
public class OrmCRUDQueryGeneratorTest extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testOrmProvider() throws Exception {
		final SessionProvider connectionProvider = getJPOrm().getSessionProvider();
		ormCrudWithSequence(connectionProvider);
		ormCrud(connectionProvider);
		ormCrudWithSchema(connectionProvider);
		ormCrudSelectFromClause(connectionProvider);
	}

	public void ormCrudWithSequence(final SessionProvider sessionProvider) throws Exception {
		final IClassMap<People> classMapper = new ClassMapBuilder<People>(People.class).generate();
		assertNotNull(classMapper);

		final OrmCRUDQueryGenerator<People> ormGenerator = new OrmCRUDQueryGenerator<People>(new DefaultDialect(), classMapper);
		final CRUDQuery ormCrudQuery = ormGenerator.generate();
		assertNotNull(ormCrudQuery);

		System.out.println(ormCrudQuery.getLoadQuery());
		System.out.println(ormCrudQuery.getUpdateQuery());
		System.out.println(ormCrudQuery.getDeleteQuery());
		System.out.println(ormCrudQuery.getSaveQuery());
	}

	public void ormCrud(final SessionProvider sessionProvider) throws Exception {
		final IClassMap<Employee> classMapper = new ClassMapBuilder<Employee>(Employee.class).generate();

		assertNotNull(classMapper);

		final OrmCRUDQueryGenerator<Employee> ormGenerator = new OrmCRUDQueryGenerator<Employee>(new DefaultDialect(), classMapper);
		final CRUDQuery ormCrudQuery = ormGenerator.generate();
		assertNotNull(ormCrudQuery);

		System.out.println(ormCrudQuery.getLoadQuery());
		System.out.println(ormCrudQuery.getUpdateQuery());
		System.out.println(ormCrudQuery.getDeleteQuery());
		System.out.println(ormCrudQuery.getSaveQuery());
	}

	public void ormCrudWithSchema(final SessionProvider sessionProvider) throws Exception {
		final IClassMap<Zoo_People> classMapper = new ClassMapBuilder<Zoo_People>(Zoo_People.class).generate();

		assertNotNull(classMapper);

		final OrmCRUDQueryGenerator<Zoo_People> ormGenerator = new OrmCRUDQueryGenerator<Zoo_People>(new DefaultDialect(), classMapper);
		final CRUDQuery ormCrudQuery = ormGenerator.generate();
		assertNotNull(ormCrudQuery);

		System.out.println(ormCrudQuery.getLoadQuery());
		System.out.println(ormCrudQuery.getUpdateQuery());
		System.out.println(ormCrudQuery.getDeleteQuery());
		System.out.println(ormCrudQuery.getSaveQuery());
	}

	public void ormCrudSelectFromClause(final SessionProvider sessionProvider) throws Exception {
		final IClassMap<Zoo_People> classMapper = new ClassMapBuilder<Zoo_People>(Zoo_People.class).generate();
		assertNotNull(classMapper);

		final OrmCRUDQueryGenerator<Zoo_People> ormGenerator = new OrmCRUDQueryGenerator<Zoo_People>(new DefaultDialect(), classMapper);
		final CRUDQuery ormCrudQuery = ormGenerator.generate();
		assertNotNull(ormCrudQuery);

		System.out.println(ormCrudQuery.getBaseSelectClause());
		System.out.println(ormCrudQuery.getBaseSelectClause("alias."));
		System.out.println(ormCrudQuery.getBaseFromClause());

		assertEquals("ZOO.PEOPLE.FIRSTCLOB, ZOO.PEOPLE.ID, ZOO.PEOPLE.SECONDBLOB, ZOO.PEOPLE.BIRTHDATE, ZOO.PEOPLE.LASTNAME, ZOO.PEOPLE.FIRSTNAME, ZOO.PEOPLE.FIRSTBLOB, ZOO.PEOPLE.DEATHDATE", ormCrudQuery.getBaseSelectClause());
		assertEquals("alias.FIRSTCLOB, alias.ID, alias.SECONDBLOB, alias.BIRTHDATE, alias.LASTNAME, alias.FIRSTNAME, alias.FIRSTBLOB, alias.DEATHDATE", ormCrudQuery.getBaseSelectClause("alias."));
		assertEquals("ZOO.PEOPLE", ormCrudQuery.getBaseFromClause());

	}
}
