package com.jpattern.orm.test.domain;

import java.io.InputStream;
import java.io.Reader;

import com.jpattern.orm.annotation.Column;
import com.jpattern.orm.annotation.Generator;
import com.jpattern.orm.annotation.Id;
import com.jpattern.orm.annotation.Table;
import com.jpattern.orm.annotation.generator.GeneratorType;

/**
 * 
 * @author Francesco Cina
 *
 * 08/giu/2011
 */
@Table(tableName="BLOBCLOB")
public class Blobclob_Stream {

	@Column(name="BLOB")
	private InputStream blobInputStream;

	private Reader clob;

	@Id
	@Generator(generatorType = GeneratorType.SEQUENCE, name = "SEQ_BLOBCLOB")
	private long id;

	public long getId() {
		return id;
	}

	public InputStream getBlobInputStream() {
		return blobInputStream;
	}
	public void setBlobInputStream(InputStream blob) {
		blobInputStream = blob;
	}
	public Reader getClob() {
		return clob;
	}
	public void setClob(Reader clob) {
		this.clob = clob;
	}

}
