package com.jpattern.orm.test.domain;

import java.util.Date;

import org.joda.time.DateMidnight;
import org.joda.time.DateTime;

import com.jpattern.orm.annotation.Generator;
import com.jpattern.orm.annotation.Id;
import com.jpattern.orm.annotation.generator.GeneratorType;

/**
 * 
 * @author Francesco Cina
 *
 * 20/mag/2011
 */
public class WrapperTypeTable {

	@Id
	@Generator(generatorType = GeneratorType.AUTOGENERATED, name="", ifValueIn={-1})
	private Long id = -1l;
	private Date now;
	private DateTime startDate;
	private DateMidnight endDate;
	private Boolean valid;

	public Long getId() {
		return id;
	}

	/**
	 * @return the now
	 */
	public Date getNow() {
		return now;
	}

	/**
	 * @param now the now to set
	 */
	public void setNow(Date now) {
		this.now = now;
	}

	/**
	 * @return the startDate
	 */
	public DateTime getStartDate() {
		return startDate;
	}

	/**
	 * @param startDate the startDate to set
	 */
	public void setStartDate(DateTime startDate) {
		this.startDate = startDate;
	}

	/**
	 * @return the endDate
	 */
	public DateMidnight getEndDate() {
		return endDate;
	}

	/**
	 * @param endDate the endDate to set
	 */
	public void setEndDate(DateMidnight endDate) {
		this.endDate = endDate;
	}

	/**
	 * @return the valid
	 */
	public Boolean getValid() {
		return valid;
	}

	/**
	 * @param valid the valid to set
	 */
	public void setValid(Boolean valid) {
		this.valid = valid;
	}

}
