package com.jpattern.orm.test.exception;

import static org.junit.Assert.fail;

import java.util.Random;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.exception.sql.OrmSqlDataIntegrityViolationException;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Employee;
import com.jpattern.orm.transaction.Transaction;

/**
 * 
 * @author Francesco Cina
 *
 * 20/mag/2011
 */
public class ConstraintViolationExceptionTest extends BaseTestShared {

	private JPO jpOrm;

	@Override
	protected void setUp() throws Exception {
		jpOrm = this.getJPOrm();
		jpOrm.register(Employee.class);
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testConstraintViolationException() throws Exception {

		final int id = new Random().nextInt();
		final Employee employee = new Employee();
		employee.setId( id );
		employee.setAge( 44 );
		employee.setEmployeeNumber( ("empNumber_" + id) );
		employee.setName("Wizard");
		employee.setSurname("Cina");

		// CREATE
		final Session conn = this.jpOrm.session();
		Transaction tx = conn.transaction();
		try {
			conn.save(employee);
			conn.save(employee);
			tx.commit();
		} catch (OrmSqlDataIntegrityViolationException e) {
			System.out.println("Constraint violation intercepted. Message [" + e.getMessage() + "]");
		} catch (Exception e) {
			fail("A specific exception should be thrown, but is " + e);
		}
		finally {
			tx.rollback();
		}
	}

}
