package com.jpattern.orm.test.h2;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.util.Date;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Blobclob_ByteArray;
import com.jpattern.orm.transaction.Transaction;

/**
 * 
 * @author Francesco Cina
 *
 * 20/mag/2011
 */
public class BlobClob_ByteArray_Test extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testCrudBlobclob() throws Exception {
		final JPO jpOrm =getJPOrm();

		jpOrm.register(Blobclob_ByteArray.class);

		long id = new Date().getTime();

		final String text1 = "BINARY STRING TEST 1 " + id;

		final String text2 = "BINARY STRING TEST 2 " + id;

		Blobclob_ByteArray blobclob = new Blobclob_ByteArray();
		blobclob.setBlob(text1.getBytes());
		blobclob.setClob(text2.getBytes());

		// CREATE
		final Session conn = jpOrm.session();
		Transaction tx = conn.transaction();
		blobclob = conn.save(blobclob);
		tx.commit();

		System.out.println("Blobclob saved with id: " + blobclob.getIndex());
		assertFalse( id == blobclob.getIndex() );
		id = blobclob.getIndex();

		// LOAD
		tx = conn.transaction();
		final Blobclob_ByteArray blobclobLoad1 = conn.find(Blobclob_ByteArray.class, new Object[]{id});
		assertNotNull(blobclobLoad1);
		assertEquals( blobclob.getIndex(), blobclobLoad1.getIndex() );

		final String retrieved1 = new String(blobclobLoad1.getBlob());
		System.out.println("Retrieved1 String " + retrieved1);
		assertEquals( text1 , retrieved1 );

		final String retrieved2 = new String(blobclobLoad1.getClob());
		System.out.println("Retrieved2 String " + retrieved2);
		assertEquals( text2 , retrieved2 );

		//DELETE
		conn.delete(blobclobLoad1);
		final Blobclob_ByteArray blobclobLoad2 = conn.find(Blobclob_ByteArray.class, new Object[]{id});
		assertNull(blobclobLoad2);
		tx.commit();

	}

}
