package com.jpattern.orm.test.h2;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.io.InputStream;
import java.io.Reader;
import java.util.Date;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Blobclob_Stream;
import com.jpattern.orm.transaction.Transaction;
import com.jpattern.orm.util.OrmUtil;

/**
 * 
 * @author Francesco Cina
 *
 * 20/mag/2011
 */
public class BlobClob_InputStream_Reader_Test extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testCrudBlobclob() throws Exception {
		final JPO jpOrm =getJPOrm();

		jpOrm.register(Blobclob_Stream.class);

		long id = new Date().getTime();

		final String text1 = "BINARY STRING TEST 1 " + id;
		final InputStream is1 = OrmUtil.convertStringToStream(text1, OrmUtil.UTF8);

		final String text2 = "BINARY STRING TEST 2 " + id;
		final Reader reader2 = OrmUtil.convertStringToReader(text2);

		Blobclob_Stream blobclob = new Blobclob_Stream();
		blobclob.setBlobInputStream(is1);
		blobclob.setClob(reader2);

		// CREATE
		final Session conn = jpOrm.session();
		Transaction tx = conn.transaction();
		blobclob = conn.save(blobclob);
		tx.commit();

		reader2.close();
		is1.close();

		System.out.println("Blobclob saved with id: " + blobclob.getId());
		assertFalse( id == blobclob.getId() );
		id = blobclob.getId();

		// LOAD
		tx = conn.transaction();
		final Blobclob_Stream blobclobLoad1 = conn.find(Blobclob_Stream.class, new Object[]{id});
		assertNotNull(blobclobLoad1);
		assertEquals( blobclob.getId(), blobclobLoad1.getId() );

		final String retrieved1 = OrmUtil.convertStreamToString( blobclobLoad1.getBlobInputStream(), OrmUtil.UTF8, false);
		System.out.println("Retrieved1 String " + retrieved1);
		assertEquals( text1 , retrieved1 );

		final String retrieved2 = OrmUtil.convertReaderToString( blobclobLoad1.getClob(), false);
		System.out.println("Retrieved2 String " + retrieved2);
		assertEquals( text2 , retrieved2 );

		//DELETE
		conn.delete(blobclobLoad1);
		final Blobclob_Stream blobclobLoad2 = conn.find(Blobclob_Stream.class, new Object[]{id});
		assertNull(blobclobLoad2);
		tx.commit();

	}

}
