package com.jpattern.orm.test.h2;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.util.Date;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Blobclob_String;
import com.jpattern.orm.transaction.Transaction;

/**
 * 
 * @author Francesco Cina
 *
 * 20/mag/2011
 */
public class BlobClob_String_Test extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testCrudBlobclob() throws Exception {
		final JPO jpOrm =getJPOrm();

		jpOrm.register(Blobclob_String.class);

		long id = new Date().getTime();

		final String text1 = "BINARY STRING TEST 1 " + id;

		final String text2 = "BINARY STRING TEST 2 " + id;

		Blobclob_String blobclob = new Blobclob_String();
		blobclob.setBlob(text1.getBytes());
		blobclob.setClob(text2);

		// CREATE
		final Session conn = jpOrm.session();
		Transaction tx = conn.transaction();
		blobclob = conn.save(blobclob);
		tx.commit();

		System.out.println("Blobclob saved with id: " + blobclob.getId());
		assertFalse( id == blobclob.getId() );
		id = blobclob.getId();

		// LOAD
		tx = conn.transaction();
		final Blobclob_String blobclobLoad1 = conn.find(Blobclob_String.class, new Object[]{id});
		assertNotNull(blobclobLoad1);
		assertEquals( blobclob.getId(), blobclobLoad1.getId() );

		final String retrieved1 = new String(blobclobLoad1.getBlob());
		System.out.println("Retrieved1 String " + retrieved1);
		assertEquals( text1 , retrieved1 );

		final String retrieved2 = blobclobLoad1.getClob();
		System.out.println("Retrieved2 String " + retrieved2);
		assertEquals( text2 , retrieved2 );

		//DELETE
		conn.delete(blobclobLoad1);
		final Blobclob_String blobclobLoad2 = conn.find(Blobclob_String.class, new Object[]{id});
		assertNull(blobclobLoad2);
		tx.commit();

	}

}
