package com.jpattern.orm.test.h2;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.io.InputStream;
import java.io.Reader;
import java.util.Date;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.People;
import com.jpattern.orm.transaction.Transaction;
import com.jpattern.orm.util.OrmUtil;

/**
 * 
 * @author Francesco Cina
 *
 * 20/mag/2011
 */
public class People2Test extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testCrudPeople() throws Exception {
		final JPO jpOrm =getJPOrm();

		jpOrm.register(People.class);

		long id = new Date().getTime();

		final String text1 = "BINARY STRING TEST 1 " + id;
		final InputStream is = OrmUtil.convertStringToStream(text1, OrmUtil.UTF8);

		final String text2 = "BINARY STRING TEST 2 " + id;
		final Reader reader = OrmUtil.convertStringToReader(text2);

		People people = new People();
		people.setId( id );
		people.setFirstname( "people" );
		people.setLastname("Wizard");
		people.setFirstblob(is);
		people.setFirstclob(reader);

		// CREATE
		final Session conn = jpOrm.session();
		Transaction tx = conn.transaction();
		people = conn.save(people);
		tx.commit();

		reader.close();
		is.close();

		System.out.println("People saved with id: " + people.getId());
		assertFalse( id == people.getId() );
		id = people.getId();

		// LOAD
		tx = conn.transaction();
		People peopleLoad1 = conn.findQuery(People.class, "p").where().eq("id", id).eq("firstname", people.getFirstname()).findUnique();
		assertNotNull(peopleLoad1);
		assertEquals( people.getId(), peopleLoad1.getId() );
		assertEquals( people.getFirstname(), peopleLoad1.getFirstname() );
		assertEquals( people.getLastname(), peopleLoad1.getLastname() );

		final String retrieved1 = OrmUtil.convertStreamToString( peopleLoad1.getFirstblob(), OrmUtil.UTF8, false);
		System.out.println("Retrieved1 String " + retrieved1);
		assertEquals( text1 , retrieved1 );

		final String retrieved2 = OrmUtil.convertReaderToString( peopleLoad1.getFirstclob() , false);
		System.out.println("Retrieved2 String " + retrieved2);
		assertEquals( text2 , retrieved2 );


		//UPDATE
		peopleLoad1.setFirstname("Wizard name");
		peopleLoad1 = conn.update(peopleLoad1);
		tx.commit();

		// LOAD
		tx = conn.transaction();
		final People peopleLoad2 = conn.find(People.class, new Object[]{id});
		assertNotNull(peopleLoad2);
		assertEquals( peopleLoad1.getId(), peopleLoad2.getId() );
		assertEquals( peopleLoad1.getFirstname(), peopleLoad2.getFirstname() );
		assertEquals( peopleLoad1.getLastname(), peopleLoad2.getLastname() );

		//DELETE
		conn.delete(peopleLoad2);
		final People peopleLoad3 = conn.find(People.class, new Object[]{id});
		assertNull(peopleLoad3);
		tx.commit();

	}

}
