package com.jpattern.orm.test.h2;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.io.InputStream;
import java.io.Reader;
import java.util.Date;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Zoo_People;
import com.jpattern.orm.transaction.Transaction;
import com.jpattern.orm.util.OrmUtil;

/**
 * 
 * @author Francesco Cina
 *
 * 20/mag/2011
 */
public class ZooPeopleTest extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testCrudZoo() throws Exception {
		final JPO jpOrm =getJPOrm();

		jpOrm.register(Zoo_People.class);

		long id = new Date().getTime();

		final String text1 = "BINARY STRING TEST 1 " + id;
		final InputStream is = OrmUtil.convertStringToStream(text1, OrmUtil.UTF8);

		final String text2 = "BINARY STRING TEST 2 " + id;
		final Reader reader = OrmUtil.convertStringToReader(text2);

		Zoo_People zooPeople = new Zoo_People();
		zooPeople.setId( id );
		zooPeople.setFirstname( "Zoo_People" );
		zooPeople.setLastname("Wizard");
		zooPeople.setFirstblob(is);
		zooPeople.setFirstclob(reader);

		// CREATE
		final Session conn = jpOrm.session();
		Transaction tx = conn.transaction();
		zooPeople = conn.save(zooPeople);
		tx.commit();

		reader.close();
		is.close();

		System.out.println("Zoo_People saved with id: " + zooPeople.getId());
		assertFalse( id == zooPeople.getId() );
		id = zooPeople.getId();

		// LOAD
		tx = conn.transaction();
		Zoo_People peopleLoad1 = conn.find(Zoo_People.class, new Object[]{id});
		assertNotNull(peopleLoad1);
		assertEquals( zooPeople.getId(), peopleLoad1.getId() );
		assertEquals( zooPeople.getFirstname(), peopleLoad1.getFirstname() );
		assertEquals( zooPeople.getLastname(), peopleLoad1.getLastname() );

		final String retrieved1 = OrmUtil.convertStreamToString( peopleLoad1.getFirstblob(), OrmUtil.UTF8, false);
		System.out.println("Retrieved1 String " + retrieved1);
		assertEquals( text1 , retrieved1 );

		final String retrieved2 = OrmUtil.convertReaderToString( peopleLoad1.getFirstclob() , false);
		System.out.println("Retrieved2 String " + retrieved2);
		assertEquals( text2 , retrieved2 );


		//UPDATE
		peopleLoad1.setFirstname("Wizard name");
		peopleLoad1 = conn.update(peopleLoad1);
		tx.commit();

		// LOAD
		tx = conn.transaction();
		final Zoo_People peopleLoad2 = conn.find(Zoo_People.class, new Object[]{id});
		assertNotNull(peopleLoad2);
		assertEquals( peopleLoad1.getId(), peopleLoad2.getId() );
		assertEquals( peopleLoad1.getFirstname(), peopleLoad2.getFirstname() );
		assertEquals( peopleLoad1.getLastname(), peopleLoad2.getLastname() );

		//DELETE
		conn.delete(peopleLoad2);
		final Zoo_People peopleLoad3 = conn.find(Zoo_People.class, new Object[]{id});
		assertNull(peopleLoad3);
		tx.commit();

	}

}
