package com.jpattern.orm.test.mapper;

import static org.junit.Assert.*;
import java.util.Arrays;
import java.util.Date;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.mapper.clazz.ClassMapBuilder;
import com.jpattern.orm.mapper.clazz.IClassField;
import com.jpattern.orm.mapper.clazz.IClassMap;
import com.jpattern.orm.test.domain.BeanWithValuesGenerator;
import com.jpattern.orm.test.domain.Blobclob_ByteArray;
import com.jpattern.orm.test.domain.Blobclob_Stream;
import com.jpattern.orm.test.domain.Employee;

/**
 * 
 * @author Francesco Cina
 *
 * 01/giu/2011
 */
public class ClassMapperGeneratorTest extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}


	@Test
	public <P> void testClassMapperGenerator1() throws Exception {
		final IClassMap<Employee> classMapper = new ClassMapBuilder<Employee>(Employee.class).generate();
		assertNotNull(classMapper);

		assertEquals("" , classMapper.getTableInfo().getSchemaName());
		assertEquals("EMPLOYEE", classMapper.getTableInfo().getTableNameWithSchema());
		assertEquals(5 , classMapper.getAllColumnJavaNames().length );
		assertEquals(1 , classMapper.getPrimaryKeyColumnJavaNames().length );
		assertEquals(4 , classMapper.getNotPrimaryKeyColumnJavaNames().length );

		try {
			classMapper.getClassFieldByJavaName("" + new Date().getTime());
			fail("An exception should be thrwn here!");
		} catch (OrmException e) {
			//do nothing
		}

		for (final String col : classMapper.getAllColumnJavaNames()) {
			System.out.println("Search column " + col);
		}

		for (final String col : classMapper.getPrimaryKeyColumnJavaNames()) {
			System.out.println("Search column " + col);
			final IClassField<Employee, P> column = classMapper.getClassFieldByJavaName(col);
			assertTrue( column.isIdentifier() );
		}

		for (final String col : classMapper.getNotPrimaryKeyColumnJavaNames()) {
			System.out.println("Search column " + col);
			final IClassField<Employee, P> column = classMapper.getClassFieldByJavaName(col);
			assertFalse( column.isIdentifier() );
		}

		assertTrue( Arrays.asList(classMapper.getAllColumnJavaNames()).contains( "id" ) );
		assertTrue( Arrays.asList(classMapper.getAllColumnJavaNames()).contains( "age" ) );
		assertTrue( Arrays.asList(classMapper.getAllColumnJavaNames()).contains( "name" ) );
		assertTrue( Arrays.asList(classMapper.getAllColumnJavaNames()).contains( "surname" ) );
		assertTrue( Arrays.asList(classMapper.getAllColumnJavaNames()).contains( "employeeNumber" ) );

		assertTrue( Arrays.asList(classMapper.getPrimaryKeyColumnJavaNames()).contains( "id" ) );

		assertTrue( Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains( "age" ) );
		assertTrue( Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains( "name" ) );
		assertTrue( Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains( "surname" ) );
		assertTrue( Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains( "employeeNumber" ) );

		assertEquals( "ID" ,  classMapper.getClassFieldByJavaName("id").getColumnInfo().getDBColumnName() );
		assertEquals( "AGE" ,  classMapper.getClassFieldByJavaName("age").getColumnInfo().getDBColumnName() );
		assertEquals( "NAME" ,  classMapper.getClassFieldByJavaName("name").getColumnInfo().getDBColumnName() );
		assertEquals( "SURNAME" ,  classMapper.getClassFieldByJavaName("surname").getColumnInfo().getDBColumnName() );
		assertEquals( "EMPLOYEE_NUMBER" ,  classMapper.getClassFieldByJavaName("employeeNumber").getColumnInfo().getDBColumnName() );

	}

	@Test
	public <P> void testClassMapperGenerator2() throws Exception {

		final IClassMap<Blobclob_Stream> classMapper = new ClassMapBuilder<Blobclob_Stream>(Blobclob_Stream.class).generate();
		assertNotNull(classMapper);

		assertEquals("" ,classMapper.getTableInfo().getSchemaName());
		assertEquals("BLOBCLOB", classMapper.getTableInfo().getTableNameWithSchema());
		assertEquals(3 , classMapper.getAllColumnJavaNames().length );
		assertEquals(1 , classMapper.getPrimaryKeyColumnJavaNames().length );
		assertEquals(2 , classMapper.getNotPrimaryKeyColumnJavaNames().length );


		for (final String col : classMapper.getAllColumnJavaNames()) {
			System.out.println("Search column " + col);
		}

		for (final String col : classMapper.getPrimaryKeyColumnJavaNames()) {
			System.out.println("Search column " + col);
			final IClassField<Blobclob_Stream, P> column = classMapper.getClassFieldByJavaName(col);
			assertTrue( column.isIdentifier() );
		}

		for (final String col : classMapper.getNotPrimaryKeyColumnJavaNames()) {
			System.out.println("Search column " + col);
			final IClassField<Blobclob_Stream, P> column = classMapper.getClassFieldByJavaName(col);
			assertFalse( column.isIdentifier() );
		}

		assertTrue( Arrays.asList(classMapper.getAllColumnJavaNames()).contains( "id" ) );
		assertTrue( Arrays.asList(classMapper.getAllColumnJavaNames()).contains( "blobInputStream" ) );
		assertTrue( Arrays.asList(classMapper.getAllColumnJavaNames()).contains( "clob" ) );

		assertTrue( Arrays.asList(classMapper.getPrimaryKeyColumnJavaNames()).contains( "id" ) );

		assertTrue( Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains( "blobInputStream" ) );
		assertTrue( Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains( "clob" ) );

		assertEquals( "ID" ,  classMapper.getClassFieldByJavaName("id").getColumnInfo().getDBColumnName() );
		assertEquals( "BLOB" ,  classMapper.getClassFieldByJavaName("blobInputStream").getColumnInfo().getDBColumnName() );
		assertEquals( "CLOB" ,  classMapper.getClassFieldByJavaName("clob").getColumnInfo().getDBColumnName() );

	}

	@Test
	public <P> void testClassMapperGenerator3() throws Exception {

		final IClassMap<Blobclob_ByteArray> classMapper = new ClassMapBuilder<Blobclob_ByteArray>(Blobclob_ByteArray.class).generate();
		assertNotNull(classMapper);

		assertEquals("" , classMapper.getTableInfo().getSchemaName());
		assertEquals("BLOBCLOB", classMapper.getTableInfo().getTableNameWithSchema());
		assertEquals(3 , classMapper.getAllColumnJavaNames().length );
		assertEquals(1 , classMapper.getPrimaryKeyColumnJavaNames().length );
		assertEquals(2 , classMapper.getNotPrimaryKeyColumnJavaNames().length );
		assertEquals(1 , classMapper.getAllGeneratedColumnJavaNames().length );

		for (final String col : classMapper.getAllColumnJavaNames()) {
			System.out.println("Search column " + col);
		}

		for (final String col : classMapper.getPrimaryKeyColumnJavaNames()) {
			System.out.println("Search column " + col);
			final IClassField<Blobclob_ByteArray, P> column = classMapper.getClassFieldByJavaName(col);
			assertTrue( column.isIdentifier() );
		}

		for (final String col : classMapper.getNotPrimaryKeyColumnJavaNames()) {
			System.out.println("Search column " + col);
			final IClassField<Blobclob_ByteArray, P> column = classMapper.getClassFieldByJavaName(col);
			assertFalse( column.isIdentifier() );
		}

		assertTrue( Arrays.asList(classMapper.getAllColumnJavaNames()).contains( "index" ) );
		assertTrue( Arrays.asList(classMapper.getAllColumnJavaNames()).contains( "blob" ) );
		assertTrue( Arrays.asList(classMapper.getAllColumnJavaNames()).contains( "clob" ) );

		assertTrue( Arrays.asList(classMapper.getAllGeneratedColumnJavaNames()).contains( "index" ) );

		assertTrue( Arrays.asList(classMapper.getPrimaryKeyColumnJavaNames()).contains( "index" ) );

		assertTrue( Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains( "blob" ) );
		assertTrue( Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains( "clob" ) );

		assertEquals( "ID" ,  classMapper.getClassFieldByJavaName("index").getColumnInfo().getDBColumnName() );
		assertEquals( "BLOB" ,  classMapper.getClassFieldByJavaName("blob").getColumnInfo().getDBColumnName() );
		assertEquals( "CLOB" ,  classMapper.getClassFieldByJavaName("clob").getColumnInfo().getDBColumnName() );

	}

	@Test
	public void testBeanWithValuesGenerator() throws Exception {

		final IClassMap<BeanWithValuesGenerator> classMapper = new ClassMapBuilder<BeanWithValuesGenerator>(BeanWithValuesGenerator.class).generate();
		assertNotNull(classMapper);

	}


}
