package com.jpattern.orm.test.script;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.query.find.FindQuery;
import com.jpattern.orm.script.ScriptExecutor;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.transaction.Transaction;

/**
 * 
 * @author Francesco Cina
 *
 * 02/lug/2011
 */
public class ScriptExecutorTest extends BaseTestShared {

	private String filename;

	@Override
	protected void setUp() throws Exception {

		this.filename = getTestInputBasePath() + "/StreamParserTest_1.sql";
		assertTrue( new File(this.filename).exists() );
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testScript() throws Exception {
		executeScript( getJPOrm() );
		verifyData( getJPOrm() );
	}

	private void executeScript(final JPO jpOrm) throws Exception {

		final Session session = jpOrm.session();
		final Transaction tx = session.transaction();
		final ScriptExecutor scriptExecutor = session.scriptExecutor();

		final InputStream scriptStream = new FileInputStream(this.filename);
		scriptExecutor.execute(scriptStream);

		tx.commit();

	}

	private void verifyData(final JPO jpOrm) throws Exception {
		jpOrm.register(TempTable.class);

		final Session session = jpOrm.session();
		final FindQuery<TempTable> query = session.findQuery(TempTable.class);
		query.orderBy().asc("TempTable.id");
		final List<TempTable> result = query.findList();

		System.out.println("result.size() = " + result.size());
		assertTrue( result.size() == 11 );

		final List<String> expectedResult = new ArrayList<String>();
		expectedResult.add("one");
		expectedResult.add("two");
		expectedResult.add("three");
		expectedResult.add("four;");
		expectedResult.add("f'ive;");
		expectedResult.add("s'ix;");
		expectedResult.add("seven';{--ix;");
		expectedResult.add("height';{--ix;");
		expectedResult.add("ni';ne';{--ix;");
		expectedResult.add("ten';{--ix;");
		expectedResult.add("e'le;{--ven;");

		for ( int i=0 ; i<result.size() ; i++) {
			final TempTable temp = result.get(i);
			System.out.println("check element id: " + temp.getId() + " - name: " + temp.getName());
			assertEquals( expectedResult.get(i) , temp.getName());
		}

	}

}
