package com.jpattern.orm.test.session;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.mapper.NullOrmClassToolMap;
import com.jpattern.orm.persistor.type.TypeFactory;
import com.jpattern.orm.session.OrmSession;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.session.SessionProvider;
import com.jpattern.orm.transaction.Transaction;
import com.jpattern.orm.validator.NullValidator;

/**
 * 
 * @author Francesco Cina
 *
 * 05/giu/2011
 */
public class DataSourceConnectionTest extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testConnections() throws Exception {
		final SessionProvider provider = getJPOrm().getSessionProvider();
		loopTransaction( provider );
		loopConnection( provider );
	}

	public void loopTransaction(final SessionProvider dsProvider) throws Exception {
		final Session conn = new OrmSession(new NullOrmClassToolMap(), dsProvider.getSessionStrategy(), new TypeFactory(), new NullValidator());

		final int howMany = 1000;

		for (int i=0; i<howMany; i++) {
			final Transaction tx = conn.transaction();
			tx.commit();
			System.out.println("commit: " + i);
		}

		for (int i=0; i<howMany; i++) {
			final Transaction tx = conn.transaction();
			tx.rollback();
			System.out.println("rollback: " + i);
		}
	}

	public void loopConnection(final SessionProvider dsProvider) throws Exception {

		final int howMany = 100;

		for (int i=0; i<howMany; i++) {
			final Session conn = new OrmSession(new NullOrmClassToolMap(), dsProvider.getSessionStrategy(), new TypeFactory(), new NullValidator());
			final Transaction tx = conn.transaction();
			tx.commit();
			System.out.println("commit: " + i);
		}

		for (int i=0; i<howMany; i++) {
			final Session conn = new OrmSession(new NullOrmClassToolMap(), dsProvider.getSessionStrategy(), new TypeFactory(), new NullValidator());
			final Transaction tx = conn.transaction();
			tx.rollback();
			System.out.println("rollback: " + i);
		}
	}
}
