package com.jpattern.orm.test.session;

import static org.junit.Assert.*;

import java.util.Random;

import org.junit.Test;

import com.jpattern.orm.JPO;
import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.People_ConditionalGenerator;
import com.jpattern.orm.transaction.Transaction;

/**
 * 
 * @author Francesco Cina'
 *
 * Apr 1, 2012
 */
public class SessionConditionalGeneratorTest extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testFailSavingASavedBean() throws Exception {
		final JPO orm = getJPOrm();
		final Session session = orm.session();
		final Transaction tx = session.transaction();
		try {

			People_ConditionalGenerator people = new People_ConditionalGenerator();
			final long originalId = people.getId();
			people.setFirstname("people name 1");
			people = session.save(people);

			assertFalse( people.getId() == originalId );
			assertTrue( people.getId() >= 0 );

			assertEquals( "people name 1", session.findUnique(People_ConditionalGenerator.class, 1).getFirstname());

			boolean error = false;
			try {
				people.setFirstname("people name 2");
				people = session.save(people);
				System.out.println("wrong saved id: " + people.getId());
				assertTrue(false);
			} catch (final Exception e) {
				assertTrue( e.getMessage().contains("primary") );
				error = true;
			}

			assertTrue(error);

			assertEquals( "people name 1", session.findUnique(People_ConditionalGenerator.class, 1).getFirstname());
		} catch (final Exception e) {

		} finally {
			tx.commit();
		}
	}

	@Test
	public void testSavingBeanWithArbitraryId() throws Exception {
		final JPO orm = getJPOrm();
		final Session session = orm.session();
		final long id = new Random().nextInt();

		final Transaction tx = session.transaction();
		try {

			People_ConditionalGenerator people = new People_ConditionalGenerator();
			people.setFirstname("people name 1");
			people.setId(id);
			people = session.save(people);

			System.out.println("saved id: " + people.getId());
			assertEquals( id, people.getId() );

			assertEquals( "people name 1", session.findUnique(People_ConditionalGenerator.class, id).getFirstname());

			boolean error = false;
			try {
				People_ConditionalGenerator people2 = new People_ConditionalGenerator();
				people2.setFirstname("people name 2");
				people2.setId(id);
				people2 = session.save(people2);
				people2 = session.save(people2);
				System.out.println("wrong saved id: " + people2.getId());
				assertTrue(false);
			} catch (final Exception e) {
				assertTrue( e.getMessage().contains("primary") );
				error = true;
			}
			assertTrue(error);

			assertEquals( "people name 1", session.findUnique(People_ConditionalGenerator.class, id).getFirstname());

		} catch (final Exception e) {

		} finally {
			tx.commit();
		}

	}
}
