package com.jpattern.orm.test.session;

import static org.junit.Assert.*;

import java.util.Date;
import java.util.Random;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.AutoId;
import com.jpattern.orm.test.domain.AutoIdInteger;
import com.jpattern.orm.test.domain.DataVersionWithoutGenerator;
import com.jpattern.orm.test.domain.Employee;
import com.jpattern.orm.transaction.Transaction;

/**
 * 
 * @author Francesco Cina
 *
 * 20/mag/2011
 */
public class SessionSaveOrUpdateTest extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testSaveOrUpdateWithConditionGenerator() throws Exception {
		final JPO jpOrm =getJPOrm();

		AutoId autoId = new AutoId();
		final String value = "value for test " + new Date().getTime();
		autoId.setValue(value);

		final int oldId = autoId.getId();

		final Session conn = jpOrm.session();
		final Transaction tx = conn.transaction();

		autoId = conn.saveOrUpdate(autoId);
		final int newId = autoId.getId();

		assertNotSame(oldId, newId);
		assertEquals(value, conn.find(AutoId.class, newId).getValue());

		final String newValue = "new value for test " + new Date().getTime();
		autoId.setValue(newValue);

		autoId = conn.saveOrUpdate(autoId);

		assertEquals(newId, autoId.getId());
		assertEquals(newValue, conn.find(AutoId.class, newId).getValue());

		tx.commit();

	}

	@Test
	public void testSaveOrUpdateWithNotConditionGenerator() throws Exception {
		final JPO jpOrm =getJPOrm();

		AutoIdInteger autoId = new AutoIdInteger();
		final String value = "value for test " + new Date().getTime();
		autoId.setValue(value);

		final Integer oldId = autoId.getId();

		final Session conn = jpOrm.session();
		final Transaction tx = conn.transaction();

		try {
			autoId = conn.saveOrUpdate(autoId);
			Integer newId = autoId.getId();

			assertNotSame(oldId, newId);
			assertEquals(value, conn.find(AutoId.class, newId).getValue());

			final String newValue = "new value for test " + new Date().getTime();
			autoId.setValue(newValue);

			autoId = conn.saveOrUpdate(autoId);

			assertEquals(newId, autoId.getId());
			assertEquals(newValue, conn.find(AutoId.class, newId).getValue());
		}
		finally {
			tx.commit();
		}

	}

	@Test
	public void testSaveOrUpdateWithoutGenerator() throws Exception {
		final JPO jpOrm =getJPOrm();

		final int id = new Random().nextInt();
		Employee employee = new Employee();
		employee.setId( id );
		employee.setAge( 44 );
		employee.setEmployeeNumber( "empNumber" + id );
		employee.setName("oldName");
		employee.setSurname("Cina");

		// CREATE
		final Session conn = jpOrm.session();
		final Transaction tx = conn.transaction();
		employee = conn.save(employee);

		assertEquals("oldName", conn.find(Employee.class, id).getName());

		employee.setName("newName");

		employee = conn.saveOrUpdate(employee);

		assertEquals("newName", conn.find(Employee.class, id).getName());

		tx.commit();

	}

	@Test
	public void testSaveOrUpdateObjectWithVersionWithoutGenerator() throws Exception {
		final JPO jpOrm = getJPOrm();

		// CREATE
		final Session conn = jpOrm.session();
		final Transaction tx = conn.transaction();

		conn.deleteQuery(DataVersionWithoutGenerator.class);

		DataVersionWithoutGenerator bean = new DataVersionWithoutGenerator();
		int id = 1000;
		bean.setId(id);

		bean = conn.saveOrUpdate(bean);

		assertEquals(0, conn.find(DataVersionWithoutGenerator.class, id).getVersion());

		bean = conn.saveOrUpdate(bean);

		assertEquals(1, conn.find(DataVersionWithoutGenerator.class, id).getVersion());

		tx.commit();

	}
}
