package com.jpattern.orm.test.session;

import static org.junit.Assert.assertEquals;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.session.GeneratedKeyReader;
import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SqlPerformer;
import com.jpattern.orm.transaction.Transaction;

/**
 * 
 * @author Francesco Cina
 *
 * 02/lug/2011
 */
public class SqlExecutorsTest extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testExecuteAll() throws Exception {
		final JPO jpOrm = getJPOrm();

		final Session session = jpOrm.session();
		final SqlPerformer sqlExecutor = ((SessionSqlPerformer)session).sqlPerformer();

		Transaction tx = session.transaction();
		final List<Long> ids = sqlExecutorInsert( sqlExecutor );
		tx.commit();

		checkExistAll(ids , sqlExecutor , true);

		tx = session.transaction();
		sqlExecutorDelete( ids, sqlExecutor );
		tx.commit();

		checkExistAll(ids , sqlExecutor , false);

	}


	private void sqlExecutorDelete(final List<Long> ids, final SqlPerformer sqlExecutor) {
		final String sql = "delete from people where id = ?";

		final List<Object[]> args = new ArrayList<Object[]>();

		for (final Long id : ids) {
			args.add(new Object[]{id});
		}

		sqlExecutor.batchUpdate(sql, args);

	}

	private List<Long> sqlExecutorInsert(final SqlPerformer sqlExec) {
		final List<Long> results = new ArrayList<Long>();

		long idMain = new Date().getTime();

		final long id1 = idMain++;
		results.add(id1);
		final String sqlFixed = "insert into people (id, firstname, lastname) values ( " + id1 + " , 'fixed name' , 'fixed surname' )";
		assertEquals( 1 , sqlExec.update(sqlFixed));

		final String sql1 = "insert into people (id, firstname, lastname) values ( ? , ? , ? )";
		final long id2 = idMain++;
		results.add(id2);
		assertEquals( 1 , sqlExec.update(sql1, new Object[]{ id2, "name-" + id2 , "surname-" + id2 }));

		final List<Object[]> args = new ArrayList<Object[]>();
		final long id3 = idMain++;
		final long id4 = idMain++;
		final long id5 = idMain++;
		results.add(id3);
		results.add(id4);
		results.add(id5);
		args.add( new Object[]{ id3, "name-" + id3 , "batchUpdate(sql1, args) " + id3 } );
		args.add( new Object[]{ id4, "name-" + id4 , "batchUpdate(sql1, args) " + id4 } );
		args.add( new Object[]{ id5, "name-" + id5 , "batchUpdate(sql1, args) " + id5 } );
		assertEquals( 3 , sqlExec.batchUpdate(sql1, args).length );

		final List<String> sqlsFixed = new ArrayList<String>();
		final long id6 = idMain++;
		final long id7 = idMain++;
		results.add(id6);
		results.add(id7);
		sqlsFixed.add("insert into people (id, firstname, lastname) values ( " + id6 + " , 'batchUpdate(sqlsFixed)' , '1' )");
		sqlsFixed.add("insert into people (id, firstname, lastname) values ( " + id7 + " , 'batchUpdate(sqlsFixed)' , '2' )");
		assertEquals( 2 , sqlExec.batchUpdate(sqlsFixed).length );

		final String sqlKeyExtractor = "insert into people (id, firstname, lastname) values ( SEQ_PEOPLE.nextval , ? , ? )";
		final GeneratedKeyReader generatedKeyExtractor = new GeneratedKeyReader() {
			/**
			 * 
			 */


			@Override
			public void read(final ResultSet generatedKeyResultSet) throws SQLException {
				generatedKeyResultSet.next();
				final long gk = generatedKeyResultSet.getLong(1);
				System.out.println("Generated key: " + gk);
				results.add(gk);
			}

			@Override
			public String[] generatedColumnNames() {
				return new String[]{"ID"};
			}
		};
		assertEquals( 1 , sqlExec.update(sqlKeyExtractor, generatedKeyExtractor, new Object[]{ "sqlExec.update(sqlKeyExtractor, generatedKeyExtractor, args", "1"}) );

		return results;
	}

	private void checkExistAll(final List<Long> peopleIds, final SqlPerformer sqlExecutor, final boolean exist) {
		String sql = "select * from people where id in ( ";
		for (int i=0; i<(peopleIds.size()-1); i++) {
			sql += "?, ";
		}
		sql += "? ) ";

		final ResultSetReader<List<Long>> rse = new ResultSetReader<List<Long>>() {
			@Override
			public List<Long> read(final ResultSet resultSet) throws SQLException {
				final List<Long> result = new ArrayList<Long>();
				while (resultSet.next()) {
					result.add( resultSet.getLong("ID") );
				}
				return result;
			}
		};

		final List<Long> result = sqlExecutor.query(sql, rse, peopleIds.toArray());
		for (final Long id : peopleIds) {
			System.out.println("Check id: " + id + " exists? " + result.contains(id) );
			assertEquals( exist,  result.contains(id) );
		}
	}
}
