package com.jpattern.orm.test.transaction;

import static org.junit.Assert.assertNull;

import java.util.Random;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Employee;
import com.jpattern.orm.transaction.Transaction;

/**
 * 
 * @author Francesco Cina
 *
 * 20/mag/2011
 */
public class EmployeeTransactionTest extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testTransaction1() throws Exception {
		final JPO jpOrm =getJPOrm();

		jpOrm.register(Employee.class);

		final int id = new Random().nextInt();
		final Employee employee = new Employee();
		employee.setId( id );
		employee.setAge( 44 );
		employee.setEmployeeNumber( ("empNumber_" + id) );
		employee.setName("Wizard");
		employee.setSurname("Cina");

		// CREATE
		final Session conn = jpOrm.session();
		Transaction tx = conn.transaction();
		conn.save(employee);
		tx.rollback();

		// LOAD
		tx = conn.transaction();
		final Employee employeeLoad1 = conn.find(Employee.class, new Object[]{id});
		assertNull(employeeLoad1);
		tx.commit();

	}

}
