package com.jpattern.orm.test.transaction;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.util.Date;

import org.junit.Test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.People;
import com.jpattern.orm.transaction.Transaction;

/**
 * 
 * @author Francesco Cina
 *
 * 20/mag/2011
 */
public class JdbcTemplatePeopleTest extends BaseTestShared {

	@Override
	protected void setUp() throws Exception {
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testJdbcTemplateTransaction1() throws Exception {
		final JPO jpOrm = getJPOrm();
		jpOrm.register(People.class);

		Transaction tx = jpOrm.session().transaction();
		final long id = create( jpOrm );
		tx.commit();

		tx = jpOrm.session().transaction();
		People loaded = load(jpOrm, id);
		tx.commit();
		assertNotNull(loaded);

		tx = jpOrm.session().transaction();
		delete(jpOrm, loaded);
		tx.rollback();

		tx = jpOrm.session().transaction();
		loaded = load(jpOrm, id);
		tx.commit();
		assertNotNull(loaded);

		tx = jpOrm.session().transaction();
		delete(jpOrm, loaded);
		tx.setRollbackOnly();
		tx.commit();

		tx = jpOrm.session().transaction();
		loaded = load(jpOrm, id);
		tx.commit();
		assertNotNull(loaded);

		tx = jpOrm.session().transaction();
		delete(jpOrm, loaded);
		tx.commit();

		tx = jpOrm.session().transaction();
		loaded = load(jpOrm, id);
		tx.commit();
		assertNull(loaded);
	}


	private long create(JPO jpOrm) throws Exception {

		final long id = new Date().getTime();
		People people = new People();
		people.setId( id );
		people.setFirstname( "people" );
		people.setLastname("Wizard");

		// CREATE
		final Session conn = jpOrm.session();
		people = conn.save(people);

		System.out.println("People saved with id: " + people.getId());
		assertFalse( id == people.getId() );
		return people.getId();

	}

	private People load(JPO jpOrm, long id) throws Exception {
		// LOAD
		final Session conn = jpOrm.session();
		final People peopleLoad1 = conn.find(People.class, new Object[]{id});
		return peopleLoad1;
	}

	//	private void update(IJPOrm jpOrm, People people) throws Exception {
	//        //UPDATE
	//		people.setFirstname("Wizard name");
	//		ISession conn = jpOrm.session();
	//        conn.update(people);
	//	}

	private void delete(JPO jpOrm, People people) throws Exception {
		//DELETE
		final Session conn = jpOrm.session();
		conn.delete(people);
	}

}
