package com.jpattern.orm.test.version;

import static org.junit.Assert.*;

import org.junit.Test;

import com.jpattern.orm.JPO;
import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.exception.OrmOptimisticLockException;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.DataVersionInteger;
import com.jpattern.orm.test.domain.DataVersionLong;
import com.jpattern.orm.test.domain.DataVersionSqlDate;
import com.jpattern.orm.transaction.Transaction;

/**
 * 
 * @author cinafr
 *
 */
public class VersionTest extends BaseTestShared {

	private Session session;

	@Override
	protected void setUp() throws Exception {
		final JPO jpOrm = this.getJPOrm();

		jpOrm.register(DataVersionInteger.class);
		jpOrm.register(DataVersionLong.class);

		this.session = jpOrm.session();
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Test
	public void testLongNewRecordVersion() throws Exception {

		DataVersionLong dataVersion = new DataVersionLong();
		dataVersion.setData("dataVersion1");

		Transaction tx = this.session.transaction();
		dataVersion = this.session.save(dataVersion);
		final long currentVersion = dataVersion.getVersion();
		assertEquals(0l, currentVersion);
		tx.commit();

		tx = this.session.transaction();
		dataVersion = this.session.update(dataVersion);
		assertEquals(currentVersion+1 , dataVersion.getVersion());
		tx.commit();

		tx = this.session.transaction();
		dataVersion = this.session.update(dataVersion);
		assertEquals(currentVersion+2 , dataVersion.getVersion());
		tx.commit();
	}

	@Test
	public void testLongNewRecordVersionWithCustomVersionNumber() throws Exception {

		DataVersionLong dataVersion = new DataVersionLong();
		dataVersion.setData("dataVersion1");
		dataVersion.setVersion(1000);

		Transaction tx = this.session.transaction();
		dataVersion = this.session.save(dataVersion);
		final long currentVersion = dataVersion.getVersion();
		assertEquals(0l, currentVersion);
		tx.commit();

		tx = this.session.transaction();
		dataVersion = this.session.update(dataVersion);
		assertEquals(currentVersion+1 , dataVersion.getVersion());
		tx.commit();

		tx = this.session.transaction();
		dataVersion = this.session.update(dataVersion);
		assertEquals(currentVersion+2 , dataVersion.getVersion());
		tx.commit();
	}

	@Test
	public void testLongWrongVersionNumber() throws Exception {

		DataVersionLong dataVersion = new DataVersionLong();
		dataVersion.setData("dataVersion1");
		dataVersion.setVersion(1000);

		Transaction tx = this.session.transaction();
		dataVersion = this.session.save(dataVersion);
		final long currentVersion = dataVersion.getVersion();
		assertEquals(0l, currentVersion);
		tx.commit();

		tx = this.session.transaction();
		dataVersion = this.session.update(dataVersion);
		assertEquals(currentVersion+1 , dataVersion.getVersion());
		tx.commit();

		tx = this.session.transaction();
		boolean wrongVersion = false;
		try {
			dataVersion.setVersion(1000);
			dataVersion = this.session.update(dataVersion);
		} catch (final OrmOptimisticLockException e) {
			e.printStackTrace();
			wrongVersion = true;
		}
		assertTrue(wrongVersion);
		tx.commit();
	}

	@Test
	public void testSqlDateNewRecordVersion() throws Exception {
		try {
			this.getJPOrm().register(DataVersionSqlDate.class);
			fail("A OrmConfigurationException should be thrwon before!!");
		} catch (OrmConfigurationException e) {
			// ok
		}
	}

	@Test
	public void testIntegerNewRecordVersion() throws Exception {

		DataVersionInteger dataVersion = new DataVersionInteger();
		dataVersion.setData("dataVersion1");
		assertNull( dataVersion.getVersion() );

		Transaction tx = this.session.transaction();
		dataVersion = this.session.save(dataVersion);
		final Integer currentVersion = dataVersion.getVersion();
		assertEquals( Integer.valueOf(0), currentVersion);
		tx.commit();

		tx = this.session.transaction();
		dataVersion = this.session.update(dataVersion);
		assertEquals(Integer.valueOf(currentVersion+1) , dataVersion.getVersion());
		tx.commit();

		tx = this.session.transaction();
		boolean wrongVersion = false;
		try {
			dataVersion.setVersion(1000);
			dataVersion = this.session.update(dataVersion);
		} catch (final OrmOptimisticLockException e) {
			e.printStackTrace();
			wrongVersion = true;
		}
		assertTrue(wrongVersion);
		tx.commit();
	}

}
