/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm;

import com.jpattern.orm.JPOrm;
import com.jpattern.orm.JPOrmTestData;
import com.jpattern.orm.test.SpringSkipTestRunner;
import com.jpattern.shared.util.Chronometer;
import java.io.File;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=SpringSkipTestRunner.class)
@ContextConfiguration(locations={"classpath:spring-context.xml"})
public abstract class BaseTestShared {
    @Rule
    public final TestName name = new TestName();
    private final Chronometer chronometer = new Chronometer();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private JPOrmTestData jpOrmTestData;

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUpBeforeTest() throws Exception {
        if (!this.jpOrmTestData.isDbAvailable()) {
            Assume.assumeTrue((boolean)true);
        }
        this.chronometer.restart();
        this.logger.info("===================================================================");
        this.logger.info("BEGIN TEST " + this.name.getMethodName());
        this.logger.info("===================================================================");
        this.setUp();
    }

    @After
    public void tearDownAfterTest() throws Exception {
        this.tearDown();
        this.chronometer.pause();
        String time = new BigDecimal(this.chronometer.read()).divide(new BigDecimal(1000)).toString();
        this.logger.info("===================================================================");
        this.logger.info("END TEST " + this.name.getMethodName());
        this.logger.info("Execution time: " + time + " seconds");
        this.logger.info("===================================================================");
    }

    protected abstract void setUp() throws Exception;

    protected abstract void tearDown() throws Exception;

    protected String getTestInputBasePath() throws Exception {
        return "../jporm-test-base-db-script//test-files";
    }

    protected String getTestOutputBasePath() throws Exception {
        this.mkDir("./target/test/files");
        return "./target/test/files";
    }

    protected void mkDir(String dirPath) throws Exception {
        File path = new File(dirPath);
        if (!path.exists()) {
            path.mkdirs();
        }
    }

    protected JPOrm getJPOrm() {
        return new JPOrm(this.jpOrmTestData.getSessionProvider());
    }
}

