/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.AutoId;
import com.jpattern.orm.test.domain.AutoIdInteger;
import com.jpattern.orm.transaction.Transaction;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class AutoIdTest
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testAutoId() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(AutoId.class);
        AutoId autoId = new AutoId();
        autoId.setValue("value for test " + new Date().getTime());
        Session conn = jpOrm.session();
        Transaction tx = conn.transaction();
        autoId = (AutoId)conn.save((Object)autoId);
        tx.commit();
        System.out.println("autoId id: " + autoId.getId());
        Assert.assertTrue((autoId.getId() >= 100 ? 1 : 0) != 0);
        AutoId autoIdLoad1 = (AutoId)conn.find(AutoId.class, (Object)autoId.getId());
        Assert.assertNotNull((Object)autoIdLoad1);
        Assert.assertEquals((long)autoId.getId(), (long)autoIdLoad1.getId());
        Assert.assertEquals((Object)autoId.getValue(), (Object)autoIdLoad1.getValue());
        tx = conn.transaction();
        autoIdLoad1.setValue("new Value " + new Date().getTime());
        autoIdLoad1 = (AutoId)conn.update((Object)autoIdLoad1);
        tx.commit();
        AutoId autoIdLoad2 = (AutoId)conn.find(AutoId.class, (Object)autoId.getId());
        Assert.assertNotNull((Object)autoIdLoad2);
        Assert.assertEquals((long)autoIdLoad1.getId(), (long)autoIdLoad2.getId());
        Assert.assertEquals((Object)autoIdLoad1.getValue(), (Object)autoIdLoad2.getValue());
        tx = conn.transaction();
        conn.delete((Object)autoIdLoad2);
        tx.commit();
        AutoId autoIdLoad3 = (AutoId)conn.find(AutoId.class, (Object)autoId.getId());
        Assert.assertNull((Object)autoIdLoad3);
    }

    @Test
    public void testAutoIdInteger() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(AutoIdInteger.class);
        AutoIdInteger autoId = new AutoIdInteger();
        autoId.setValue("value for test " + new Date().getTime());
        Session conn = jpOrm.session();
        Transaction tx = conn.transaction();
        autoId = (AutoIdInteger)conn.save((Object)autoId);
        tx.commit();
        System.out.println("autoId id: " + autoId.getId());
        Assert.assertTrue((autoId.getId() >= 100 ? 1 : 0) != 0);
        AutoIdInteger autoIdLoad1 = (AutoIdInteger)conn.find(AutoIdInteger.class, (Object)autoId.getId());
        Assert.assertNotNull((Object)autoIdLoad1);
        Assert.assertEquals((Object)autoId.getId(), (Object)autoIdLoad1.getId());
        Assert.assertEquals((Object)autoId.getValue(), (Object)autoIdLoad1.getValue());
        tx = conn.transaction();
        autoIdLoad1.setValue("new Value " + new Date().getTime());
        autoIdLoad1 = (AutoIdInteger)conn.update((Object)autoIdLoad1);
        tx.commit();
        AutoIdInteger autoIdLoad2 = (AutoIdInteger)conn.find(AutoIdInteger.class, (Object)autoId.getId());
        Assert.assertNotNull((Object)autoIdLoad2);
        Assert.assertEquals((Object)autoIdLoad1.getId(), (Object)autoIdLoad2.getId());
        Assert.assertEquals((Object)autoIdLoad1.getValue(), (Object)autoIdLoad2.getValue());
        tx = conn.transaction();
        conn.delete((Object)autoIdLoad2);
        tx.commit();
        AutoIdInteger autoIdLoad3 = (AutoIdInteger)conn.find(AutoIdInteger.class, (Object)autoId.getId());
        Assert.assertNull((Object)autoIdLoad3);
    }
}

