/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Employee;
import com.jpattern.orm.transaction.Transaction;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class EmployeeTest
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testCrudEmployee() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(Employee.class);
        int id = new Random().nextInt();
        Employee employee = new Employee();
        employee.setId(id);
        employee.setAge(44);
        employee.setEmployeeNumber("empNumber" + id);
        employee.setName("Wizard");
        employee.setSurname("Cina");
        Session conn = jpOrm.session();
        Transaction tx = conn.transaction();
        conn.save((Object)employee);
        tx.commit();
        tx = conn.transaction();
        Employee employeeLoad1 = (Employee)conn.find(Employee.class, new Object[]{id});
        Assert.assertNotNull((Object)employeeLoad1);
        Assert.assertEquals((Object)employee.getId(), (Object)employeeLoad1.getId());
        Assert.assertEquals((Object)employee.getName(), (Object)employeeLoad1.getName());
        Assert.assertEquals((Object)employee.getSurname(), (Object)employeeLoad1.getSurname());
        Assert.assertEquals((Object)employee.getEmployeeNumber(), (Object)employeeLoad1.getEmployeeNumber());
        employeeLoad1.setName("Wizard");
        conn.update((Object)employeeLoad1);
        tx.commit();
        tx = conn.transaction();
        Employee employeeLoad2 = (Employee)conn.find(Employee.class, new Object[]{id});
        Assert.assertNotNull((Object)employeeLoad2);
        Assert.assertEquals((Object)employeeLoad1.getId(), (Object)employeeLoad2.getId());
        Assert.assertEquals((Object)employeeLoad1.getName(), (Object)employeeLoad2.getName());
        Assert.assertEquals((Object)employeeLoad1.getSurname(), (Object)employeeLoad2.getSurname());
        Assert.assertEquals((Object)employeeLoad1.getEmployeeNumber(), (Object)employeeLoad2.getEmployeeNumber());
        conn.delete((Object)employeeLoad2);
        Employee employeeLoad3 = (Employee)conn.find(Employee.class, new Object[]{id});
        Assert.assertNull((Object)employeeLoad3);
        tx.commit();
    }
}

