/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.query.find.FindQuery;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.People;
import com.jpattern.orm.transaction.Transaction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PeopleMultipleTest
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testCrudPeopleMultiple() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(People.class);
        List<People> peoples = new ArrayList<People>();
        peoples.add(this.createPeople("1"));
        peoples.add(this.createPeople("2"));
        peoples.add(this.createPeople("3"));
        peoples.add(this.createPeople("4"));
        Session conn = jpOrm.session();
        Transaction tx = conn.transaction();
        peoples = conn.save(peoples);
        tx.commit();
        for (People people : peoples) {
            System.out.println("People [" + people.getFirstname() + "]saved with id: " + people.getId());
        }
        FindQuery peopleQuery1 = conn.findQuery(People.class);
        Assert.assertNotNull((Object)peopleQuery1);
        ArrayList<Long> values = new ArrayList<Long>();
        for (People people : peoples) {
            values.add(people.getId());
        }
        peopleQuery1.where().in("People.id", values);
        List peopleLoad1 = peopleQuery1.findList();
        this.compare(peoples, peopleLoad1);
        tx = conn.transaction();
        for (People people : peoples) {
            people.setFirstname(people.getFirstname() + "-updated-" + new Date().getTime());
        }
        peoples = conn.update(peoples);
        tx.commit();
        FindQuery peopleQuery2 = conn.findQuery(People.class);
        Assert.assertNotNull((Object)peopleQuery2);
        peopleQuery2.where().in("People.id", values);
        List peopleLoad2 = peopleQuery2.findList();
        this.compare(peoples, peopleLoad2);
        tx = conn.transaction();
        conn.delete(peopleLoad2);
        tx.commit();
        FindQuery peopleQuery3 = conn.findQuery(People.class);
        Assert.assertNotNull((Object)peopleQuery3);
        peopleQuery3.where().in("People.id", values);
        List peopleLoad3 = peopleQuery3.findList();
        Assert.assertTrue((boolean)peopleLoad3.isEmpty());
    }

    private void compare(List<People> peoples, List<People> peoplesLoad) {
        Assert.assertEquals((long)peoples.size(), (long)peoplesLoad.size());
        for (People people : peoples) {
            System.out.println("check people: " + people.getId());
            boolean found = false;
            for (People peopleLoad : peoplesLoad) {
                if (peopleLoad.getId() != people.getId()) continue;
                found = true;
                Assert.assertEquals((Object)people.getFirstname(), (Object)peopleLoad.getFirstname());
                Assert.assertEquals((Object)people.getLastname(), (Object)peopleLoad.getLastname());
            }
            Assert.assertTrue((boolean)found);
        }
    }

    private People createPeople(String name) {
        long id = new Date().getTime();
        People people = new People();
        people.setId(id);
        people.setFirstname(name);
        people.setLastname("lastname of " + name);
        return people;
    }
}

