/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.People;
import com.jpattern.orm.transaction.Transaction;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class PeopleTest
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testCrudPeople() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(People.class);
        long id = new Date().getTime();
        People people = new People();
        people.setId(id);
        people.setFirstname("people");
        people.setLastname("Wizard");
        Assert.assertFalse((boolean)jpOrm.session().exist((Object)people));
        Session conn = jpOrm.session();
        Transaction tx = conn.transaction();
        people = (People)conn.save((Object)people);
        tx.commit();
        System.out.println("People saved with id: " + people.getId());
        Assert.assertFalse((id == people.getId() ? 1 : 0) != 0);
        id = people.getId();
        Assert.assertTrue((boolean)jpOrm.session().exist((Object)people));
        tx = conn.transaction();
        People peopleLoad1 = (People)conn.find(People.class, (Object)id);
        Assert.assertNotNull((Object)peopleLoad1);
        Assert.assertEquals((long)people.getId(), (long)peopleLoad1.getId());
        Assert.assertEquals((Object)people.getFirstname(), (Object)peopleLoad1.getFirstname());
        Assert.assertEquals((Object)people.getLastname(), (Object)peopleLoad1.getLastname());
        peopleLoad1.setFirstname("Wizard name");
        peopleLoad1 = (People)conn.update((Object)peopleLoad1);
        tx.commit();
        tx = conn.transaction();
        People peopleLoad2 = (People)conn.find(People.class, new Object[]{id});
        Assert.assertNotNull((Object)peopleLoad2);
        Assert.assertEquals((long)peopleLoad1.getId(), (long)peopleLoad2.getId());
        Assert.assertEquals((Object)peopleLoad1.getFirstname(), (Object)peopleLoad2.getFirstname());
        Assert.assertEquals((Object)peopleLoad1.getLastname(), (Object)peopleLoad2.getLastname());
        conn.delete((Object)peopleLoad2);
        tx.commit();
        tx = conn.transaction();
        People peopleLoad3 = (People)conn.find(People.class, new Object[]{id});
        Assert.assertNull((Object)peopleLoad3);
        tx.commit();
    }
}

