/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.query.delete.DeleteWhere;
import com.jpattern.orm.query.find.FindWhere;
import com.jpattern.orm.query.update.UpdateSet;
import com.jpattern.orm.query.update.UpdateWhere;
import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.WrapperTypeTable;
import com.jpattern.orm.transaction.Transaction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class WrapperTypeTableTest
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testCrudWithWrapperType() {
        JPOrm jpOrm = this.getJPOrm();
        DateMidnight endDate = new DateMidnight(DateTimeZone.UTC);
        DateTime startDate = new DateTime(DateTimeZone.UTC);
        Date now = new Date();
        WrapperTypeTable wrapper1 = new WrapperTypeTable();
        wrapper1.setNow(now);
        wrapper1.setEndDate(endDate);
        wrapper1.setStartDate(startDate);
        Assert.assertEquals((Object)-1L, (Object)wrapper1.getId());
        Session conn = jpOrm.session();
        Transaction tx = conn.transaction();
        wrapper1 = (WrapperTypeTable)conn.save((Object)wrapper1);
        tx.commit();
        System.out.println("wrapper1 id: " + wrapper1.getId());
        Assert.assertTrue((wrapper1.getId() >= Long.valueOf(0L) ? 1 : 0) != 0);
        this.seeDBValues(conn, wrapper1.getId());
        WrapperTypeTable wrapperLoad1 = (WrapperTypeTable)conn.find(WrapperTypeTable.class, (Object)wrapper1.getId());
        Assert.assertNotNull((Object)wrapperLoad1);
        Assert.assertEquals((Object)wrapper1.getId(), (Object)wrapperLoad1.getId());
        Assert.assertNull((Object)wrapperLoad1.getValid());
        Assert.assertEquals((Object)now, (Object)wrapperLoad1.getNow());
        Assert.assertEquals((Object)DateTimeZone.UTC, (Object)wrapperLoad1.getStartDate().getZone());
        Assert.assertEquals((Object)startDate, (Object)wrapperLoad1.getStartDate());
        Assert.assertEquals((Object)endDate, (Object)wrapperLoad1.getEndDate());
        tx = conn.transaction();
        endDate = new DateMidnight(DateTimeZone.UTC);
        startDate = new DateTime(DateTimeZone.UTC);
        boolean valid = true;
        wrapperLoad1.setEndDate(endDate);
        wrapperLoad1.setStartDate(startDate);
        wrapperLoad1.setValid(true);
        wrapperLoad1 = (WrapperTypeTable)conn.update((Object)wrapperLoad1);
        Assert.assertEquals((Object)DateTimeZone.UTC, (Object)wrapperLoad1.getStartDate().getZone());
        tx.commit();
        WrapperTypeTable wrapperLoad2 = (WrapperTypeTable)conn.find(WrapperTypeTable.class, (Object)wrapper1.getId());
        Assert.assertNotNull((Object)wrapperLoad2);
        Assert.assertEquals((Object)wrapperLoad1.getId(), (Object)wrapperLoad2.getId());
        Assert.assertEquals((Object)true, (Object)wrapperLoad2.getValid());
        Assert.assertEquals((Object)DateTimeZone.UTC, (Object)wrapperLoad2.getStartDate().getZone());
        Assert.assertEquals((Object)startDate, (Object)wrapperLoad2.getStartDate());
        Assert.assertEquals((Object)endDate, (Object)wrapperLoad2.getEndDate());
        Assert.assertEquals((Object)now, (Object)wrapperLoad1.getNow());
        tx = conn.transaction();
        conn.delete((Object)wrapperLoad2);
        tx.commit();
        WrapperTypeTable wrapperLoad3 = (WrapperTypeTable)conn.find(WrapperTypeTable.class, (Object)wrapper1.getId());
        Assert.assertNull((Object)wrapperLoad3);
    }

    @Test
    public void testQueryWithWrapperType() {
        JPOrm jpOrm = this.getJPOrm();
        DateMidnight endDate = new DateMidnight(DateTimeZone.UTC);
        DateTime startDate = new DateTime(DateTimeZone.UTC);
        Date now = new Date();
        WrapperTypeTable wrapper1 = new WrapperTypeTable();
        wrapper1.setNow(now);
        wrapper1.setEndDate(endDate);
        wrapper1.setStartDate(startDate);
        Assert.assertEquals((Object)-1L, (Object)wrapper1.getId());
        Session conn = jpOrm.session();
        Transaction tx = conn.transaction();
        wrapper1 = (WrapperTypeTable)conn.save((Object)wrapper1);
        tx.commit();
        System.out.println("wrapper1 id: " + wrapper1.getId());
        Assert.assertTrue((wrapper1.getId() >= Long.valueOf(0L) ? 1 : 0) != 0);
        this.seeDBValues(conn, wrapper1.getId());
        WrapperTypeTable wrapperLoad1 = (WrapperTypeTable)((FindWhere)((FindWhere)((FindWhere)conn.findQuery(WrapperTypeTable.class).where().eq("startDate", (Object)startDate)).eq("now", (Object)now)).eq("endDate", (Object)endDate)).findUnique();
        Assert.assertNotNull((Object)wrapperLoad1);
        Assert.assertEquals((Object)wrapper1.getId(), (Object)wrapperLoad1.getId());
        Assert.assertNull((Object)wrapperLoad1.getValid());
        Assert.assertEquals((Object)now, (Object)wrapperLoad1.getNow());
        Assert.assertEquals((Object)startDate, (Object)wrapperLoad1.getStartDate());
        Assert.assertEquals((Object)endDate, (Object)wrapperLoad1.getEndDate());
        tx = conn.transaction();
        endDate = new DateMidnight(DateTimeZone.UTC);
        startDate = new DateTime(DateTimeZone.UTC);
        boolean valid = true;
        int updated = ((UpdateWhere)((UpdateSet)((UpdateSet)((UpdateSet)conn.updateQuery(WrapperTypeTable.class).set().eq("startDate", (Object)startDate)).eq("valid", (Object)true)).eq("endDate", (Object)endDate)).where().eq("id", (Object)wrapper1.getId())).perform();
        Assert.assertEquals((long)1L, (long)updated);
        tx.commit();
        WrapperTypeTable wrapperLoad2 = (WrapperTypeTable)((FindWhere)conn.findQuery(WrapperTypeTable.class).where().eq("id", (Object)wrapper1.getId())).findUnique();
        Assert.assertNotNull((Object)wrapperLoad2);
        Assert.assertEquals((Object)wrapperLoad1.getId(), (Object)wrapperLoad2.getId());
        Assert.assertEquals((Object)true, (Object)wrapperLoad2.getValid());
        Assert.assertEquals((Object)startDate, (Object)wrapperLoad2.getStartDate());
        Assert.assertEquals((Object)endDate, (Object)wrapperLoad2.getEndDate());
        Assert.assertEquals((Object)now, (Object)wrapperLoad1.getNow());
        tx = conn.transaction();
        int deleted = ((DeleteWhere)conn.deleteQuery(WrapperTypeTable.class).where().eq("id", (Object)wrapper1.getId())).perform();
        Assert.assertEquals((long)1L, (long)deleted);
        tx.commit();
        Assert.assertTrue((boolean)((FindWhere)conn.findQuery(WrapperTypeTable.class).where().eq("id", (Object)wrapper1.getId())).findList().isEmpty());
    }

    private void seeDBValues(Session conn, Long id) {
        ResultSetReader<Object> rse = new ResultSetReader<Object>(){

            public Object read(ResultSet resultSet) throws SQLException {
                while (resultSet.next()) {
                    System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++");
                    System.out.println("Object found:");
                    System.out.println("id: " + resultSet.getLong("id"));
                    System.out.println("now: " + resultSet.getTimestamp("now"));
                    System.out.println("start_date: " + resultSet.getTimestamp("start_date"));
                    System.out.println("end_date: " + resultSet.getTimestamp("end_date"));
                    System.out.println("valid: " + resultSet.getBigDecimal("valid"));
                    System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++");
                }
                return null;
            }
        };
        conn.sqlExecutor().findQuery("select * from WRAPPER_TYPE_TABLE", new Object[0]).find((ResultSetReader)rse);
    }
}

