/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.crud;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.crud.CRUDQuery;
import com.jpattern.orm.crud.OrmCRUDQueryGenerator;
import com.jpattern.orm.dialect.DefaultDialect;
import com.jpattern.orm.dialect.Dialect;
import com.jpattern.orm.mapper.clazz.ClassMapBuilder;
import com.jpattern.orm.mapper.clazz.IClassMap;
import com.jpattern.orm.session.SessionProvider;
import com.jpattern.orm.test.domain.Employee;
import com.jpattern.orm.test.domain.People;
import com.jpattern.orm.test.domain.Zoo_People;
import org.junit.Assert;
import org.junit.Test;

public class OrmCRUDQueryGeneratorTest
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testOrmProvider() throws Exception {
        SessionProvider connectionProvider = this.getJPOrm().getSessionProvider();
        this.ormCrudWithSequence(connectionProvider);
        this.ormCrud(connectionProvider);
        this.ormCrudWithSchema(connectionProvider);
        this.ormCrudSelectFromClause(connectionProvider);
    }

    public void ormCrudWithSequence(SessionProvider sessionProvider) throws Exception {
        IClassMap classMapper = new ClassMapBuilder(People.class).generate();
        Assert.assertNotNull((Object)classMapper);
        OrmCRUDQueryGenerator ormGenerator = new OrmCRUDQueryGenerator((Dialect)new DefaultDialect(), classMapper);
        CRUDQuery ormCrudQuery = ormGenerator.generate();
        Assert.assertNotNull((Object)ormCrudQuery);
        System.out.println(ormCrudQuery.getLoadQuery());
        System.out.println(ormCrudQuery.getUpdateQuery());
        System.out.println(ormCrudQuery.getDeleteQuery());
        System.out.println(ormCrudQuery.getSaveQuery());
    }

    public void ormCrud(SessionProvider sessionProvider) throws Exception {
        IClassMap classMapper = new ClassMapBuilder(Employee.class).generate();
        Assert.assertNotNull((Object)classMapper);
        OrmCRUDQueryGenerator ormGenerator = new OrmCRUDQueryGenerator((Dialect)new DefaultDialect(), classMapper);
        CRUDQuery ormCrudQuery = ormGenerator.generate();
        Assert.assertNotNull((Object)ormCrudQuery);
        System.out.println(ormCrudQuery.getLoadQuery());
        System.out.println(ormCrudQuery.getUpdateQuery());
        System.out.println(ormCrudQuery.getDeleteQuery());
        System.out.println(ormCrudQuery.getSaveQuery());
    }

    public void ormCrudWithSchema(SessionProvider sessionProvider) throws Exception {
        IClassMap classMapper = new ClassMapBuilder(Zoo_People.class).generate();
        Assert.assertNotNull((Object)classMapper);
        OrmCRUDQueryGenerator ormGenerator = new OrmCRUDQueryGenerator((Dialect)new DefaultDialect(), classMapper);
        CRUDQuery ormCrudQuery = ormGenerator.generate();
        Assert.assertNotNull((Object)ormCrudQuery);
        System.out.println(ormCrudQuery.getLoadQuery());
        System.out.println(ormCrudQuery.getUpdateQuery());
        System.out.println(ormCrudQuery.getDeleteQuery());
        System.out.println(ormCrudQuery.getSaveQuery());
    }

    public void ormCrudSelectFromClause(SessionProvider sessionProvider) throws Exception {
        IClassMap classMapper = new ClassMapBuilder(Zoo_People.class).generate();
        Assert.assertNotNull((Object)classMapper);
        OrmCRUDQueryGenerator ormGenerator = new OrmCRUDQueryGenerator((Dialect)new DefaultDialect(), classMapper);
        CRUDQuery ormCrudQuery = ormGenerator.generate();
        Assert.assertNotNull((Object)ormCrudQuery);
        System.out.println(ormCrudQuery.getBaseSelectClause());
        System.out.println(ormCrudQuery.getBaseSelectClause("alias."));
        System.out.println(ormCrudQuery.getBaseFromClause());
        Assert.assertEquals((Object)"ZOO.PEOPLE.FIRSTCLOB, ZOO.PEOPLE.ID, ZOO.PEOPLE.SECONDBLOB, ZOO.PEOPLE.BIRTHDATE, ZOO.PEOPLE.LASTNAME, ZOO.PEOPLE.FIRSTNAME, ZOO.PEOPLE.FIRSTBLOB, ZOO.PEOPLE.DEATHDATE", (Object)ormCrudQuery.getBaseSelectClause());
        Assert.assertEquals((Object)"alias.FIRSTCLOB, alias.ID, alias.SECONDBLOB, alias.BIRTHDATE, alias.LASTNAME, alias.FIRSTNAME, alias.FIRSTBLOB, alias.DEATHDATE", (Object)ormCrudQuery.getBaseSelectClause("alias."));
        Assert.assertEquals((Object)"ZOO.PEOPLE", (Object)ormCrudQuery.getBaseFromClause());
    }
}

