/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.exception;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.exception.sql.OrmSqlDataIntegrityViolationException;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Employee;
import com.jpattern.orm.transaction.Transaction;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class ConstraintViolationExceptionTest
extends BaseTestShared {
    private JPO jpOrm;

    @Override
    protected void setUp() throws Exception {
        this.jpOrm = this.getJPOrm();
        this.jpOrm.register(Employee.class);
    }

    @Override
    protected void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstraintViolationException() throws Exception {
        int id = new Random().nextInt();
        Employee employee = new Employee();
        employee.setId(id);
        employee.setAge(44);
        employee.setEmployeeNumber("empNumber_" + id);
        employee.setName("Wizard");
        employee.setSurname("Cina");
        Session conn = this.jpOrm.session();
        Transaction tx = conn.transaction();
        try {
            conn.save((Object)employee);
            conn.save((Object)employee);
            tx.commit();
        }
        catch (OrmSqlDataIntegrityViolationException e) {
            System.out.println("Constraint violation intercepted. Message [" + e.getMessage() + "]");
        }
        catch (Exception e) {
            Assert.fail((String)("A specific exception should be thrown, but is " + e));
        }
        finally {
            tx.rollback();
        }
    }
}

