/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.h2;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Blobclob_Stream;
import com.jpattern.orm.transaction.Transaction;
import com.jpattern.orm.util.OrmUtil;
import java.io.InputStream;
import java.io.Reader;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class BlobClob_InputStream_Reader_Test
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testCrudBlobclob() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(Blobclob_Stream.class);
        long id = new Date().getTime();
        String text1 = "BINARY STRING TEST 1 " + id;
        InputStream is1 = OrmUtil.convertStringToStream((String)text1, (String)OrmUtil.UTF8);
        String text2 = "BINARY STRING TEST 2 " + id;
        Reader reader2 = OrmUtil.convertStringToReader((String)text2);
        Blobclob_Stream blobclob = new Blobclob_Stream();
        blobclob.setBlobInputStream(is1);
        blobclob.setClob(reader2);
        Session conn = jpOrm.session();
        Transaction tx = conn.transaction();
        blobclob = (Blobclob_Stream)conn.save((Object)blobclob);
        tx.commit();
        reader2.close();
        is1.close();
        System.out.println("Blobclob saved with id: " + blobclob.getId());
        Assert.assertFalse((id == blobclob.getId() ? 1 : 0) != 0);
        id = blobclob.getId();
        tx = conn.transaction();
        Blobclob_Stream blobclobLoad1 = (Blobclob_Stream)conn.find(Blobclob_Stream.class, new Object[]{id});
        Assert.assertNotNull((Object)blobclobLoad1);
        Assert.assertEquals((long)blobclob.getId(), (long)blobclobLoad1.getId());
        String retrieved1 = OrmUtil.convertStreamToString((InputStream)blobclobLoad1.getBlobInputStream(), (String)OrmUtil.UTF8, (boolean)false);
        System.out.println("Retrieved1 String " + retrieved1);
        Assert.assertEquals((Object)text1, (Object)retrieved1);
        String retrieved2 = OrmUtil.convertReaderToString((Reader)blobclobLoad1.getClob(), (boolean)false);
        System.out.println("Retrieved2 String " + retrieved2);
        Assert.assertEquals((Object)text2, (Object)retrieved2);
        conn.delete((Object)blobclobLoad1);
        Blobclob_Stream blobclobLoad2 = (Blobclob_Stream)conn.find(Blobclob_Stream.class, new Object[]{id});
        Assert.assertNull((Object)blobclobLoad2);
        tx.commit();
    }
}

