/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.h2;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Zoo_People;
import com.jpattern.orm.transaction.Transaction;
import com.jpattern.orm.util.OrmUtil;
import java.io.InputStream;
import java.io.Reader;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class ZooPeopleTest
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testCrudZoo() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(Zoo_People.class);
        long id = new Date().getTime();
        String text1 = "BINARY STRING TEST 1 " + id;
        InputStream is = OrmUtil.convertStringToStream((String)text1, (String)OrmUtil.UTF8);
        String text2 = "BINARY STRING TEST 2 " + id;
        Reader reader = OrmUtil.convertStringToReader((String)text2);
        Zoo_People zooPeople = new Zoo_People();
        zooPeople.setId(id);
        zooPeople.setFirstname("Zoo_People");
        zooPeople.setLastname("Wizard");
        zooPeople.setFirstblob(is);
        zooPeople.setFirstclob(reader);
        Session conn = jpOrm.session();
        Transaction tx = conn.transaction();
        zooPeople = (Zoo_People)conn.save((Object)zooPeople);
        tx.commit();
        reader.close();
        is.close();
        System.out.println("Zoo_People saved with id: " + zooPeople.getId());
        Assert.assertFalse((id == zooPeople.getId() ? 1 : 0) != 0);
        id = zooPeople.getId();
        tx = conn.transaction();
        Zoo_People peopleLoad1 = (Zoo_People)conn.find(Zoo_People.class, new Object[]{id});
        Assert.assertNotNull((Object)peopleLoad1);
        Assert.assertEquals((long)zooPeople.getId(), (long)peopleLoad1.getId());
        Assert.assertEquals((Object)zooPeople.getFirstname(), (Object)peopleLoad1.getFirstname());
        Assert.assertEquals((Object)zooPeople.getLastname(), (Object)peopleLoad1.getLastname());
        String retrieved1 = OrmUtil.convertStreamToString((InputStream)peopleLoad1.getFirstblob(), (String)OrmUtil.UTF8, (boolean)false);
        System.out.println("Retrieved1 String " + retrieved1);
        Assert.assertEquals((Object)text1, (Object)retrieved1);
        String retrieved2 = OrmUtil.convertReaderToString((Reader)peopleLoad1.getFirstclob(), (boolean)false);
        System.out.println("Retrieved2 String " + retrieved2);
        Assert.assertEquals((Object)text2, (Object)retrieved2);
        peopleLoad1.setFirstname("Wizard name");
        peopleLoad1 = (Zoo_People)conn.update((Object)peopleLoad1);
        tx.commit();
        tx = conn.transaction();
        Zoo_People peopleLoad2 = (Zoo_People)conn.find(Zoo_People.class, new Object[]{id});
        Assert.assertNotNull((Object)peopleLoad2);
        Assert.assertEquals((long)peopleLoad1.getId(), (long)peopleLoad2.getId());
        Assert.assertEquals((Object)peopleLoad1.getFirstname(), (Object)peopleLoad2.getFirstname());
        Assert.assertEquals((Object)peopleLoad1.getLastname(), (Object)peopleLoad2.getLastname());
        conn.delete((Object)peopleLoad2);
        Zoo_People peopleLoad3 = (Zoo_People)conn.find(Zoo_People.class, new Object[]{id});
        Assert.assertNull((Object)peopleLoad3);
        tx.commit();
    }
}

