/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.mapper;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.mapper.clazz.ClassMapBuilder;
import com.jpattern.orm.mapper.clazz.IClassField;
import com.jpattern.orm.mapper.clazz.IClassMap;
import com.jpattern.orm.test.domain.BeanWithValuesGenerator;
import com.jpattern.orm.test.domain.Blobclob_ByteArray;
import com.jpattern.orm.test.domain.Blobclob_Stream;
import com.jpattern.orm.test.domain.Employee;
import java.util.Arrays;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class ClassMapperGeneratorTest
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public <P> void testClassMapperGenerator1() throws Exception {
        IClassField column;
        IClassMap classMapper = new ClassMapBuilder(Employee.class).generate();
        Assert.assertNotNull((Object)classMapper);
        Assert.assertEquals((Object)"", (Object)classMapper.getTableInfo().getSchemaName());
        Assert.assertEquals((Object)"EMPLOYEE", (Object)classMapper.getTableInfo().getTableNameWithSchema());
        Assert.assertEquals((long)5L, (long)classMapper.getAllColumnJavaNames().length);
        Assert.assertEquals((long)1L, (long)classMapper.getPrimaryKeyColumnJavaNames().length);
        Assert.assertEquals((long)4L, (long)classMapper.getNotPrimaryKeyColumnJavaNames().length);
        try {
            classMapper.getClassFieldByJavaName("" + new Date().getTime());
            Assert.fail((String)"An exception should be thrwn here!");
        }
        catch (OrmException e) {
            // empty catch block
        }
        for (String col : classMapper.getAllColumnJavaNames()) {
            System.out.println("Search column " + col);
        }
        for (String col : classMapper.getPrimaryKeyColumnJavaNames()) {
            System.out.println("Search column " + col);
            column = classMapper.getClassFieldByJavaName(col);
            Assert.assertTrue((boolean)column.isIdentifier());
        }
        for (String col : classMapper.getNotPrimaryKeyColumnJavaNames()) {
            System.out.println("Search column " + col);
            column = classMapper.getClassFieldByJavaName(col);
            Assert.assertFalse((boolean)column.isIdentifier());
        }
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getAllColumnJavaNames()).contains("id"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getAllColumnJavaNames()).contains("age"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getAllColumnJavaNames()).contains("name"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getAllColumnJavaNames()).contains("surname"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getAllColumnJavaNames()).contains("employeeNumber"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getPrimaryKeyColumnJavaNames()).contains("id"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains("age"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains("name"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains("surname"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains("employeeNumber"));
        Assert.assertEquals((Object)"ID", (Object)classMapper.getClassFieldByJavaName("id").getColumnInfo().getDBColumnName());
        Assert.assertEquals((Object)"AGE", (Object)classMapper.getClassFieldByJavaName("age").getColumnInfo().getDBColumnName());
        Assert.assertEquals((Object)"NAME", (Object)classMapper.getClassFieldByJavaName("name").getColumnInfo().getDBColumnName());
        Assert.assertEquals((Object)"SURNAME", (Object)classMapper.getClassFieldByJavaName("surname").getColumnInfo().getDBColumnName());
        Assert.assertEquals((Object)"EMPLOYEE_NUMBER", (Object)classMapper.getClassFieldByJavaName("employeeNumber").getColumnInfo().getDBColumnName());
    }

    @Test
    public <P> void testClassMapperGenerator2() throws Exception {
        IClassField column;
        IClassMap classMapper = new ClassMapBuilder(Blobclob_Stream.class).generate();
        Assert.assertNotNull((Object)classMapper);
        Assert.assertEquals((Object)"", (Object)classMapper.getTableInfo().getSchemaName());
        Assert.assertEquals((Object)"BLOBCLOB", (Object)classMapper.getTableInfo().getTableNameWithSchema());
        Assert.assertEquals((long)3L, (long)classMapper.getAllColumnJavaNames().length);
        Assert.assertEquals((long)1L, (long)classMapper.getPrimaryKeyColumnJavaNames().length);
        Assert.assertEquals((long)2L, (long)classMapper.getNotPrimaryKeyColumnJavaNames().length);
        for (String col : classMapper.getAllColumnJavaNames()) {
            System.out.println("Search column " + col);
        }
        for (String col : classMapper.getPrimaryKeyColumnJavaNames()) {
            System.out.println("Search column " + col);
            column = classMapper.getClassFieldByJavaName(col);
            Assert.assertTrue((boolean)column.isIdentifier());
        }
        for (String col : classMapper.getNotPrimaryKeyColumnJavaNames()) {
            System.out.println("Search column " + col);
            column = classMapper.getClassFieldByJavaName(col);
            Assert.assertFalse((boolean)column.isIdentifier());
        }
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getAllColumnJavaNames()).contains("id"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getAllColumnJavaNames()).contains("blobInputStream"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getAllColumnJavaNames()).contains("clob"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getPrimaryKeyColumnJavaNames()).contains("id"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains("blobInputStream"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains("clob"));
        Assert.assertEquals((Object)"ID", (Object)classMapper.getClassFieldByJavaName("id").getColumnInfo().getDBColumnName());
        Assert.assertEquals((Object)"BLOB", (Object)classMapper.getClassFieldByJavaName("blobInputStream").getColumnInfo().getDBColumnName());
        Assert.assertEquals((Object)"CLOB", (Object)classMapper.getClassFieldByJavaName("clob").getColumnInfo().getDBColumnName());
    }

    @Test
    public <P> void testClassMapperGenerator3() throws Exception {
        IClassField column;
        IClassMap classMapper = new ClassMapBuilder(Blobclob_ByteArray.class).generate();
        Assert.assertNotNull((Object)classMapper);
        Assert.assertEquals((Object)"", (Object)classMapper.getTableInfo().getSchemaName());
        Assert.assertEquals((Object)"BLOBCLOB", (Object)classMapper.getTableInfo().getTableNameWithSchema());
        Assert.assertEquals((long)3L, (long)classMapper.getAllColumnJavaNames().length);
        Assert.assertEquals((long)1L, (long)classMapper.getPrimaryKeyColumnJavaNames().length);
        Assert.assertEquals((long)2L, (long)classMapper.getNotPrimaryKeyColumnJavaNames().length);
        Assert.assertEquals((long)1L, (long)classMapper.getAllGeneratedColumnJavaNames().length);
        for (String col : classMapper.getAllColumnJavaNames()) {
            System.out.println("Search column " + col);
        }
        for (String col : classMapper.getPrimaryKeyColumnJavaNames()) {
            System.out.println("Search column " + col);
            column = classMapper.getClassFieldByJavaName(col);
            Assert.assertTrue((boolean)column.isIdentifier());
        }
        for (String col : classMapper.getNotPrimaryKeyColumnJavaNames()) {
            System.out.println("Search column " + col);
            column = classMapper.getClassFieldByJavaName(col);
            Assert.assertFalse((boolean)column.isIdentifier());
        }
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getAllColumnJavaNames()).contains("index"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getAllColumnJavaNames()).contains("blob"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getAllColumnJavaNames()).contains("clob"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getAllGeneratedColumnJavaNames()).contains("index"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getPrimaryKeyColumnJavaNames()).contains("index"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains("blob"));
        Assert.assertTrue((boolean)Arrays.asList(classMapper.getNotPrimaryKeyColumnJavaNames()).contains("clob"));
        Assert.assertEquals((Object)"ID", (Object)classMapper.getClassFieldByJavaName("index").getColumnInfo().getDBColumnName());
        Assert.assertEquals((Object)"BLOB", (Object)classMapper.getClassFieldByJavaName("blob").getColumnInfo().getDBColumnName());
        Assert.assertEquals((Object)"CLOB", (Object)classMapper.getClassFieldByJavaName("clob").getColumnInfo().getDBColumnName());
    }

    @Test
    public void testBeanWithValuesGenerator() throws Exception {
        IClassMap classMapper = new ClassMapBuilder(BeanWithValuesGenerator.class).generate();
        Assert.assertNotNull((Object)classMapper);
    }
}

